/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.views;

import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.model.AppSecData;
import com.vaadin.appsec.backend.model.analysis.AssessmentStatus;
import com.vaadin.appsec.backend.model.dto.Dependency;
import com.vaadin.appsec.backend.model.dto.SeverityLevel;
import com.vaadin.appsec.backend.model.dto.Vulnerability;
import com.vaadin.appsec.backend.model.osv.response.Ecosystem;
import com.vaadin.appsec.views.AbstractAppSecView;
import com.vaadin.appsec.views.VulnerabilityDetailsView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilitiesView
extends AbstractAppSecView {
    private final Logger logger = LoggerFactory.getLogger(VulnerabilitiesView.class);
    private Grid<Vulnerability> grid;
    private ComboBox<Ecosystem> ecosystem;
    private ComboBox<Dependency> dependency;
    private ComboBox<SeverityLevel> severity;
    private ComboBox<String> riskScore;
    private ComboBox<AssessmentStatus> vaadinAnalysis;
    private ComboBox<AppSecData.VulnerabilityStatus> developerAnalysis;
    private final AbstractAppSecView parent;
    private final ValueProvider<Vulnerability, Ecosystem> ecosystemValueProvider = (ValueProvider & Serializable)vuln -> vuln.getDependency().getEcosystem();

    public VulnerabilitiesView(AbstractAppSecView parent) {
        this.parent = parent;
        this.buildFilters();
        this.buildGrid();
        this.buildShowDetailsButton();
    }

    public void filterOn(Dependency item) {
        this.clearFilters();
        this.dependency.setValue((Object)item);
        this.applyFilters();
    }

    @Override
    protected void clearFilters() {
        this.ecosystem.setValue(null);
        this.dependency.setValue(null);
        this.vaadinAnalysis.setValue(null);
        this.developerAnalysis.setValue(null);
        this.severity.setValue(null);
        this.riskScore.setValue(null);
        this.getListDataProvider().clearFilters();
    }

    @Override
    protected void applyFilters() {
        Ecosystem ecosystemFilter = (Ecosystem)this.ecosystem.getValue();
        Dependency dependencyFilter = (Dependency)this.dependency.getValue();
        AssessmentStatus vaadinAnalysisFilter = (AssessmentStatus)this.vaadinAnalysis.getValue();
        AppSecData.VulnerabilityStatus developerAnalysisFilter = (AppSecData.VulnerabilityStatus)this.developerAnalysis.getValue();
        SeverityLevel severityFilter = (SeverityLevel)this.severity.getValue();
        Double riskScoreFilter = this.riskScore.getValue() != null ? this.getRiskScoreFromFilter((String)this.riskScore.getValue()) : null;
        this.getListDataProvider().setFilter((SerializablePredicate & Serializable)vulnerabilityDTO -> {
            if (ecosystemFilter != null && !ecosystemFilter.equals((Object)vulnerabilityDTO.getDependency().getEcosystem())) {
                return false;
            }
            if (dependencyFilter != null && !dependencyFilter.equals((Object)vulnerabilityDTO.getDependency())) {
                return false;
            }
            if (vaadinAnalysisFilter != null && !vaadinAnalysisFilter.equals((Object)this.getAssessmentStatus((Vulnerability)vulnerabilityDTO))) {
                return false;
            }
            if (developerAnalysisFilter != null && !developerAnalysisFilter.equals((Object)vulnerabilityDTO.getDeveloperStatus())) {
                return false;
            }
            if (severityFilter != null && !severityFilter.equals((Object)vulnerabilityDTO.getSeverityLevel())) {
                return false;
            }
            return riskScoreFilter == null || riskScoreFilter <= vulnerabilityDTO.getRiskScore();
        });
    }

    @Override
    public void refresh() {
        Set selectedItems = this.grid.getSelectedItems();
        this.grid.deselectAll();
        List vulnerabilities = AppSecService.getInstance().getVulnerabilities();
        this.grid.setItems((Collection)vulnerabilities);
        this.dependency.setItems((Collection)this.getListDataProvider().getItems().stream().map(Vulnerability::getDependency).collect(Collectors.toSet()));
        this.applyFilters();
        selectedItems.forEach(arg_0 -> this.grid.select(arg_0));
        this.prepareExportData(vulnerabilities);
    }

    private void prepareExportData(List<Vulnerability> vulnerabilityList) {
        this.exportLink.setEnabled(false);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter(outputStream), CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"Vulnerability name or identifier", "Ecosystem", "Dependency", "Severity", "CVSS score", "Vaadin analysis", "Developer analysis"});
            for (Vulnerability vulnerability : vulnerabilityList) {
                printer.printRecord(new Object[]{vulnerability.getIdentifier(), this.ecosystemValueProvider.apply((Object)vulnerability), vulnerability.getDependency(), vulnerability.getSeverityLevel(), vulnerability.getRiskScore(), this.getAssessmentStatus(vulnerability), vulnerability.getDeveloperAnalysis()});
            }
            String fileName = "vulnerabilities.csv";
            StreamResource streamResource = new StreamResource(fileName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(outputStream.toByteArray()));
            this.updateExportData(streamResource);
            this.exportLink.setEnabled(true);
        }
        catch (IOException e) {
            this.logger.error("Error preparing export data", (Throwable)e);
            Notification errorNotification = new Notification("Data cannot be exported due to an error.", 5000, Notification.Position.TOP_END);
            errorNotification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
            errorNotification.open();
        }
    }

    private Double getRiskScoreFromFilter(String riskScoreFilter) {
        String[] parts = riskScoreFilter.split("=");
        return Double.valueOf(parts[1]);
    }

    private void buildFilters() {
        this.ecosystem = new ComboBox("Ecosystem");
        this.ecosystem.setItems((Object[])new Ecosystem[]{Ecosystem.MAVEN, Ecosystem.NPM});
        this.ecosystem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.dependency = new ComboBox("Dependency");
        this.dependency.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.dependency.getStyle().set("--vaadin-combo-box-overlay-width", "350px");
        this.vaadinAnalysis = new ComboBox("Vaadin analysis");
        this.vaadinAnalysis.setItems((Object[])new AssessmentStatus[]{AssessmentStatus.TRUE_POSITIVE, AssessmentStatus.FALSE_POSITIVE, AssessmentStatus.UNDER_REVIEW});
        this.vaadinAnalysis.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.developerAnalysis = new ComboBox("Developer analysis");
        this.developerAnalysis.setItems((Object[])new AppSecData.VulnerabilityStatus[]{AppSecData.VulnerabilityStatus.NOT_SET, AppSecData.VulnerabilityStatus.NOT_AFFECTED, AppSecData.VulnerabilityStatus.FALSE_POSITIVE, AppSecData.VulnerabilityStatus.IN_TRIAGE, AppSecData.VulnerabilityStatus.EXPLOITABLE});
        this.developerAnalysis.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.severity = new ComboBox("Severity");
        this.severity.setItems((Object[])new SeverityLevel[]{SeverityLevel.NONE, SeverityLevel.LOW, SeverityLevel.MEDIUM, SeverityLevel.HIGH, SeverityLevel.CRITICAL});
        this.severity.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.riskScore = new ComboBox("CVSS score");
        this.riskScore.setItems((Object[])new String[]{">=0", ">=1", ">=2", ">=3", ">=4", ">=5", ">=6", ">=7", ">=8", ">=9", "=10"});
        this.riskScore.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        Component filterBar = this.buildFilterBar(new Component[]{this.ecosystem, this.dependency, this.vaadinAnalysis, this.developerAnalysis, this.severity, this.riskScore});
        this.getMainContent().add(new Component[]{filterBar});
    }

    private void buildGrid() {
        this.grid = new Grid();
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.setMultiSort(true, Grid.MultiSortPriority.APPEND);
        this.grid.setSizeFull();
        ((Grid.Column)this.grid.addColumn(Vulnerability::getIdentifier).setHeader("Vulnerability name or identifier").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(this.ecosystemValueProvider).setHeader("Ecosystem").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Vulnerability::getDependency).setHeader("Dependency").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Vulnerability::getSeverityLevel).setHeader("Severity").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Vulnerability::getRiskScore).setHeader("CVSS score").setResizable(true)).setSortable(true).setTooltipGenerator(Vulnerability::getCvssString);
        ((Grid.Column)this.grid.addColumn(this::getAssessmentStatus).setHeader("Vaadin analysis").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Vulnerability::getDeveloperStatus).setHeader("Developer analysis").setResizable(true)).setSortable(true);
        this.grid.addItemClickListener((ComponentEventListener & Serializable)e -> {
            if (e.getClickCount() == 2) {
                this.showVulnerabilityDetails((Vulnerability)e.getItem());
            }
        });
        this.getMainContent().addAndExpand(new Component[]{this.grid});
    }

    private AssessmentStatus getAssessmentStatus(Vulnerability vulnerability) {
        return vulnerability.getAffectedVersion() != null ? vulnerability.getAffectedVersion().getStatus() : null;
    }

    private void buildShowDetailsButton() {
        Button showDetails = new Button("Show details");
        showDetails.setEnabled(false);
        showDetails.getElement().setAttribute("aria-label", "Show details");
        showDetails.addClickListener((ComponentEventListener & Serializable)e -> this.showVulnerabilityDetails((Vulnerability)this.grid.getSelectedItems().iterator().next()));
        this.grid.addSelectionListener((SelectionListener & Serializable)e -> showDetails.setEnabled(e.getFirstSelectedItem().isPresent()));
        this.getMainContent().add(new Component[]{showDetails});
        this.getMainContent().setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{showDetails});
    }

    private void showVulnerabilityDetails(Vulnerability vulnerabilityDTO) {
        this.parent.showDetails((Component)new VulnerabilityDetailsView(vulnerabilityDTO, () -> {
            this.parent.showMainContent();
            this.refresh();
        }));
    }

    private ListDataProvider<Vulnerability> getListDataProvider() {
        return (ListDataProvider)this.grid.getDataProvider();
    }
}

