/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.views;

import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.model.dto.Dependency;
import com.vaadin.appsec.backend.model.dto.SeverityLevel;
import com.vaadin.appsec.backend.model.osv.response.Ecosystem;
import com.vaadin.appsec.views.AbstractAppSecView;
import com.vaadin.appsec.views.AppSecView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesView
extends AbstractAppSecView {
    private final Logger logger = LoggerFactory.getLogger(DependenciesView.class);
    private Grid<Dependency> grid;
    private GridListDataView<Dependency> dataView;
    private TextField searchField;
    private ComboBox<Ecosystem> ecosystem;
    private ComboBox<String> group;
    private ComboBox<Boolean> isDevelopment;
    private ComboBox<SeverityLevel> severity;
    private ComboBox<String> riskScore;
    private final boolean includeNpmDevDeps;
    private final AppSecView parent;

    public DependenciesView(AppSecView parent) {
        this.parent = parent;
        this.includeNpmDevDeps = AppSecService.getInstance().getConfiguration().isIncludeNpmDevDependencies();
        this.buildFilters();
        this.buildGrid();
        this.buildShowVulnerabilitiesButton();
        this.configureSearchField();
    }

    @Override
    protected void clearFilters() {
        this.searchField.setValue("");
        this.ecosystem.setValue(null);
        this.group.setValue(null);
        if (this.includeNpmDevDeps) {
            this.isDevelopment.setValue(null);
        }
        this.severity.setValue(null);
        this.riskScore.setValue(null);
        this.getListDataProvider().clearFilters();
    }

    @Override
    protected void applyFilters() {
        Ecosystem ecosystemFilter = (Ecosystem)this.ecosystem.getValue();
        String groupFilter = (String)this.group.getValue();
        Boolean isDevelopmentFilter = this.includeNpmDevDeps ? (Boolean)this.isDevelopment.getValue() : null;
        SeverityLevel severityFilter = (SeverityLevel)this.severity.getValue();
        Double riskScoreFilter = this.riskScore.getValue() != null ? this.getRiskScoreFromFilter((String)this.riskScore.getValue()) : null;
        this.getListDataProvider().setFilter((SerializablePredicate & Serializable)dependencyDTO -> {
            if (ecosystemFilter != null && !ecosystemFilter.equals((Object)dependencyDTO.getEcosystem())) {
                return false;
            }
            if (groupFilter != null && !groupFilter.equals(dependencyDTO.getGroup())) {
                return false;
            }
            if (this.includeNpmDevDeps && isDevelopmentFilter != null && isDevelopmentFilter == false == dependencyDTO.isDevDependency()) {
                return false;
            }
            if (severityFilter != null && !severityFilter.equals((Object)dependencyDTO.getSeverityLevel())) {
                return false;
            }
            return riskScoreFilter == null || riskScoreFilter <= dependencyDTO.getRiskScore();
        });
    }

    @Override
    public void refresh() {
        Set selectedItems = this.grid.getSelectedItems();
        this.grid.deselectAll();
        List dependencies = AppSecService.getInstance().getDependencies();
        this.dataView = (GridListDataView)this.grid.setItems((Collection)dependencies);
        this.dataView.addFilter((SerializablePredicate & Serializable)dependency -> {
            String searchTerm = this.searchField.getValue().trim();
            if (searchTerm.isEmpty()) {
                return true;
            }
            return dependency.getName().contains(searchTerm);
        });
        List<String> sortedGroups = this.getListDataProvider().getItems().stream().map(Dependency::getGroup).filter(Objects::nonNull).distinct().sorted().toList();
        this.group.setItems(sortedGroups);
        this.applyFilters();
        selectedItems.forEach(arg_0 -> this.grid.select(arg_0));
        this.prepareExportData(dependencies);
    }

    private void prepareExportData(List<Dependency> dependencyList) {
        this.exportLink.setEnabled(false);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter(outputStream), CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"Dependency", "Ecosystem", "Dependency group", "Version", "Is development?", "# of vulnerabilities", "Highest severity", "Highest CVSS score"});
            for (Dependency dependency : dependencyList) {
                printer.printRecord(new Object[]{dependency.getName(), dependency.getEcosystem(), dependency.getGroup(), dependency.getVersion(), dependency.isDevDependency(), dependency.getNumOfVulnerabilities(), dependency.getSeverityLevel(), dependency.getRiskScore()});
            }
            String fileName = "dependencies.csv";
            StreamResource streamResource = new StreamResource(fileName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(outputStream.toByteArray()));
            this.updateExportData(streamResource);
            this.exportLink.setEnabled(true);
        }
        catch (IOException e) {
            this.logger.error("Error preparing export data", (Throwable)e);
            Notification errorNotification = new Notification("Data cannot be exported due to an error.", 5000, Notification.Position.TOP_END);
            errorNotification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
            errorNotification.open();
        }
    }

    private Double getRiskScoreFromFilter(String riskScoreFilter) {
        String[] parts = riskScoreFilter.split("=");
        return Double.valueOf(parts[1]);
    }

    private void configureSearchField() {
        this.dataView = (GridListDataView)this.grid.setItems((Collection)AppSecService.getInstance().getDependencies());
        this.searchField.setPlaceholder("Search");
        this.searchField.setPrefixComponent((Component)new Icon(VaadinIcon.SEARCH));
        this.searchField.setValueChangeMode(ValueChangeMode.EAGER);
        this.searchField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.dataView.refreshAll());
    }

    private void buildFilters() {
        this.searchField = new TextField("Dependency name");
        this.ecosystem = new ComboBox("Ecosystem");
        this.ecosystem.setItems((Object[])new Ecosystem[]{Ecosystem.MAVEN, Ecosystem.NPM});
        this.ecosystem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.group = new ComboBox("Dependency group");
        this.group.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.group.getStyle().set("--vaadin-combo-box-overlay-width", "350px");
        if (this.includeNpmDevDeps) {
            this.isDevelopment = new ComboBox("Is development?");
            this.isDevelopment.setItems((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
            this.isDevelopment.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        }
        this.severity = new ComboBox("Severity");
        this.severity.setItems((Object[])new SeverityLevel[]{SeverityLevel.NONE, SeverityLevel.LOW, SeverityLevel.MEDIUM, SeverityLevel.HIGH, SeverityLevel.CRITICAL});
        this.severity.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        this.riskScore = new ComboBox("CVSS score");
        this.riskScore.setItems((Object[])new String[]{">=0", ">=1", ">=2", ">=3", ">=4", ">=5", ">=6", ">=7", ">=8", ">=9", "=10"});
        this.riskScore.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.applyFilters());
        List components = Stream.of(this.searchField, this.ecosystem, this.group, this.severity, this.riskScore).collect(Collectors.toList());
        if (this.includeNpmDevDeps) {
            components.add(3, this.isDevelopment);
        }
        Component filterBar = this.buildFilterBar((Component[])components.toArray(Component[]::new));
        this.getMainContent().add(new Component[]{filterBar});
    }

    private void buildGrid() {
        this.grid = new Grid();
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.setMultiSort(true, Grid.MultiSortPriority.APPEND);
        this.grid.setSizeFull();
        ((Grid.Column)this.grid.addColumn(Dependency::getName).setHeader("Dependency").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Dependency::getEcosystem).setHeader("Ecosystem").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Dependency::getGroup).setHeader("Dependency group").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Dependency::getVersion).setHeader("Version").setResizable(true)).setSortable(true);
        if (this.includeNpmDevDeps) {
            ((Grid.Column)this.grid.addColumn(Dependency::isDevDependency).setHeader("Is development?").setResizable(true)).setSortable(true);
        }
        ((Grid.Column)this.grid.addColumn(Dependency::getNumOfVulnerabilities).setHeader("# of vulnerabilities").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Dependency::getSeverityLevel).setHeader("Highest severity").setResizable(true)).setSortable(true);
        ((Grid.Column)this.grid.addColumn(Dependency::getRiskScore).setHeader("Highest CVSS score").setResizable(true)).setSortable(true).setTooltipGenerator(Dependency::getCvssString);
        this.grid.addItemClickListener((ComponentEventListener & Serializable)e -> {
            if (e.getClickCount() == 2) {
                this.parent.showVulnerabilitiesViewFor((Dependency)e.getItem());
            }
        });
        this.getMainContent().addAndExpand(new Component[]{this.grid});
    }

    private void buildShowVulnerabilitiesButton() {
        Button showVulnerabilities = new Button("Show vulnerabilities");
        showVulnerabilities.setEnabled(false);
        showVulnerabilities.getElement().setAttribute("aria-label", "Show vulnerabilities");
        showVulnerabilities.addClickListener((ComponentEventListener & Serializable)e -> this.parent.showVulnerabilitiesViewFor((Dependency)this.grid.getSelectedItems().iterator().next()));
        this.grid.addSelectionListener((SelectionListener & Serializable)e -> showVulnerabilities.setEnabled(e.getFirstSelectedItem().isPresent()));
        this.getMainContent().add(new Component[]{showVulnerabilities});
        this.getMainContent().setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{showVulnerabilities});
    }

    private ListDataProvider<Dependency> getListDataProvider() {
        return (ListDataProvider)this.grid.getDataProvider();
    }
}

