/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.views;

import com.vaadin.appsec.backend.AppSecScanEvent;
import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.Registration;
import com.vaadin.appsec.backend.model.dto.Dependency;
import com.vaadin.appsec.views.AbstractAppSecView;
import com.vaadin.appsec.views.DependenciesView;
import com.vaadin.appsec.views.VulnerabilitiesView;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.tabs.TabSheet;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.text.DateFormat;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PageTitle(value="AppSec Kit")
@CssImport(value="./appsec-kit.css")
@AnonymousAllowed
public class AppSecView
extends AbstractAppSecView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSecView.class);
    private VulnerabilitiesView vulnerabilitiesView;
    private DependenciesView dependenciesView;
    private TabSheet tabSheet;
    private Span lastScannedLabel;
    private DateFormat formatter;
    private Registration scanListener;
    private Button scanNowButton;

    public AppSecView() {
        this.setSizeFull();
        this.addClassNames(new String[]{"appsec-kit-root-layout", "small-margin"});
        this.buildLayout();
        this.formatter = DateFormat.getDateTimeInstance(2, 2, UI.getCurrent().getLocale());
        this.refresh();
    }

    private void buildLayout() {
        HorizontalLayout headerBar = new HorizontalLayout();
        headerBar.setWidth(100.0f, Unit.PERCENTAGE);
        headerBar.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.BASELINE);
        headerBar.addAndExpand(new Component[]{this.buildAppTitle()});
        headerBar.add(new Component[]{this.buildLastScannedLabel()});
        headerBar.add(new Component[]{this.buildScanNowButton()});
        this.getMainContent().add(new Component[]{headerBar});
        this.getMainContent().addAndExpand(new Component[]{this.buildTabSheet()});
    }

    private Component buildAppTitle() {
        Span appTitle = new Span("AppSec Kit");
        appTitle.addClassName("appsec-kit-title");
        appTitle.setSizeFull();
        return appTitle;
    }

    private Component buildLastScannedLabel() {
        this.lastScannedLabel = new Span();
        this.lastScannedLabel.addClassName("last-scanned-label");
        this.lastScannedLabel.setWidth(380.0f, Unit.PIXELS);
        return this.lastScannedLabel;
    }

    private Component buildScanNowButton() {
        this.scanNowButton = new Button("Scan now");
        this.scanNowButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.scanNowButton.setDisableOnClick(true);
        this.scanNowButton.addClickListener((ComponentEventListener & Serializable)e -> {
            this.lastScannedLabel.setText("Scanning...");
            UI ui = UI.getCurrent();
            AppSecService.getInstance().scanForVulnerabilities().exceptionally(ex -> {
                LOGGER.error("Error scanning vulnerabilities.", ex);
                ui.access((Command & Serializable)() -> {
                    this.lastScannedLabel.setText("Error scanning vulnerabilities.");
                    this.scanNowButton.setEnabled(true);
                });
                return null;
            });
        });
        return this.scanNowButton;
    }

    private Component buildTabSheet() {
        this.tabSheet = new TabSheet();
        this.tabSheet.setSizeFull();
        this.tabSheet.addSelectedChangeListener((ComponentEventListener & Serializable)e -> {
            Component component = this.tabSheet.getComponent(this.tabSheet.getSelectedTab());
            if (component instanceof AbstractAppSecView) {
                AbstractAppSecView abstractAppSecView = (AbstractAppSecView)component;
                abstractAppSecView.refresh();
            }
        });
        this.vulnerabilitiesView = new VulnerabilitiesView(this);
        this.dependenciesView = new DependenciesView(this);
        this.tabSheet.add("Vulnerabilities", (Component)this.vulnerabilitiesView);
        this.tabSheet.add("Dependencies", (Component)this.dependenciesView);
        return this.tabSheet;
    }

    @Override
    public void refresh() {
        Instant lastScan;
        Component component = this.tabSheet.getComponent(this.tabSheet.getSelectedTab());
        if (component instanceof AbstractAppSecView) {
            AbstractAppSecView abstractAppSecView = (AbstractAppSecView)component;
            abstractAppSecView.refresh();
        }
        this.lastScannedLabel.setText("Last Scan: " + ((lastScan = AppSecService.getInstance().refresh().getLastScan()) == null ? "--" : this.formatter.format(Date.from(lastScan))));
    }

    void showVulnerabilitiesViewFor(Dependency item) {
        this.tabSheet.setSelectedTab(this.tabSheet.getTab((Component)this.vulnerabilitiesView));
        this.vulnerabilitiesView.filterOn(item);
    }

    public void onAttach(AttachEvent event) {
        super.onAttach(event);
        this.removeScanListener();
        this.scanListener = AppSecService.getInstance().addScanEventListener(this::handleScanEvent);
        LOGGER.debug("Scan event listener added");
    }

    public void onDetach(DetachEvent event) {
        super.onDetach(event);
        this.removeScanListener();
    }

    private void removeScanListener() {
        if (this.scanListener != null) {
            this.scanListener.remove();
            LOGGER.debug("Scan event listener removed");
            this.scanListener = null;
        }
    }

    private void handleScanEvent(AppSecScanEvent event) {
        this.getUI().ifPresent(this::handleScanNowButton);
    }

    private void handleScanNowButton(UI ui) {
        ui.access((Command & Serializable)() -> {
            this.scanNowButton.setEnabled(true);
            this.refresh();
            if (PushMode.MANUAL == ui.getPushConfiguration().getPushMode()) {
                ui.push();
            }
        });
    }
}

