/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.vaadin.appsec.backend.model.dto.Dependency;
import com.vaadin.appsec.backend.model.osv.response.Affected;
import com.vaadin.appsec.backend.model.osv.response.Ecosystem;
import org.cyclonedx.model.Component;

public class AppSecUtils {
    private AppSecUtils() {
    }

    public static Ecosystem getEcosystem(Component component) {
        String[] purlParts = component.getPurl().split("/");
        String[] pkgParts = purlParts[0].split(":");
        return Ecosystem.fromValue(pkgParts[1]);
    }

    public static String getDepGroupAndName(Dependency dependency) {
        if (dependency.getEcosystem() == Ecosystem.NPM) {
            if (dependency.getGroup() == null) {
                return dependency.getName();
            }
            return dependency.getGroup() + "/" + dependency.getName();
        }
        return dependency.getGroup() + ":" + dependency.getName();
    }

    public static String bomRefToMavenGroupAndName(String bomRef) {
        String[] bomRefParts = bomRef.split("/");
        String[] dependencyParts = bomRefParts[2].split("@");
        return bomRefParts[1] + ":" + dependencyParts[0];
    }

    public static String bomRefToNpmGroupAndName(String bomRef) {
        Object groupAndName;
        if (bomRef.contains("/")) {
            String[] bomRefParts = bomRef.split("/");
            String[] dependencyParts = bomRefParts[1].split("@");
            groupAndName = bomRefParts[1] + ":" + dependencyParts[0];
        } else {
            String[] bomRefParts = bomRef.split("@");
            groupAndName = bomRefParts[0];
        }
        return groupAndName;
    }

    public static String bomRefToVersion(String bomRef) {
        String[] bomRefParts = bomRef.split("/");
        String[] dependencyParts = bomRefParts[bomRefParts.length - 1].split("@");
        String[] versionAndType = dependencyParts[1].split("\\?");
        return versionAndType[0];
    }

    public static String getVulnDepGroup(Affected affected) {
        String depName = affected.getPackage().getName();
        String ecosystem = affected.getPackage().getEcosystem();
        if (ecosystem.equals(Ecosystem.NPM.toString())) {
            String[] nameParts = depName.split("/");
            if (nameParts.length == 2) {
                return nameParts[0];
            }
            return null;
        }
        return depName.split(":")[0];
    }

    public static String getVulnDepName(Affected affected) {
        String depName = affected.getPackage().getName();
        String ecosystem = affected.getPackage().getEcosystem();
        if (ecosystem.equals(Ecosystem.NPM.toString())) {
            String[] nameParts = depName.split("/");
            if (nameParts.length == 2) {
                return nameParts[1];
            }
            return depName;
        }
        return depName.split(":")[1];
    }
}

