/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend.model.analysis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.vaadin.appsec.backend.model.analysis.AffectedVersion;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Assessment
implements Serializable {
    @JsonIgnore
    private String name;
    @JsonDeserialize(contentUsing=MapDeserializer.class)
    private Map<String, AffectedVersion> affectedVersions = new HashMap<String, AffectedVersion>();

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public Map<String, AffectedVersion> getAffectedVersions() {
        return this.affectedVersions;
    }

    void setAffectedVersions(Map<String, AffectedVersion> affectedVersions) {
        this.affectedVersions = affectedVersions;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Assessment)) {
            return false;
        }
        Assessment other = (Assessment)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "Assessment{name='" + this.name + "', affectedVersions=" + String.valueOf(this.affectedVersions) + "}";
    }

    static class MapDeserializer
    extends JsonDeserializer<AffectedVersion> {
        MapDeserializer() {
        }

        public AffectedVersion deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String range = ctxt.getParser().getCurrentName();
            AffectedVersion version = (AffectedVersion)p.readValueAs(AffectedVersion.class);
            version.setVersionRange(range);
            return version;
        }
    }
}

