/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AppSecData
implements Serializable {
    private Instant lastScan;
    private Map<String, VulnerabilityAssessment> vulnerabilities = new HashMap<String, VulnerabilityAssessment>();

    public Instant getLastScan() {
        return this.lastScan;
    }

    public void setLastScan(Instant lastScan) {
        this.lastScan = lastScan;
    }

    public Map<String, VulnerabilityAssessment> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public void setVulnerabilities(Map<String, VulnerabilityAssessment> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    public static class VulnerabilityAssessment {
        private String id;
        private Instant updated;
        private String developerAnalysis;
        private VulnerabilityStatus status;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Instant getUpdated() {
            return this.updated;
        }

        public void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public String getDeveloperAnalysis() {
            return this.developerAnalysis;
        }

        public void setDeveloperAnalysis(String developerAnalysis) {
            this.developerAnalysis = developerAnalysis;
        }

        public VulnerabilityStatus getStatus() {
            return this.status;
        }

        public void setStatus(VulnerabilityStatus status) {
            this.status = status;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VulnerabilityAssessment)) {
                return false;
            }
            VulnerabilityAssessment other = (VulnerabilityAssessment)obj;
            return Objects.equals(this.id, other.id);
        }
    }

    public static enum VulnerabilityStatus {
        NOT_SET("Not set"),
        NOT_AFFECTED("Not affected"),
        FALSE_POSITIVE("False positive"),
        IN_TRIAGE("In triage"),
        EXPLOITABLE("Exploitable");

        private String caption;

        private VulnerabilityStatus(String caption) {
            this.caption = caption;
        }

        public String toString() {
            return this.caption;
        }
    }
}

