/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.vaadin.appsec.backend.OpenSourceVulnerabilityClient;
import com.vaadin.appsec.backend.model.osv.request.QueryBatchRequestPayload;
import com.vaadin.appsec.backend.model.osv.request.QueryRequestPayload;
import com.vaadin.appsec.backend.model.osv.response.OpenSourceVulnerability;
import com.vaadin.appsec.backend.model.osv.response.Package;
import com.vaadin.appsec.backend.model.osv.response.QueryBatchResponse;
import com.vaadin.appsec.backend.model.osv.response.VulnerabilityId;
import com.vaadin.appsec.backend.model.osv.response.VulnerabilityIdArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclonedx.model.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenSourceVulnerabilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSourceVulnerabilityService.class);
    private static final int COMPONENT_BATCH_SIZE = 1000;
    private final OpenSourceVulnerabilityClient osvClient;

    OpenSourceVulnerabilityService(int ratePerSecond) {
        this.osvClient = new OpenSourceVulnerabilityClient(ratePerSecond);
    }

    List<OpenSourceVulnerability> getVulnerabilities(List<Component> components) {
        return this.batchComponents(components).map(this::createQueryBatchRequestPayload).map(this.osvClient::queryBatch).map(QueryBatchResponse::getResults).flatMap(Arrays::stream).map(VulnerabilityIdArray::getVulnerabilityIds).filter(Objects::nonNull).peek(vuln -> LOGGER.debug("Collecting data for " + Arrays.toString(vuln))).flatMap(Arrays::stream).map(VulnerabilityId::getId).map(this.osvClient::queryVulnerability).collect(Collectors.toList());
    }

    private Stream<List<Component>> batchComponents(List<Component> components) {
        ArrayList<List<Component>> batches = new ArrayList<List<Component>>();
        for (int i = 0; i < components.size(); i += 1000) {
            batches.add(components.subList(i, Math.min(i + 1000, components.size())));
        }
        return batches.stream();
    }

    private QueryBatchRequestPayload createQueryBatchRequestPayload(List<Component> components) {
        return new QueryBatchRequestPayload((QueryRequestPayload[])components.stream().map(this::createQueryRequestPayload).toArray(QueryRequestPayload[]::new));
    }

    private QueryRequestPayload createQueryRequestPayload(Component component) {
        return new QueryRequestPayload(new Package(component.getPurl()));
    }
}

