/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RateLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateLimiter.class);
    private final Semaphore semaphore;
    private final int ratePerSecond;
    private long lastRequestTime;

    RateLimiter(int ratePerSecond) {
        this.semaphore = new Semaphore(ratePerSecond);
        this.ratePerSecond = ratePerSecond;
        this.lastRequestTime = System.currentTimeMillis();
    }

    void limit() throws InterruptedException {
        this.semaphore.acquire();
        long currentTime = System.currentTimeMillis();
        long timeElapsed = currentTime - this.lastRequestTime;
        long timeToWait = 1000L / (long)this.ratePerSecond - timeElapsed;
        if (timeToWait > 0L) {
            LOGGER.debug("Apply rate limit");
            Thread.sleep(timeToWait);
        }
        this.lastRequestTime = System.currentTimeMillis();
        this.semaphore.release();
    }
}

