/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.vaadin.appsec.backend.AppSecException;
import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.AppSecUtils;
import com.vaadin.appsec.backend.model.osv.response.Ecosystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Property;
import org.cyclonedx.parsers.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BillOfMaterialsStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BillOfMaterialsStore.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    static final String DEVELOPMENT_PROPERTY_NAME = "cdx:npm:package:development";
    private static final String NO_NAME_REF = "-/no-name@-";
    private static final String PLATFORM_COMBINED_BOM = "https://github.com/vaadin/platform/releases/download/%s/Software.Bill.Of.Materials.json";
    private Bom bomMaven;
    private Bom bomNpm;

    BillOfMaterialsStore() {
    }

    Bom getBom(Ecosystem ecosystem) {
        if (Objects.requireNonNull(ecosystem) == Ecosystem.MAVEN) {
            return this.bomMaven;
        }
        return this.bomNpm;
    }

    void readBomFile(Path bomFilePath, Ecosystem ecosystem) throws ParseException {
        if (Objects.requireNonNull(ecosystem) == Ecosystem.MAVEN) {
            this.bomMaven = this.readBomFile(bomFilePath);
        } else {
            boolean includeNpmDevDeps = AppSecService.getInstance().getConfiguration().isIncludeNpmDevDependencies();
            this.bomNpm = includeNpmDevDeps ? this.readBomFile(bomFilePath) : this.filterOutNpmDevLibraries(this.readBomFile(bomFilePath));
        }
        LOGGER.debug("Reading SBOM from file " + bomFilePath.toAbsolutePath());
    }

    void readPlatformCombinedBomFile() {
        ObjectReader jsonReader = MAPPER.readerFor(Bom.class);
        try {
            URL platformCombinedBomUrl = this.getPlatformCombinedBomUrl();
            Bom platformCombinedBom = (Bom)jsonReader.readValue(platformCombinedBomUrl);
            boolean includeNpmDevDeps = AppSecService.getInstance().getConfiguration().isIncludeNpmDevDependencies();
            this.bomNpm = includeNpmDevDeps ? this.filterOutMavenLibraries(platformCombinedBom) : this.filterOutNpmDevLibraries(this.filterOutMavenLibraries(platformCombinedBom));
            LOGGER.debug("Reading SBOM from Vaadin platform");
        }
        catch (IOException e) {
            throw new AppSecException("Cannot get Vaadin platform SBOM", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bom readBomFile(Path bomFilePath) throws ParseException {
        JsonParser parser = new JsonParser();
        File bomFile = bomFilePath.toFile();
        try {
            return parser.parse(bomFile);
        }
        catch (ParseException e) {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            try (InputStream is = ccl.getResourceAsStream(bomFilePath.toString());){
                if (is == null) throw e;
                Bom bom = parser.parse(is);
                return bom;
            }
            catch (IOException ex) {
                throw new AppSecException("SBOM file not found on path " + bomFilePath, ex);
            }
        }
    }

    private Bom filterOutNpmDevLibraries(Bom bom) {
        ArrayList<String> npmDevDepBomRefs = new ArrayList<String>();
        this.filterOutNpmDevComponents(bom, npmDevDepBomRefs);
        this.filterOutNpmDevDependencies(bom, npmDevDepBomRefs);
        return bom;
    }

    private void filterOutNpmDevComponents(Bom bom, List<String> npmDevDepBomRefs) {
        ArrayList<Component> componentsToInclude = new ArrayList<Component>();
        for (Component component : bom.getComponents()) {
            boolean isDevDep = false;
            for (Property property : component.getProperties()) {
                if (!property.getName().equals(DEVELOPMENT_PROPERTY_NAME) || !property.getValue().equals("true")) continue;
                isDevDep = true;
                npmDevDepBomRefs.add(component.getBomRef());
            }
            if (isDevDep) continue;
            componentsToInclude.add(component);
        }
        bom.setComponents(componentsToInclude);
    }

    private void filterOutNpmDevDependencies(Bom bom, List<String> npmDevDepBomRefs) {
        ArrayList<Dependency> dependenciesToInclude = new ArrayList<Dependency>();
        for (Dependency dependency : bom.getDependencies()) {
            if (dependency.getRef().equals(NO_NAME_REF)) {
                ArrayList<Dependency> dependsOnDepsToInclude = new ArrayList<Dependency>();
                List dependsOnDeps = dependency.getDependencies();
                for (Dependency dependsOnDep : dependsOnDeps) {
                    if (npmDevDepBomRefs.contains(dependsOnDep.getRef())) continue;
                    dependsOnDepsToInclude.add(dependsOnDep);
                }
                dependency.setDependencies(dependsOnDepsToInclude);
                dependenciesToInclude.add(dependency);
                continue;
            }
            if (npmDevDepBomRefs.contains(dependency.getRef())) continue;
            dependenciesToInclude.add(dependency);
        }
        bom.setDependencies(dependenciesToInclude);
    }

    private Bom filterOutMavenLibraries(Bom bom) {
        ArrayList<String> mavenPurls = new ArrayList<String>();
        this.filterOutMavenComponents(bom, mavenPurls);
        this.filterOutMavenDependencies(bom, mavenPurls);
        return bom;
    }

    private void filterOutMavenComponents(Bom bom, List<String> mavenPurls) {
        ArrayList<Component> componentsToInclude = new ArrayList<Component>();
        for (Component component : bom.getComponents()) {
            boolean isMavenComp = false;
            Ecosystem ecosystem = AppSecUtils.getEcosystem(component);
            if (ecosystem == Ecosystem.MAVEN) {
                isMavenComp = true;
                mavenPurls.add(component.getPurl());
            }
            if (isMavenComp) continue;
            componentsToInclude.add(component);
        }
        bom.setComponents(componentsToInclude);
    }

    private void filterOutMavenDependencies(Bom bom, List<String> mavenPurls) {
        ArrayList<Dependency> dependenciesToInclude = new ArrayList<Dependency>();
        for (Dependency dependency : bom.getDependencies()) {
            if (mavenPurls.contains(dependency.getRef())) continue;
            dependenciesToInclude.add(dependency);
        }
        bom.setDependencies(dependenciesToInclude);
    }

    private URL getPlatformCombinedBomUrl() {
        Optional<Component> flowServerComponent = AppSecService.getInstance().getFlowServerComponent();
        if (!flowServerComponent.isPresent()) {
            throw new AppSecException("Cannot get Vaadin platform version.");
        }
        String version = flowServerComponent.get().getVersion();
        try {
            return new URL(String.format(PLATFORM_COMBINED_BOM, version));
        }
        catch (MalformedURLException e) {
            throw new AppSecException("Invalid Vaadin platform SBOM URL", e);
        }
    }
}

