/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.vaadin.appsec.backend.AppSecException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSecConfiguration
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSecConfiguration.class);
    static final String DEFAULT_APPSEC_ROUTE = "vaadin-appsec-kit";
    static final String DATA_PATH_PROPERTY = "vaadin.appsec.data";
    static final String DEFAULT_DATA_FILE_PATH = "";
    static final String DEFAULT_DATA_FILE_NAME = "appsec-data.json";
    static final String DEFAULT_BOM_FILE_PATH = "/resources";
    static final String BOM_MAVEN_PATH_PROPERTY = "vaadin.appsec.bom";
    static final String DEFAULT_BOM_MAVEN_FILE_NAME = "bom.json";
    static final String BOM_NPM_PATH_PROPERTY = "vaadin.appsec.bom-npm";
    static final String DEFAULT_BOM_NPM_FILE_NAME = "bom-npm.json";
    static final boolean DEFAULT_AUTOMATICALLY_ACTIVATE_PUSH = true;
    private String appSecRoute = "vaadin-appsec-kit";
    private Path dataFilePath;
    private Path bomMavenFilePath;
    private Path bomNpmFilePath;
    private ScheduledExecutorService taskExecutor = Executors.newSingleThreadScheduledExecutor();
    private Duration autoScanInterval = Duration.ofDays(1L);
    private int osvApiRatePerSecond = 25;
    private boolean includeNpmDevDependencies = true;
    private boolean automaticallyActivatePush = true;

    public String getAppSecRoute() {
        return this.appSecRoute;
    }

    public void setAppSecRoute(String appSecRoute) {
        if (appSecRoute == null) {
            throw new IllegalArgumentException("The AppSec route cannot be null");
        }
        this.appSecRoute = appSecRoute;
    }

    public Path getDataFilePath() {
        if (this.dataFilePath == null) {
            String propertyPath = System.getProperty(DATA_PATH_PROPERTY, DEFAULT_DATA_FILE_PATH);
            try {
                this.dataFilePath = Paths.get(propertyPath, DEFAULT_DATA_FILE_NAME);
            }
            catch (InvalidPathException e) {
                throw new AppSecException("Invalid data file path " + propertyPath, e);
            }
        }
        return this.dataFilePath;
    }

    public void setDataFilePath(Path dataFilePath) {
        if (dataFilePath == null) {
            throw new IllegalArgumentException("The data-file path cannot be null");
        }
        this.dataFilePath = dataFilePath;
    }

    public Path getBomFilePath() {
        if (this.bomMavenFilePath == null) {
            String propertyPath = System.getProperty(BOM_MAVEN_PATH_PROPERTY, DEFAULT_BOM_FILE_PATH);
            String bomFile = propertyPath + "/bom.json";
            URL bomFileUrl = AppSecConfiguration.class.getResource(bomFile);
            if (bomFileUrl != null) {
                try {
                    this.bomMavenFilePath = Paths.get(bomFileUrl.toURI());
                }
                catch (URISyntaxException e) {
                    throw new AppSecException("URI syntax error for Maven SBOM file path: " + bomFile, e);
                }
                catch (InvalidPathException e) {
                    throw new AppSecException("Invalid Maven SBOM file path " + bomFile, e);
                }
                catch (FileSystemNotFoundException e) {
                    return Paths.get(bomFile, new String[0]);
                }
                catch (RuntimeException e) {
                    throw new AppSecException("Error occurred when getting the Maven SBOM file path", e);
                }
            } else {
                throw new AppSecException("Maven SBOM file not found on path " + bomFile);
            }
        }
        return this.bomMavenFilePath;
    }

    public void setBomFilePath(Path bomFilePath) {
        if (bomFilePath == null) {
            throw new IllegalArgumentException("The Maven BOM-file path cannot be null");
        }
        this.bomMavenFilePath = bomFilePath;
    }

    public Path getBomNpmFilePath() {
        if (this.bomNpmFilePath == null) {
            String propertyPath = System.getProperty(BOM_NPM_PATH_PROPERTY, DEFAULT_BOM_FILE_PATH);
            String bomNpmFile = propertyPath + "/bom-npm.json";
            URL bomNpmFileUrl = AppSecConfiguration.class.getResource(bomNpmFile);
            if (bomNpmFileUrl != null) {
                try {
                    this.bomNpmFilePath = Paths.get(bomNpmFileUrl.toURI());
                }
                catch (URISyntaxException e) {
                    throw new AppSecException("URI syntax error for npm SBOM file path: " + bomNpmFile, e);
                }
                catch (InvalidPathException e) {
                    throw new AppSecException("Invalid npm SBOM file path " + bomNpmFile, e);
                }
                catch (FileSystemNotFoundException e) {
                    return Paths.get(bomNpmFile, new String[0]);
                }
                catch (RuntimeException e) {
                    throw new AppSecException("Error occurred when getting the npm SBOM file path", e);
                }
            } else {
                LOGGER.warn("npm SBOM file not found on path " + bomNpmFile);
            }
        }
        return this.bomNpmFilePath;
    }

    public void setBomNpmFilePath(Path bomNpmFilePath) {
        if (bomNpmFilePath == null) {
            throw new IllegalArgumentException("The npm BOM-file path cannot be null");
        }
        this.bomNpmFilePath = bomNpmFilePath;
    }

    public ScheduledExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(ScheduledExecutorService taskExecutor) {
        if (taskExecutor == null) {
            throw new IllegalArgumentException("The executor cannot be null");
        }
        this.taskExecutor = taskExecutor;
    }

    public Duration getAutoScanInterval() {
        return this.autoScanInterval;
    }

    public void setAutoScanInterval(Duration autoScanInterval) {
        if (autoScanInterval == null) {
            throw new IllegalArgumentException("The auto-scan period cannot be null");
        }
        this.autoScanInterval = autoScanInterval;
    }

    public int getOsvApiRatePerSecond() {
        return this.osvApiRatePerSecond;
    }

    public void setOsvApiRatePerSecond(int osvApiRatePerSecond) {
        this.osvApiRatePerSecond = osvApiRatePerSecond;
    }

    public boolean isIncludeNpmDevDependencies() {
        return this.includeNpmDevDependencies;
    }

    public void setIncludeNpmDevDependencies(boolean includeNpmDevDependencies) {
        this.includeNpmDevDependencies = includeNpmDevDependencies;
    }

    public void setAutomaticallyActivatePush(boolean automaticallyActivatePush) {
        this.automaticallyActivatePush = automaticallyActivatePush;
    }

    public boolean isAutomaticallyActivatePush() {
        return this.automaticallyActivatePush;
    }

    public String toString() {
        return "AppSecConfiguration{appSecRoute=" + this.appSecRoute + ", dataFilePath=" + this.dataFilePath + ", bomFilePath=" + this.bomMavenFilePath + (String)(this.bomNpmFilePath != null ? ", bomNpmFilePath=" + this.bomNpmFilePath : DEFAULT_DATA_FILE_PATH) + ", taskExecutor=" + this.taskExecutor + ", autoScanInterval=" + this.autoScanInterval + ", osvApiRatePerSecond=" + this.osvApiRatePerSecond + ", includeNpmDevDependencies=" + this.includeNpmDevDependencies + ", automaticallyActivatePush=" + this.automaticallyActivatePush + "}";
    }
}

