/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend.model.dto;

import com.vaadin.appsec.backend.model.AppSecData;
import com.vaadin.appsec.backend.model.analysis.AffectedVersion;
import com.vaadin.appsec.backend.model.analysis.AssessmentStatus;
import com.vaadin.appsec.backend.model.dto.Dependency;
import com.vaadin.appsec.backend.model.dto.SeverityLevel;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class Vulnerability
implements Serializable {
    private final String identifier;
    private Dependency dependency;
    private String patchedVersion;
    private AffectedVersion affectedVersion;
    private AssessmentStatus vaadinAnalysis;
    private AppSecData.VulnerabilityStatus developerStatus;
    private String developerAnalysis;
    private Instant developerUpdated;
    private Date datePublished;
    private String details;
    private Set<String> referenceUrls;

    public Vulnerability(@NotNull String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public String getPatchedVersion() {
        return this.patchedVersion;
    }

    public void setPatchedVersion(String patchedVersion) {
        this.patchedVersion = patchedVersion;
    }

    public SeverityLevel getSeverityLevel() {
        return this.dependency.getSeverityLevel();
    }

    public String getCvssString() {
        return this.dependency.getCvssString();
    }

    public Double getRiskScore() {
        return this.dependency.getRiskScore();
    }

    public AffectedVersion getAffectedVersion() {
        return this.affectedVersion;
    }

    public void setAffectedVersion(AffectedVersion affectedVersion) {
        this.affectedVersion = affectedVersion;
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public AssessmentStatus getVaadinAnalysis() {
        return this.vaadinAnalysis;
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public void setVaadinAnalysis(AssessmentStatus vaadinAnalysis) {
        this.vaadinAnalysis = vaadinAnalysis;
    }

    public String getDeveloperAnalysis() {
        return this.developerAnalysis;
    }

    public void setDeveloperAnalysis(String developerAnalysis) {
        this.developerAnalysis = developerAnalysis;
    }

    public Date getDatePublished() {
        return this.datePublished;
    }

    public void setDatePublished(Date datePublished) {
        this.datePublished = datePublished;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Set<String> getReferenceUrls() {
        return this.referenceUrls;
    }

    public void setReferenceUrls(Set<String> referenceUrls) {
        this.referenceUrls = referenceUrls;
    }

    public AppSecData.VulnerabilityStatus getDeveloperStatus() {
        return this.developerStatus;
    }

    public void setDeveloperStatus(AppSecData.VulnerabilityStatus developerStatus) {
        this.developerStatus = developerStatus;
    }

    public Instant getDeveloperUpdated() {
        return this.developerUpdated;
    }

    public void setDeveloperUpdated(Instant developerUpdated) {
        this.developerUpdated = developerUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vulnerability that = (Vulnerability)o;
        return this.identifier.equals(that.identifier) && Objects.equals(this.dependency, that.dependency);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.dependency);
    }

    public String toString() {
        return "VulnerabilityDTO{identifier='" + this.identifier + "', dependency=" + this.dependency + ", datePublished=" + this.datePublished + "}";
    }
}

