/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.vaadin.appsec.backend.AppSecException;
import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.model.analysis.VulnerabilityAnalysis;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitHubService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubService.class);
    static final ObjectMapper MAPPER = new ObjectMapper();
    static final String VAADIN_ANALYSIS_URI = "https://raw.githubusercontent.com/vaadin/vulnerability-analysis/main/analysis.json";
    static final String FRAMEWORK_RELEASES_URI = "https://api.github.com/repos/vaadin/framework/releases";
    static final String FLOW_RELEASES_URI = "https://api.github.com/repos/vaadin/flow/releases";
    static final Pattern FRAMEWORK_7_PATTERN = Pattern.compile("^7\\.\\d+.\\d+$");
    static final Pattern FRAMEWORK_8_PATTERN = Pattern.compile("^8\\.\\d+.\\d+$");
    static final Pattern FLOW_24_PATTERN = Pattern.compile("^24\\.\\d+.\\d+$");
    static final long NUMBER_OF_LATEST_MAINTAINED_VERSIONS = 4L;
    static final String ANALYSIS_PATH_AND_NAME_PROPERTY = "vaadin.appsec.analysis";
    private List<GitHubRelease> releasesCache;
    private VulnerabilityAnalysis analysisCache;

    GitHubService() {
    }

    List<String> getFramework7Versions() {
        return this.getVersions(FRAMEWORK_7_PATTERN);
    }

    List<String> getFramework8Versions() {
        return this.getVersions(FRAMEWORK_8_PATTERN);
    }

    List<String> getFlow24Versions() {
        return this.getVersions(FLOW_24_PATTERN);
    }

    private List<String> getVersions(Pattern flowVersionPattern) {
        return this.getReleasesFromGitHub().stream().map(GitHubRelease::getTagName).filter(flowVersionPattern.asPredicate()).limit(4L).toList();
    }

    private List<GitHubRelease> getReleasesFromGitHub() {
        if (this.releasesCache == null) {
            this.updateReleasesCache();
        }
        return this.releasesCache;
    }

    void updateReleasesCache() {
        boolean isFlow = AppSecService.getInstance().isFlow();
        ObjectReader listReader = MAPPER.readerForListOf(GitHubRelease.class);
        try {
            URL releasesUrl = isFlow ? this.getFlowReleasesUrl() : this.getFrameworkReleasesUrl();
            this.releasesCache = (List)listReader.readValue(releasesUrl);
            LOGGER.debug("Vaadin releases cache updated from GitHub " + this.releasesCache);
        }
        catch (IOException e) {
            throw new AppSecException("Cannot get Vaadin releases from GitHub", e);
        }
    }

    VulnerabilityAnalysis getVulnerabilityAnalysis() {
        if (this.analysisCache == null) {
            this.updateAnalysisCache();
        }
        return this.analysisCache;
    }

    void updateAnalysisCache() {
        ObjectReader jsonReader = MAPPER.readerFor(VulnerabilityAnalysis.class);
        try {
            URL analysisUrl = this.getVaadinAnalysisUrl();
            this.analysisCache = (VulnerabilityAnalysis)jsonReader.readValue(analysisUrl);
            LOGGER.debug("Vaadin analysis cache updated from GitHub " + this.analysisCache);
        }
        catch (IOException e) {
            throw new AppSecException("Cannot get Vaadin analysis from GitHub", e);
        }
    }

    protected URL getFrameworkReleasesUrl() {
        try {
            return new URL(FRAMEWORK_RELEASES_URI);
        }
        catch (MalformedURLException e) {
            throw new AppSecException("Invalid Vaadin framework releases URL", e);
        }
    }

    protected URL getFlowReleasesUrl() {
        try {
            return new URL(FLOW_RELEASES_URI);
        }
        catch (MalformedURLException e) {
            throw new AppSecException("Invalid Vaadin Flow releases URL", e);
        }
    }

    protected URL getVaadinAnalysisUrl() {
        String analysisPathAndName = System.getProperty(ANALYSIS_PATH_AND_NAME_PROPERTY);
        if (analysisPathAndName != null && !analysisPathAndName.isEmpty()) {
            Path analysis = null;
            try {
                analysis = Paths.get(analysisPathAndName, new String[0]);
                return analysis.toUri().toURL();
            }
            catch (InvalidPathException e) {
                throw new AppSecException("Invalid Vaadin analysis file path and name " + analysis, e);
            }
            catch (MalformedURLException e) {
                throw new AppSecException("Invalid Vaadin analysis file path and name URL", e);
            }
        }
        try {
            return new URL(VAADIN_ANALYSIS_URI);
        }
        catch (MalformedURLException e) {
            throw new AppSecException("Invalid Vaadin analysis URL", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class GitHubRelease
    implements Comparable<GitHubRelease> {
        @JsonProperty(value="tag_name")
        private String tagName;

        GitHubRelease() {
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String name) {
            this.tagName = name;
        }

        public int hashCode() {
            return Objects.hash(this.tagName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GitHubRelease)) {
                return false;
            }
            GitHubRelease other = (GitHubRelease)obj;
            return Objects.equals(this.tagName, other.tagName);
        }

        @Override
        public int compareTo(GitHubRelease o) {
            return Collator.getInstance().compare(this.tagName, o.tagName);
        }

        public String toString() {
            return "GitHubRelease{tagName='" + this.tagName + "'}";
        }
    }
}

