/*-
 * Copyright (C) 2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */

package com.vaadin.appsec.backend.model.osv.response;

import java.util.Arrays;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * DTO for the OSV API vulnerability array property.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class VulnerabilityIdArray {

    @JsonProperty("vulns")
    private VulnerabilityId[] vulnerabilityIds;

    /**
     * No args constructor for use in serialization.
     */
    public VulnerabilityIdArray() {
    }

    /**
     * Instantiates a new vulnerability id array.
     *
     * @param vulnerabilityIds
     *            the vulnerability ids
     */
    public VulnerabilityIdArray(VulnerabilityId[] vulnerabilityIds) {
        this.vulnerabilityIds = vulnerabilityIds;
    }

    /**
     * Gets the vulnerability ids.
     *
     * @return the vulnerability ids
     */
    public VulnerabilityId[] getVulnerabilityIds() {
        return vulnerabilityIds;
    }

    /**
     * Sets the vulnerability ids.
     *
     * @param vulnerabilityIds
     *            the new vulnerability ids
     */
    public void setVulnerabilityIds(VulnerabilityId[] vulnerabilityIds) {
        this.vulnerabilityIds = vulnerabilityIds;
    }

    @Override
    public String toString() {
        return "VulnerabilityIdArray{" + "vulnerabilityIds="
                + Arrays.toString(vulnerabilityIds) + '}';
    }
}
