/*-
 * Copyright (C) 2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */

package com.vaadin.appsec.backend.model.osv.response;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * The Class VulnerabilityId.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({ "id", "modified" })
public class VulnerabilityId {

    @JsonProperty("id")
    private String id;
    @JsonProperty("modified")
    private Date modified;

    /**
     * No args constructor for use in serialization.
     */
    public VulnerabilityId() {
    }

    /**
     * Instantiates a new vulnerability id.
     *
     * @param id
     *            the id
     * @param modified
     *            the modified
     */
    public VulnerabilityId(String id, Date modified) {
        this.id = id;
        this.modified = modified;
    }

    /**
     * Gets the id.
     *
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id
     *            the new id
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Gets the modified.
     *
     * @return the modified
     */
    public Date getModified() {
        return modified;
    }

    /**
     * Sets the modified.
     *
     * @param modified
     *            the new modified
     */
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public String toString() {
        return "VulnerabilityId{" + "id='" + id + '\'' + '}';
    }
}
