/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend.model.dto;

import java.io.Serializable;

public enum SeverityLevel implements Serializable
{
    CRITICAL("Critical", 9.0, 10.0),
    HIGH("High", 7.0, 8.9),
    MEDIUM("Medium", 4.0, 6.9),
    LOW("Low", 0.1, 3.9),
    NONE("None", 0.0, 0.0);

    private final String caption;
    private final Double minScore;
    private final Double maxScore;

    private SeverityLevel(String caption, Double min, Double maxScore) {
        this.caption = caption;
        this.minScore = min;
        this.maxScore = maxScore;
    }

    public Double getMinScore() {
        return this.minScore;
    }

    public Double getMaxScore() {
        return this.maxScore;
    }

    public String getCaption() {
        return this.caption;
    }

    public String toString() {
        return this.caption;
    }

    public static SeverityLevel getSeverityLevelForCvssScore(Double cvssScore) {
        for (SeverityLevel severityLevel : SeverityLevel.values()) {
            if (!(cvssScore >= severityLevel.getMinScore()) || !(cvssScore <= severityLevel.getMaxScore())) continue;
            return severityLevel;
        }
        throw new IllegalArgumentException("The score is out of the allowed range");
    }
}

