/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend.model.analysis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.appsec.backend.model.analysis.AssessmentStatus;
import java.io.Serializable;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class AffectedVersion
implements Serializable {
    @JsonIgnore
    private String versionRange;
    private AssessmentStatus status;
    private String comment;
    private String fixedIn;

    public String getVersionRange() {
        return this.versionRange;
    }

    public boolean isInRange(String version) {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)this.versionRange);
            return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(version));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Not parsable version", e);
        }
    }

    void setVersionRange(String versionRange) {
        this.versionRange = versionRange;
    }

    public AssessmentStatus getStatus() {
        return this.status;
    }

    void setStatus(AssessmentStatus status) {
        this.status = status;
    }

    public String getComment() {
        return this.comment;
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    public String getFixedIn() {
        return this.fixedIn;
    }

    void setFixedIn(String fixedIn) {
        this.fixedIn = fixedIn;
    }

    public int hashCode() {
        return Objects.hash(this.versionRange);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffectedVersion)) {
            return false;
        }
        AffectedVersion other = (AffectedVersion)obj;
        return Objects.equals(this.versionRange, other.versionRange);
    }

    public String toString() {
        return "AffectedVersion{versionRange='" + this.versionRange + "', status=" + this.status + ", comment='" + this.comment + "', fixedIn='" + this.fixedIn + "'}";
    }
}

