/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.vaadin.appsec.backend.AppSecException;
import com.vaadin.appsec.backend.BillOfMaterialsStore;
import com.vaadin.appsec.backend.OpenSourceVulnerabilityService;
import com.vaadin.appsec.backend.model.osv.response.Ecosystem;
import com.vaadin.appsec.backend.model.osv.response.OpenSourceVulnerability;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.cyclonedx.model.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VulnerabilityStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(VulnerabilityStore.class);
    private final List<OpenSourceVulnerability> vulnerabilities = new ArrayList<OpenSourceVulnerability>();
    private final OpenSourceVulnerabilityService osvService;
    private final BillOfMaterialsStore bomStore;

    VulnerabilityStore(OpenSourceVulnerabilityService osvService, BillOfMaterialsStore bomStore) {
        this.osvService = osvService;
        this.bomStore = bomStore;
    }

    void init(List<OpenSourceVulnerability> vulnerabilities) {
        this.vulnerabilities.clear();
        this.vulnerabilities.addAll(new HashSet<OpenSourceVulnerability>(vulnerabilities));
    }

    List<OpenSourceVulnerability> getVulnerabilities() {
        return Collections.unmodifiableList(this.vulnerabilities);
    }

    List<OpenSourceVulnerability> refresh() throws AppSecException {
        ArrayList<Component> components = new ArrayList<Component>(this.bomStore.getBom(Ecosystem.MAVEN).getComponents());
        if (this.bomStore.getBom(Ecosystem.NPM) != null) {
            components.addAll(this.bomStore.getBom(Ecosystem.NPM).getComponents());
        }
        LOGGER.debug("Scan for vulnerabilities started...");
        List<OpenSourceVulnerability> vulnerabilities = this.osvService.getVulnerabilities(components);
        LOGGER.debug("Scan for vulnerabilities finished");
        this.init(vulnerabilities);
        LOGGER.debug("Vulnerability store refreshed with " + vulnerabilities);
        return this.getVulnerabilities();
    }
}

