/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.appsec.backend.AppSecException;
import com.vaadin.appsec.backend.RateLimiter;
import com.vaadin.appsec.backend.model.osv.request.QueryBatchRequestPayload;
import com.vaadin.appsec.backend.model.osv.response.OpenSourceVulnerability;
import com.vaadin.appsec.backend.model.osv.response.QueryBatchResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenSourceVulnerabilityClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSourceVulnerabilityClient.class);
    private static final String QUERY_BATCH_URL = "https://api.osv.dev/v1/querybatch";
    private static final String VULNERABILITY_URL = "https://api.osv.dev/v1/vulns/";
    private final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final RateLimiter rateLimiter;

    OpenSourceVulnerabilityClient(int ratePerSecond) {
        this.rateLimiter = new RateLimiter(ratePerSecond);
    }

    QueryBatchResponse queryBatch(QueryBatchRequestPayload payload) throws AppSecException {
        QueryBatchResponse queryBatchResponse;
        block17: {
            LOGGER.debug("Performing a batch query to the OSV API...");
            HttpURLConnection conn = this.createHttpURLConnection(this.getQueryBatchUrl(), "POST");
            this.rateLimit();
            try (OutputStream outputStream = conn.getOutputStream();){
                this.mapper.writeValue(outputStream, (Object)payload);
            }
            catch (IOException e) {
                throw new AppSecException("Failed to write OSV API query batch request payload", e);
            }
            InputStream inputStream = conn.getInputStream();
            try {
                queryBatchResponse = (QueryBatchResponse)this.mapper.readValue(inputStream, QueryBatchResponse.class);
                if (inputStream == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AppSecException("Failed to read OSV API query batch response", e);
                }
            }
            inputStream.close();
        }
        return queryBatchResponse;
    }

    OpenSourceVulnerability queryVulnerability(String vulnerabilityId) throws AppSecException {
        OpenSourceVulnerability openSourceVulnerability;
        block8: {
            LOGGER.debug("Performing a vulnerability query to the OSV API...");
            String urlWithId = this.getVulnerabilityUrl().concat(vulnerabilityId);
            HttpURLConnection conn = this.createHttpURLConnection(urlWithId, "GET");
            this.rateLimit();
            InputStream inputStream = conn.getInputStream();
            try {
                openSourceVulnerability = (OpenSourceVulnerability)this.mapper.readValue(inputStream, OpenSourceVulnerability.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AppSecException("Failed to read OSV API query response", e);
                }
            }
            inputStream.close();
        }
        return openSourceVulnerability;
    }

    private HttpURLConnection createHttpURLConnection(String urlStr, String requestMethod) {
        HttpURLConnection connection;
        try {
            URL url = URI.create(urlStr).toURL();
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(requestMethod);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setConnectTimeout(5000);
        }
        catch (SocketTimeoutException e) {
            throw new AppSecException("Connection to OSV API server has timed out", e);
        }
        catch (IOException e) {
            throw new AppSecException("Failed to create connection to OSV API with URL: " + urlStr, e);
        }
        return connection;
    }

    String getQueryBatchUrl() {
        return QUERY_BATCH_URL;
    }

    String getVulnerabilityUrl() {
        return VULNERABILITY_URL;
    }

    private void rateLimit() {
        try {
            this.rateLimiter.limit();
        }
        catch (InterruptedException e) {
            throw new AppSecException("OpenSourceVulnerabilityClient rate limit exceeded", e);
        }
    }
}

