/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vaadin.appsec.backend.AppSecConfiguration;
import com.vaadin.appsec.backend.AppSecDTOProvider;
import com.vaadin.appsec.backend.AppSecException;
import com.vaadin.appsec.backend.AppSecScanEvent;
import com.vaadin.appsec.backend.AppSecScanEventListener;
import com.vaadin.appsec.backend.BillOfMaterialsStore;
import com.vaadin.appsec.backend.GitHubService;
import com.vaadin.appsec.backend.OpenSourceVulnerabilityService;
import com.vaadin.appsec.backend.Registration;
import com.vaadin.appsec.backend.VulnerabilityStore;
import com.vaadin.appsec.backend.model.AppSecData;
import com.vaadin.appsec.backend.model.analysis.VulnerabilityAnalysis;
import com.vaadin.appsec.backend.model.dto.Dependency;
import com.vaadin.appsec.backend.model.dto.Vulnerability;
import com.vaadin.appsec.backend.model.osv.response.Ecosystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSecService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSecService.class);
    private static final String FLOW_SERVER = "flow-server";
    static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<AppSecScanEventListener> scanEventListeners = new ArrayList<AppSecScanEventListener>();
    private final VulnerabilityStore vulnerabilityStore;
    private final BillOfMaterialsStore bomStore;
    private final AppSecDTOProvider dtoProvider;
    private final GitHubService githubService;
    private AppSecConfiguration configuration;
    private AppSecData data;
    private Clock clock = Clock.systemUTC();
    private ScheduledFuture<?> scheduledScan;

    public static AppSecService getInstance() {
        return InstanceHolder.instance;
    }

    private AppSecService(AppSecConfiguration configuration) {
        this.bomStore = new BillOfMaterialsStore();
        int osvApiRatePerSecond = configuration.getOsvApiRatePerSecond();
        OpenSourceVulnerabilityService osvService = new OpenSourceVulnerabilityService(osvApiRatePerSecond);
        this.vulnerabilityStore = new VulnerabilityStore(osvService, this.bomStore);
        this.dtoProvider = new AppSecDTOProvider(this.vulnerabilityStore, this.bomStore);
        this.githubService = new GitHubService();
        this.configuration = configuration;
    }

    public void init() {
        this.cancelScheduledScan();
        Path bomMavenFilePath = this.configuration.getBomFilePath();
        try {
            this.bomStore.readBomFile(bomMavenFilePath, Ecosystem.MAVEN);
        }
        catch (ParseException e) {
            throw new AppSecException("Cannot parse the Maven SBOM file: " + bomMavenFilePath.toAbsolutePath(), e);
        }
        if (this.bomNpmFileExists()) {
            Path bomNpmFilePath = this.configuration.getBomNpmFilePath();
            try {
                this.bomStore.readBomFile(bomNpmFilePath, Ecosystem.NPM);
            }
            catch (ParseException e) {
                throw new AppSecException("Cannot parse the npm SBOM file: " + bomNpmFilePath.toAbsolutePath(), e);
            }
        } else {
            this.bomStore.readPlatformCombinedBomFile();
        }
        this.readOrCreateDataFile();
    }

    boolean isFlow() {
        return this.getFlowServerComponent().isPresent();
    }

    boolean bomNpmFileExists() {
        Path bomNpmFilePath = this.configuration.getBomNpmFilePath();
        if (bomNpmFilePath != null) {
            return Files.exists(bomNpmFilePath, new LinkOption[0]);
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public List<String> getSupportedFramework7Versions() {
        return this.githubService.getFramework7Versions();
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public List<String> getSupportedFramework8Versions() {
        return this.githubService.getFramework8Versions();
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public List<String> getSupportedFlow24Versions() {
        return this.getSupportedFlowVersions();
    }

    public List<String> getSupportedFlowVersions() {
        Optional<Component> flowServerComponent = this.getFlowServerComponent();
        if (flowServerComponent.isPresent()) {
            String flowServerVersion = flowServerComponent.get().getVersion();
            if (flowServerVersion.startsWith("24.")) {
                return this.githubService.getFlow24Versions();
            }
            LOGGER.warn("Not supported flow-server version: " + flowServerVersion);
        } else {
            LOGGER.warn("flow-server dependency not found in Maven SBOM file");
        }
        return Collections.emptyList();
    }

    Optional<Component> getFlowServerComponent() {
        return this.bomStore.getBom(Ecosystem.MAVEN).getComponents().stream().filter(comp -> FLOW_SERVER.equals(comp.getName())).findFirst();
    }

    public VulnerabilityAnalysis getVulnerabilityAnalysis() {
        return this.githubService.getVulnerabilityAnalysis();
    }

    public void scheduleAutomaticScan() {
        long secondsUntilNextScan;
        this.checkForInitialization();
        long initialDelay = 0L;
        long autoScanPeriod = this.configuration.getAutoScanInterval().getSeconds();
        Instant lastScan = this.data.getLastScan();
        if (lastScan != null && (secondsUntilNextScan = autoScanPeriod - lastScan.until(this.clock.instant(), ChronoUnit.SECONDS)) > 0L) {
            initialDelay = secondsUntilNextScan;
        }
        LOGGER.debug("Scheduling automatic scan every " + autoScanPeriod + " seconds");
        this.scheduledScan = this.configuration.getTaskExecutor().scheduleAtFixedRate(() -> this.scanForVulnerabilities().exceptionally(ex -> {
            LOGGER.error("There was an error with scheduled scan for vulnerabilities", ex);
            return null;
        }), initialDelay, autoScanPeriod, TimeUnit.SECONDS);
    }

    private void cancelScheduledScan() {
        if (this.scheduledScan != null) {
            LOGGER.debug("Cancelling scheduled scan...");
            this.scheduledScan.cancel(false);
        }
    }

    public Registration addScanEventListener(AppSecScanEventListener listener) {
        this.scanEventListeners.add(listener);
        return () -> this.scanEventListeners.remove(listener);
    }

    public CompletableFuture<Void> scanForVulnerabilities() {
        this.checkForInitialization();
        ScheduledExecutorService executor = this.configuration.getTaskExecutor();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(this.vulnerabilityStore::refresh, executor).thenRun(this.githubService::updateReleasesCache)).thenRun(this.githubService::updateAnalysisCache)).thenRun(this::updateLastScanTime)).thenApply(vulnerabilities -> new AppSecScanEvent(this))).thenAccept(this::invokeEventListeners);
    }

    private void invokeEventListeners(AppSecScanEvent event) {
        LOGGER.debug("Invoking {} scan event listeners...", (Object)this.scanEventListeners.size());
        this.scanEventListeners.forEach(listener -> listener.scanCompleted(event));
    }

    public List<Dependency> getDependencies() {
        return this.dtoProvider.getDependencies();
    }

    public List<Vulnerability> getVulnerabilities() {
        return this.dtoProvider.getVulnerabilities();
    }

    public List<Vulnerability> getNewVulnerabilities() {
        return this.getVulnerabilities().stream().filter(this::newVulnerability).toList();
    }

    private boolean newVulnerability(Vulnerability vulnerability) {
        String vulnerabilityId = vulnerability.getIdentifier();
        return !this.getData().getVulnerabilities().containsKey(vulnerabilityId);
    }

    public synchronized AppSecData getData() {
        if (this.data == null) {
            this.readOrCreateDataFile();
        }
        return this.data;
    }

    public synchronized void setData(AppSecData data) {
        if (data == null) {
            throw new IllegalArgumentException("The data object cannot be null");
        }
        this.data = data;
        this.writeDataFile();
    }

    public synchronized AppSecData refresh() {
        this.data = null;
        return this.getData();
    }

    private synchronized void updateLastScanTime() {
        LOGGER.debug("Updating last scan time...");
        AppSecData tempData = this.getData();
        tempData.setLastScan(this.clock.instant());
        this.setData(tempData);
    }

    public AppSecConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized void setConfiguration(AppSecConfiguration configuration) {
        this.configuration = configuration;
        this.data = null;
        this.cancelScheduledScan();
        LOGGER.debug("Set AppSec configuration: " + configuration);
    }

    private void checkForInitialization() {
        if (this.data == null || this.bomStore.getBom(Ecosystem.MAVEN) == null) {
            throw new AppSecException("The service has not been initialized. You should run the init() method after setting a new configuration");
        }
    }

    private void readOrCreateDataFile() {
        File dataFile = this.configuration.getDataFilePath().toFile();
        if (dataFile.exists()) {
            try {
                this.data = (AppSecData)MAPPER.readValue(dataFile, AppSecData.class);
                LOGGER.debug("Reading AppSec Kit data file " + dataFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new AppSecException("Cannot read the AppSec Kit data file: " + this.configuration.getDataFilePath().toString(), e);
            }
        } else {
            this.data = new AppSecData();
            LOGGER.debug("AppSec Kit data created");
        }
    }

    private void writeDataFile() {
        if (this.data != null) {
            File dataFile = this.configuration.getDataFilePath().toFile();
            try {
                MAPPER.writeValue(dataFile, (Object)this.data);
                LOGGER.debug("AppSec Kit data file updated " + dataFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new AppSecException("Cannot write the AppSec Kit data file: " + this.configuration.getDataFilePath().toString(), e);
            }
        }
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    static {
        MAPPER.registerModule((Module)new JavaTimeModule());
        MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    private static final class InstanceHolder {
        static final AppSecService instance = new AppSecService(new AppSecConfiguration());

        private InstanceHolder() {
        }
    }
}

