/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.appsec.backend;

import com.vaadin.appsec.backend.AppSecService;
import com.vaadin.appsec.backend.AppSecUtils;
import com.vaadin.appsec.backend.BillOfMaterialsStore;
import com.vaadin.appsec.backend.VulnerabilityStore;
import com.vaadin.appsec.backend.model.AppSecData;
import com.vaadin.appsec.backend.model.analysis.AffectedVersion;
import com.vaadin.appsec.backend.model.analysis.Assessment;
import com.vaadin.appsec.backend.model.analysis.VulnerabilityDetails;
import com.vaadin.appsec.backend.model.dto.Dependency;
import com.vaadin.appsec.backend.model.dto.SeverityLevel;
import com.vaadin.appsec.backend.model.dto.SeverityLevelComparator;
import com.vaadin.appsec.backend.model.dto.Vulnerability;
import com.vaadin.appsec.backend.model.osv.response.Affected;
import com.vaadin.appsec.backend.model.osv.response.Ecosystem;
import com.vaadin.appsec.backend.model.osv.response.Event;
import com.vaadin.appsec.backend.model.osv.response.OpenSourceVulnerability;
import com.vaadin.appsec.backend.model.osv.response.Range;
import com.vaadin.appsec.backend.model.osv.response.Severity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Property;
import us.springett.cvss.Cvss;

class AppSecDTOProvider {
    private static final String INTRODUCED = "introduced";
    private static final String FIXED = "fixed";
    private static final String LAST_AFFECTED = "last_affected";
    private static final String LIMIT = "limit";
    private final VulnerabilityStore vulnerabilityStore;
    private final BillOfMaterialsStore bomStore;

    AppSecDTOProvider(VulnerabilityStore vulnerabilityStore, BillOfMaterialsStore bomStore) {
        this.vulnerabilityStore = vulnerabilityStore;
        this.bomStore = bomStore;
    }

    List<Dependency> getDependencies() {
        List<OpenSourceVulnerability> vulnerabilities = this.vulnerabilityStore.getVulnerabilities();
        ArrayList dependencies = new ArrayList(this.bomStore.getBom(Ecosystem.MAVEN).getDependencies());
        if (this.bomStore.getBom(Ecosystem.NPM) != null) {
            dependencies.addAll(this.bomStore.getBom(Ecosystem.NPM).getDependencies());
        }
        ArrayList components = new ArrayList(this.bomStore.getBom(Ecosystem.MAVEN).getComponents());
        if (this.bomStore.getBom(Ecosystem.NPM) != null) {
            components.addAll(this.bomStore.getBom(Ecosystem.NPM).getComponents());
        }
        return components.stream().map(component -> {
            Ecosystem ecosystem = AppSecUtils.getEcosystem(component);
            Dependency dependency = new Dependency(ecosystem, component.getGroup(), component.getName(), component.getVersion());
            dependencies.stream().filter(dep -> Objects.nonNull(dep.getDependencies()) && dep.getDependencies().stream().anyMatch(transDep -> transDep.getRef().equals(component.getBomRef()))).findFirst().ifPresent(parent -> dependency.setParentBomRef(parent.getRef()));
            if (dependency.getEcosystem() == Ecosystem.NPM) {
                dependency.setDevDependency(this.isDevDependency((Component)component));
            }
            this.updateVulnerabilityStatistics(dependency, vulnerabilities);
            return dependency;
        }).toList();
    }

    List<Vulnerability> getVulnerabilities() {
        List<Dependency> dependencies = this.getDependencies();
        List<OpenSourceVulnerability> vulnerabilities = this.vulnerabilityStore.getVulnerabilities();
        ArrayList<Vulnerability> vulnerabilityDTOs = new ArrayList<Vulnerability>();
        for (OpenSourceVulnerability vulnerability : vulnerabilities) {
            for (Affected affected : vulnerability.getAffected()) {
                if (!this.isMavenEcosystem(affected) && !this.isNpmEcosystem(affected)) continue;
                for (Dependency dependency : dependencies) {
                    if (!this.isVulnerable(dependency, affected)) continue;
                    Vulnerability vulnerabilityDTO = this.createVulnerabilityDTO(vulnerability, dependency, affected);
                    vulnerabilityDTOs.add(vulnerabilityDTO);
                }
            }
        }
        return vulnerabilityDTOs;
    }

    private boolean isMavenEcosystem(Affected affected) {
        return Ecosystem.MAVEN.value().equalsIgnoreCase(affected.getPackage().getEcosystem());
    }

    private boolean isNpmEcosystem(Affected affected) {
        return Ecosystem.NPM.value().equalsIgnoreCase(affected.getPackage().getEcosystem());
    }

    private boolean isVulnerable(Dependency dependency, Affected affected) {
        String vulnDepGroup = AppSecUtils.getVulnDepGroup(affected);
        String vulnDepName = AppSecUtils.getVulnDepName(affected);
        List<String> versions = affected.getVersions();
        List<Range> ranges = affected.getRanges();
        return this.isSameGroup(dependency.getGroup(), vulnDepGroup) && this.isSameName(dependency.getName(), vulnDepName) && this.isVersionAffected(dependency.getVersion(), versions, ranges);
    }

    private boolean isSameGroup(String depGroup, String vulnDepGroup) {
        return depGroup == null && vulnDepGroup == null || depGroup != null && depGroup.equals(vulnDepGroup);
    }

    private boolean isSameName(String depName, String vulnDepName) {
        return depName.equals(vulnDepName);
    }

    private boolean isVersionAffected(String depVersion, List<String> versions, List<Range> ranges) {
        return this.includedInVersions(depVersion, versions) || this.includedInRanges(depVersion, ranges);
    }

    private boolean includedInVersions(String depVersion, List<String> versions) {
        return versions != null && versions.contains(depVersion);
    }

    private boolean includedInRanges(String depVersion, List<Range> ranges) {
        if (ranges != null) {
            DefaultArtifactVersion depArtifactVersion = new DefaultArtifactVersion(depVersion);
            for (Range range : ranges) {
                List<Event> events = range.getEvents();
                if (!this.beforeLimits(events, (ArtifactVersion)depArtifactVersion) || !this.evaluateEvents(events, (ArtifactVersion)depArtifactVersion)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluateEvents(List<Event> events, ArtifactVersion version) {
        boolean vulnerable = false;
        for (Event event : events) {
            Optional<ArtifactVersion> introduced = this.getVersionFromEvent(event, INTRODUCED);
            Optional<ArtifactVersion> fixed = this.getVersionFromEvent(event, FIXED);
            Optional<ArtifactVersion> lastAffected = this.getVersionFromEvent(event, LAST_AFFECTED);
            if (introduced.isPresent() && version.compareTo((Object)introduced.get()) >= 0) {
                vulnerable = true;
                continue;
            }
            if (fixed.isPresent() && version.compareTo((Object)fixed.get()) >= 0) {
                vulnerable = false;
                continue;
            }
            if (!lastAffected.isPresent() || version.compareTo((Object)lastAffected.get()) <= 0) continue;
            vulnerable = false;
        }
        return vulnerable;
    }

    private Optional<ArtifactVersion> getVersionFromEvent(Event event, String eventName) {
        if (event.getAdditionalProperties().containsKey(eventName)) {
            String version = (String)event.getAdditionalProperties().get(eventName);
            return Optional.of(new DefaultArtifactVersion(version));
        }
        return Optional.empty();
    }

    private boolean beforeLimits(List<Event> events, ArtifactVersion version) {
        boolean noLimitEvent = true;
        for (Event event : events) {
            if (!event.getAdditionalProperties().containsKey(LIMIT)) continue;
            noLimitEvent = false;
            break;
        }
        if (noLimitEvent) {
            return true;
        }
        for (Event event : events) {
            String limit = (String)event.getAdditionalProperties().get(LIMIT);
            DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(limit);
            if (version.compareTo((Object)artifactVersion) >= 0) continue;
            return true;
        }
        return false;
    }

    private Vulnerability createVulnerabilityDTO(OpenSourceVulnerability vuln, Dependency depDTO, Affected affected) {
        String id = this.getVulnerabilityId(vuln);
        Vulnerability vulnerabilityDTO = new Vulnerability(id);
        vulnerabilityDTO.setDependency(depDTO);
        vulnerabilityDTO.setDatePublished(vuln.getPublished());
        String patchedVersion = this.getPatchedVersion(affected).orElse("---");
        vulnerabilityDTO.setPatchedVersion(patchedVersion);
        if (vuln.getDetails() != null) {
            Node document = Parser.builder().build().parse(vuln.getDetails());
            vulnerabilityDTO.setDetails(HtmlRenderer.builder().build().render(document));
        }
        Optional<AffectedVersion> affectedVersion = this.getAffectedVersion(vulnerabilityDTO);
        affectedVersion.ifPresent(vulnerabilityDTO::setAffectedVersion);
        Map<String, AppSecData.VulnerabilityAssessment> vulnerabilityAssessments = AppSecService.getInstance().getData().getVulnerabilities();
        AppSecData.VulnerabilityAssessment vulnerabilityAssessment = vulnerabilityAssessments.get(id);
        if (vulnerabilityAssessment != null) {
            vulnerabilityDTO.setDeveloperStatus(vulnerabilityAssessment.getStatus());
            vulnerabilityDTO.setDeveloperAnalysis(vulnerabilityAssessment.getDeveloperAnalysis());
            vulnerabilityDTO.setDeveloperUpdated(vulnerabilityAssessment.getUpdated());
        }
        HashSet<String> urls = new HashSet<String>();
        vuln.getReferences().forEach(ref -> urls.add(ref.getUrl().toString()));
        vulnerabilityDTO.setReferenceUrls(urls);
        return vulnerabilityDTO;
    }

    private boolean isDevDependency(Component component) {
        for (Property property : component.getProperties()) {
            if (!property.getName().equals("cdx:npm:package:development") || !property.getValue().equals("true")) continue;
            return true;
        }
        return false;
    }

    private void updateVulnerabilityStatistics(Dependency dependency, List<OpenSourceVulnerability> vulnerabilities) {
        int vulnerabilityCount = 0;
        SeverityLevel highestSeverityLevel = SeverityLevel.NONE;
        Double highestScoreNumber = 0.0;
        String highestScoreString = "";
        for (OpenSourceVulnerability vulnerability : vulnerabilities) {
            for (Affected affected : vulnerability.getAffected()) {
                if (!this.isMavenEcosystem(affected) && !this.isNpmEcosystem(affected) || !this.isVulnerable(dependency, affected)) continue;
                ++vulnerabilityCount;
                highestSeverityLevel = this.findSeverityIfHigher(vulnerability, highestSeverityLevel);
                highestScoreNumber = this.findScoreIfHigher(vulnerability, highestScoreNumber);
                highestScoreString = this.getHighestCvssScoreString(vulnerability, highestScoreNumber, highestScoreString);
            }
        }
        dependency.setNumOfVulnerabilities(vulnerabilityCount);
        dependency.setSeverityLevel(highestSeverityLevel);
        dependency.setRiskScore(highestScoreNumber);
        dependency.setCvssString(highestScoreString);
    }

    private SeverityLevel findSeverityIfHigher(OpenSourceVulnerability vulnerability, SeverityLevel highestSeverityLevel) {
        if (vulnerability.getSeverity() == null) {
            return highestSeverityLevel;
        }
        Double vulnScore = this.getHighestCvssScoreNumber(vulnerability);
        SeverityLevel severityLevel = SeverityLevel.getSeverityLevelForCvssScore(vulnScore);
        return SeverityLevelComparator.compareStatic(severityLevel, highestSeverityLevel) > 0 ? severityLevel : highestSeverityLevel;
    }

    private Double findScoreIfHigher(OpenSourceVulnerability vulnerability, Double highestScore) {
        if (vulnerability.getSeverity() == null) {
            return highestScore;
        }
        Double vulnScore = this.getHighestCvssScoreNumber(vulnerability);
        return vulnScore > highestScore ? vulnScore : highestScore;
    }

    private Double getHighestCvssScoreNumber(OpenSourceVulnerability vulnerability) {
        return vulnerability.getSeverity().stream().filter(severity -> this.isSupportedCvssType(severity.getType())).map(severity -> Cvss.fromVector((String)severity.getScore())).filter(Objects::nonNull).map(cvss -> cvss.calculateScore().getBaseScore()).max(Comparator.naturalOrder()).orElse(0.0);
    }

    private String getHighestCvssScoreString(OpenSourceVulnerability vulnerability, Double highestScoreNumber, String highestScoreString) {
        if (vulnerability.getSeverity() == null) {
            return highestScoreString;
        }
        String cvssString = "";
        double tempBaseScore = 0.0;
        for (Severity severity : vulnerability.getSeverity()) {
            double baseScore;
            Cvss cvss;
            if (!this.isSupportedCvssType(severity.getType()) || (cvss = Cvss.fromVector((String)severity.getScore())) == null || !((baseScore = cvss.calculateScore().getBaseScore()) > tempBaseScore)) continue;
            tempBaseScore = baseScore;
            cvssString = severity.getScore();
        }
        return tempBaseScore >= highestScoreNumber ? cvssString : highestScoreString;
    }

    private boolean isSupportedCvssType(Severity.Type type) {
        return type == Severity.Type.CVSS_V2 || type == Severity.Type.CVSS_V3;
    }

    private Optional<String> getPatchedVersion(Affected affected) {
        Optional<String> semVer = this.getFixed(affected, Range.Type.SEMVER);
        if (semVer.isPresent()) {
            return semVer;
        }
        Optional<String> ecoSystem = this.getFixed(affected, Range.Type.ECOSYSTEM);
        if (ecoSystem.isPresent()) {
            return ecoSystem;
        }
        return this.getFixed(affected, Range.Type.GIT);
    }

    private Optional<String> getFixed(Affected affected, Range.Type rangeType) {
        Optional<Object> fixed;
        Optional<Range> range = affected.getRanges().stream().filter(r -> r.getType().equals((Object)rangeType)).findFirst();
        if (range.isPresent() && (fixed = range.get().getEvents().stream().map(event -> event.getAdditionalProperties().get(FIXED)).filter(Objects::nonNull).findFirst()).isPresent()) {
            return Optional.of((String)fixed.get());
        }
        return Optional.empty();
    }

    private String getVulnerabilityId(OpenSourceVulnerability vulnerability) {
        String identifier = vulnerability.getId();
        List<String> aliases = vulnerability.getAliases();
        if (aliases == null || identifier.startsWith("CVE")) {
            return identifier;
        }
        return vulnerability.getAliases().stream().filter(alias -> alias.startsWith("CVE")).findFirst().orElse(vulnerability.getId());
    }

    private Optional<AffectedVersion> getAffectedVersion(Vulnerability vulnerabilityDTO) {
        String vulnerabilityId = vulnerabilityDTO.getIdentifier();
        VulnerabilityDetails vulnerability = AppSecService.getInstance().getVulnerabilityAnalysis().getVulnerabilities().get(vulnerabilityId);
        if (vulnerability == null) {
            return Optional.empty();
        }
        Dependency dependency = vulnerabilityDTO.getDependency();
        String parentBomRef = dependency.getParentBomRef();
        String groupAndName = dependency.getEcosystem() == Ecosystem.MAVEN ? AppSecUtils.bomRefToMavenGroupAndName(parentBomRef) : AppSecUtils.bomRefToNpmGroupAndName(parentBomRef);
        Assessment assessment = vulnerability.getAssessments().get(groupAndName);
        if (assessment == null) {
            return Optional.empty();
        }
        return assessment.getAffectedVersions().values().stream().filter(v -> v.isInRange(AppSecUtils.bomRefToVersion(parentBomRef))).findFirst();
    }
}

