/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.report.good;

import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.minifinder.report.AnalysisPrinter;
import com.vaadin.modernization.minifinder.report.good.ConvertibleApi;
import com.vaadin.modernization.minifinder.report.good.GoodNewsService;
import com.vaadin.modernization.minifinder.report.good.TransformableClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GoodNewsAnalysisPrinter
extends AnalysisPrinter {
    public static final String STAT_LINE_FORMAT_SHORT = "%-40s %15s %15s\n";
    private static final int CONVERTIBLE_APIS_MAX_NUM = 10;
    private static final int TRANSFORMABLE_CLASSES_MINIMUM_COVERAGE = 70;
    private static final int TRANSFORMABLE_CLASSES_MINIMUM_LINES_OF_CODE = 400;
    private static final int TRANSFORMABLE_CLASSES_MAX_NUM = 5;
    private static final int TRANSFORMABLE_CLASSES_NAME_LIMIT_START = 25;
    private static final int TRANSFORMABLE_CLASSES_NAME_LIMIT_END = 10;
    private static final int TRANSFORMABLE_CLASSES_NAME_TRUNCATION_LEN = 3;
    private final boolean fullDetails;
    private final String email;
    private List<TransformableClass> transformableClasses = new ArrayList<TransformableClass>();
    private List<ConvertibleApi> convertibleApis = new ArrayList<ConvertibleApi>();
    private Integer uniqueConvertibleLoc = 0;
    private Integer convertibleLoc = 0;
    private Integer transformedOrEasyToImplement = 0;

    public GoodNewsAnalysisPrinter(boolean fullDetails, String email, boolean isMaven) {
        super(isMaven);
        this.fullDetails = fullDetails;
        this.email = email;
    }

    @Override
    public String print(List<String> projects, List<Occurrence> allOccurences, String version) {
        if (this.fullDetails) {
            return GoodNewsAnalysisPrinter.formatText("Thank you for your request. A Vaadin expert will reach out to you soon by email on " + this.email);
        }
        String goodNewsSummary = this.printGoodNewsSummary(projects, allOccurences, version);
        return this.fullDetails ? super.print(projects, allOccurences, version) + goodNewsSummary : goodNewsSummary;
    }

    public String getFullDetails(List<String> projects, List<Occurrence> allOccurences, String version) {
        StringBuilder goodNewsSummary = new StringBuilder();
        String header = this.getGoodNewsHeader(projects, allOccurences, version);
        goodNewsSummary.append(header);
        goodNewsSummary.append("\n");
        goodNewsSummary.append(this.getSummary());
        goodNewsSummary.append("\n");
        goodNewsSummary.append(this.getTopTransformableClasses());
        goodNewsSummary.append("\n");
        goodNewsSummary.append(this.getTopUsedConvertibleApis());
        goodNewsSummary.append("\n");
        goodNewsSummary.append(this.getNumberOfLinesWithoutConversion(allOccurences));
        goodNewsSummary.append("\n\n");
        goodNewsSummary.append(this.getAutomaticallyTransformedOrEasyToImplement());
        return super.print(projects, allOccurences, version) + goodNewsSummary;
    }

    @Override
    protected String getHeader(List<String> projects, List<Occurrence> allOccurences, String version) {
        return this.fullDetails ? super.getHeader(projects, allOccurences, version) + "\n" + GoodNewsService.INSTANCE.getVersionFileContent() + "\n" : super.getHeader(projects, allOccurences, version);
    }

    private String printGoodNewsSummary(List<String> projects, List<Occurrence> allOccurences, String version) {
        StringBuilder sb = new StringBuilder();
        String header = this.getGoodNewsHeader(projects, allOccurences, version);
        sb.append(header);
        sb.append("\n");
        sb.append(this.getSummary());
        sb.append("\n");
        sb.append(this.getTopTransformableClasses());
        sb.append("\n");
        sb.append(this.getTopUsedConvertibleApis());
        sb.append("\n");
        sb.append(this.getNumberOfLinesWithoutConversion(allOccurences));
        sb.append("\n\n");
        sb.append(this.getAutomaticallyTransformedOrEasyToImplement());
        sb.append("\n\n");
        sb.append("DISCLAIMER");
        sb.append("\n\n");
        sb.append(GoodNewsAnalysisPrinter.formatText("The figures mentioned in this report are generated following the type resolution of your project's build (Maven, Eclipse). The measurements aim to be precise but there are many factors that could lead to an inaccurate measurement like non-compiling code, dependencies on JARs that cannot be found, naming collisions, or differences in behavior of JDKs used at build time or at runtime. Because of that, these figures should be seen as estimates only and not a guarantee for automation coverage."));
        if (this.isMaven()) {
            boolean hasSwing = header.contains("Swing");
            String patterns = hasSwing ? "javax.swing;java.awt;com.jgoodies;org.openide;org.netbeans" : "com.vaadin;org.vaadin.tokenfield;org.vaadin.addons.lazyquerycontainer";
            sb.append("\n\n");
            sb.append("DETAILED ANALYSIS");
            sb.append("\n\n");
            sb.append(GoodNewsAnalysisPrinter.formatText(String.format("In addition to the above summary, the Analyzer is able to output the full details of each API used by your application that match the given patterns. To get full details, please re-run the analysis as: mvn mtk:analyze -DaggregateModules=true -Dpatterns=%s -Demail=youremail@foo.com", patterns)));
            sb.append("\n\n");
            sb.append(GoodNewsAnalysisPrinter.formatText("Full details are sent to you over email and a Vaadin expert will reach out o help in analyzing the results (for no cost). If you need help in running this or have any other questions, please contact us at https://pages.vaadin.com/contact"));
            sb.append("\n\n");
            sb.append("PRIVACY NOTE");
            sb.append("\n\n");
            sb.append(GoodNewsAnalysisPrinter.formatText("By requesting a free detailed report, you agree to be contacted by email by a Vaadin expert. We will receive your email address and the attached data for the purpose of contacting you about it. For details on how we use and protect your data, see our Vaadin Privacy Policy at https://vaadin.com/privacy-policy"));
        }
        if (this.amplitudeException != null && !this.amplitudeException.isBlank()) {
            sb.append(GoodNewsAnalysisPrinter.formatText("Error occurred while executing analytics workflow:\n" + this.amplitudeException));
        }
        return sb.toString();
    }

    private String getGoodNewsHeader(List<String> projects, List<Occurrence> allOccurences, String version) {
        return super.getHeader(projects, allOccurences, version);
    }

    public String getTopUsedConvertibleApis() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(STAT_LINE_FORMAT_SHORT, "Top used 100% convertible APIs", "Occurrences #", ""));
        String separator = String.format(String.format(STAT_LINE_FORMAT_SHORT, "", "", "").replace(' ', '-'), new Object[0]);
        sb.append(separator);
        Collections.sort(this.convertibleApis, Comparator.comparingLong(ConvertibleApi::getCount).reversed());
        for (int i = 0; i < 10 && i < this.convertibleApis.size(); ++i) {
            ConvertibleApi api = this.convertibleApis.get(i);
            sb.append(String.format(STAT_LINE_FORMAT_SHORT, api.getClassName() + ":" + api.getMethodName(), api.getCount(), ""));
        }
        return sb.toString();
    }

    public void addConvertibleApi(String className, String methodName, long count) {
        for (ConvertibleApi api : this.convertibleApis) {
            if (!Objects.equals(className, api.getClassName()) || !Objects.equals(methodName, api.getMethodName())) continue;
            api.setCount(api.getCount() + count);
            return;
        }
        this.convertibleApis.add(new ConvertibleApi(className, methodName, count));
    }

    public void addTransformableClass(TransformableClass clazz) {
        this.transformableClasses.add(clazz);
    }

    public void setConvertibleLoc(Integer convertibleLoc) {
        this.convertibleLoc = convertibleLoc;
    }

    public void setUniqueConvertibleLoc(Integer uniqueConvertibleLoc) {
        this.uniqueConvertibleLoc = uniqueConvertibleLoc;
    }

    public void setTransformedOrEasyToImplement(Integer transformedOrEasyToImplement) {
        this.transformedOrEasyToImplement = transformedOrEasyToImplement;
    }

    private String getTopTransformableClasses() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(STAT_LINE_FORMAT_SHORT, "Top transformable classes by references ", "Automation %", "LOC"));
        String separator = String.format(String.format(STAT_LINE_FORMAT_SHORT, "", "", "").replace(' ', '-'), new Object[0]);
        sb.append(separator);
        List topTransformableClasses = this.transformableClasses.stream().filter(c -> this.getCoveredPercent((TransformableClass)c) >= 70L && c.getAllLoc() >= 400L).collect(Collectors.toList());
        Comparator<TransformableClass> cmp = new Comparator<TransformableClass>(){

            @Override
            public int compare(TransformableClass o1, TransformableClass o2) {
                return Long.compare(o1.getConvertibleLoc(), o2.getConvertibleLoc());
            }
        };
        Collections.sort(topTransformableClasses, cmp.reversed());
        for (int i = 0; i < 5 && i < topTransformableClasses.size(); ++i) {
            TransformableClass tc = (TransformableClass)topTransformableClasses.get(i);
            sb.append(String.format(STAT_LINE_FORMAT_SHORT, this.getTopTransformableClassName(tc.getClassName()), this.getCoveredPercent(tc), tc.getAllLoc()));
        }
        return sb.toString();
    }

    private String getTopTransformableClassName(String className) {
        try {
            if (className.length() <= 38) {
                return className;
            }
            StringBuilder truncationSb = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                truncationSb.append(".");
            }
            String newClassName = className.substring(0, 25) + truncationSb.toString();
            StringBuilder sb = new StringBuilder(newClassName);
            int limit = 0;
            StringBuilder tmp = new StringBuilder();
            for (int i = className.length() - 1; i >= 0 && limit < 10; ++limit, --i) {
                tmp.append(className.charAt(i));
            }
            sb.append(tmp.reverse().toString());
            return sb.toString();
        }
        catch (Exception e) {
            return className;
        }
    }

    private long getCoveredPercent(TransformableClass goodNewsTransformableClasses) {
        long percent = goodNewsTransformableClasses.getCoveredLoc() * 100L / goodNewsTransformableClasses.getConvertibleLoc();
        return percent > 100L ? 100L : percent;
    }

    public String getNumberOfLinesWithoutConversion(List<Occurrence> occurrences) {
        long lines = this.getLinesOfJava(occurrences);
        long nonConvertibleLoc = lines - (long)this.uniqueConvertibleLoc.intValue();
        long coverage = lines == 0L ? 0L : nonConvertibleLoc * 100L / this.getLinesOfJava(occurrences);
        return "Number of lines of code that likely will not require any conversion when moving to Vaadin Flow\n" + nonConvertibleLoc + " (" + coverage + "%)";
    }

    public String getAutomaticallyTransformedOrEasyToImplement() {
        long coverage = this.convertibleLoc == 0 ? 0L : (long)(this.transformedOrEasyToImplement * 100 / this.convertibleLoc);
        return "Number of references that can be automatically transformed to Vaadin Flow today or are easy to implement \n" + this.transformedOrEasyToImplement + " (" + coverage + "%)";
    }

    private static String formatText(String txt) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (String word : txt.split(" ")) {
            if (i > 100) {
                sb.append("\n");
                i = 0;
            }
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(word);
            i += word.length();
        }
        return sb.toString();
    }
}

