/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.report;

import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.common.Reporting;
import com.vaadin.modernization.common.SyntacticPrimitive;
import com.vaadin.modernization.minifinder.report.AnalysisPrinter;
import com.vaadin.modernization.minifinder.report.ConstructorInvocationSignatureAggregator;
import com.vaadin.modernization.minifinder.report.MethodCoverageAggregator;
import com.vaadin.modernization.minifinder.report.MethodCoverageRecord;
import com.vaadin.modernization.minifinder.report.TypeCoverageAggregator;
import com.vaadin.modernization.minifinder.report.TypeCoverageRecord;
import com.vaadin.modernization.minifinder.report.good.GoodNewsService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AnalysisCalculator {
    public static final boolean MAXIFINDER_MODE = true;
    private static int PRINT_NUMBER = 5;
    private TypeCoverageAggregator typeCoverageAggregator;

    public void processStats(AnalysisPrinter analysisPrinter, List<Occurrence> methodInvocations, Map<String, List<Occurrence>> methodInvocationsPerComponent, List<Occurrence> typeExpressions, List<Occurrence> allOccurrences) {
        analysisPrinter.setMethodOccurrences(methodInvocations);
        analysisPrinter.setTypeOccurences(typeExpressions);
        this.processTypeExpressions(typeExpressions, analysisPrinter, allOccurrences);
        this.processMethodInvocations(analysisPrinter, methodInvocationsPerComponent, allOccurrences);
        this.appendTypeCoverageTable(analysisPrinter);
    }

    private void appendTypeCoverageTable(AnalysisPrinter analysisPrinter) {
        analysisPrinter.addFreeText("");
        analysisPrinter.addFreeText("Direct Type Dependencies Coverage");
        if (this.typeCoverageAggregator == null) {
            return;
        }
        for (Map.Entry<String, TypeCoverageRecord> co : this.sortCountedTypeCoverage(this.typeCoverageAggregator.getAggregates()).entrySet()) {
            analysisPrinter.addStatLine(co.getKey(), "", co.getValue().getCoverage(), co.getValue().getTotalOccurance(), true, true);
        }
    }

    private void processTypeExpressions(List<Occurrence> typeExpressions, AnalysisPrinter analysisPrinter, List<Occurrence> allOccurrences) {
        for (Occurrence typeOccurence : typeExpressions) {
            String clazz = typeOccurence.getInheritedClass();
            if (clazz != null && clazz.endsWith("[]")) {
                clazz = clazz.substring(0, clazz.length() - 2);
            }
            boolean isCovered = GoodNewsService.INSTANCE.isCovered(GoodNewsService.getRuleHashVersion(typeOccurence, allOccurrences), clazz);
            analysisPrinter.saveTypeCoverage(1L, isCovered ? 1L : 0L);
            if (this.typeCoverageAggregator == null) {
                this.typeCoverageAggregator = new TypeCoverageAggregator();
            }
            this.typeCoverageAggregator.initForType(clazz);
            this.typeCoverageAggregator.addCoverageInfo(clazz, 1L, isCovered ? 1L : 0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processMethodInvocations(AnalysisPrinter analysisPrinter, Map<String, List<Occurrence>> methodInvocationsPerComponent, List<Occurrence> allOccurrences) {
        PRINT_NUMBER = Integer.MAX_VALUE;
        HashMap<String, MethodCoverageAggregator> componentMethodCoverageAggregator = new HashMap<String, MethodCoverageAggregator>();
        HashMap<String, ConstructorInvocationSignatureAggregator> componentCISCoverageAggregator = new HashMap<String, ConstructorInvocationSignatureAggregator>();
        for (Map.Entry<String, List<Occurrence>> mi : methodInvocationsPerComponent.entrySet()) {
            List<Occurrence> componentOccurrences = mi.getValue();
            Map<String, Long> countedOccurrences = componentOccurrences.stream().collect(Collectors.groupingBy(Occurrence::getMethodSignature, Collectors.counting()));
            HashMap signatureToOccurrence = new HashMap();
            componentOccurrences.forEach(o -> signatureToOccurrence.put(o.getMethodSignature(), o));
            String fullClassName = mi.getKey();
            MethodCoverageAggregator mca = new MethodCoverageAggregator(fullClassName);
            ConstructorInvocationSignatureAggregator cisa = new ConstructorInvocationSignatureAggregator(fullClassName);
            componentMethodCoverageAggregator.put(fullClassName, mca);
            componentCISCoverageAggregator.put(fullClassName, cisa);
            for (Map.Entry<String, Long> entry : countedOccurrences.entrySet()) {
                String methodSignature = entry.getKey();
                Occurrence occurrence = (Occurrence)signatureToOccurrence.get(methodSignature);
                boolean isConstructor = methodSignature.indexOf("<init>") > -1;
                String methodName = null;
                methodName = methodSignature;
                Long count = entry.getValue();
                Long coverage = this.findCount(occurrence, occurrence.getDependencyClass(), methodSignature, count, allOccurrences);
                if (!isConstructor) {
                    mca.initForMethod(methodName);
                    mca.addCoverageInfo(methodName, coverage, count);
                } else {
                    cisa.initForMethod(methodSignature);
                    cisa.addCoverageInfo(methodSignature, coverage, count);
                }
                analysisPrinter.saveMethodCoverage(isConstructor ? "Constructor Invocation Signature" : "Method Invocation", count, coverage);
            }
        }
        List sortedAggregators = componentMethodCoverageAggregator.values().stream().sorted((a1, a2) -> Long.compare(a2.getTotalOccurenceCount(), a1.getTotalOccurenceCount())).collect(Collectors.toList());
        Long classPrintNumber = 0L;
        Long otherMethodNumber = 0L;
        Long otherMethodCoverage = 0L;
        for (MethodCoverageAggregator componentCoverageInfo : sortedAggregators) {
            void var15_18;
            Long methodPrintNumber = 0L;
            Long otherCoverage = 0L;
            Long otherTotal = 0L;
            Long l = 0L;
            Long totalSum = 0L;
            HashMap<String, MethodCoverageRecord> methodNameBasedCoverageInfo = componentCoverageInfo.getAggregates();
            String fullClassName = componentCoverageInfo.getComponentClass();
            String finalClassName = null;
            finalClassName = fullClassName;
            boolean firstPrint = true;
            for (Map.Entry<String, MethodCoverageRecord> co : this.sortCounted(methodNameBasedCoverageInfo).entrySet()) {
                String methodName = co.getKey();
                long coverage = co.getValue().getTotalOfCoveragesPerMethodSignature();
                long count = co.getValue().getTotalOfTotalsPerMethodSignature();
                Long l2 = var15_18.longValue() + coverage;
                totalSum = totalSum + count;
                if (classPrintNumber < (long)PRINT_NUMBER) {
                    if (methodPrintNumber < (long)PRINT_NUMBER) {
                        this.addStatLine(analysisPrinter, finalClassName, firstPrint, methodName, coverage, count);
                        firstPrint = false;
                    } else {
                        otherCoverage = otherCoverage + coverage;
                        otherTotal = otherTotal + count;
                    }
                    Long l3 = methodPrintNumber;
                    methodPrintNumber = methodPrintNumber + 1L;
                    continue;
                }
                otherMethodNumber = otherMethodNumber + count;
                otherMethodCoverage = otherMethodCoverage + coverage;
            }
            if (methodPrintNumber - (long)PRINT_NUMBER > 0L) {
                analysisPrinter.addOthersStatLine(methodPrintNumber - (long)PRINT_NUMBER, otherCoverage, otherTotal);
            }
            if (totalSum == 0L) continue;
            if (classPrintNumber < (long)PRINT_NUMBER) {
                analysisPrinter.addStatLineSummary((Long)var15_18, totalSum);
            }
            Long l4 = classPrintNumber;
            classPrintNumber = classPrintNumber + 1L;
        }
        if (classPrintNumber - (long)PRINT_NUMBER > 0L) {
            analysisPrinter.addOthersSummary(classPrintNumber - (long)PRINT_NUMBER, otherMethodCoverage, otherMethodNumber);
        }
        analysisPrinter.addFreeText("");
        analysisPrinter.addFreeText("Constructor Invocation Signature Coverage");
        List sortedCISAggregators = componentCISCoverageAggregator.values().stream().sorted((a1, a2) -> Long.compare(a2.getTotalOccurenceCount(), a1.getTotalOccurenceCount())).collect(Collectors.toList());
        for (ConstructorInvocationSignatureAggregator cisa : sortedCISAggregators) {
            HashMap<String, MethodCoverageRecord> cisCoverageInfo = cisa.getAggregates();
            for (Map.Entry<String, Object> entry : this.sortCounted(cisCoverageInfo).entrySet()) {
                analysisPrinter.addStatLine(cisa.getComponentClass(), entry.getKey(), ((MethodCoverageRecord)entry.getValue()).getTotalOfCoveragesPerMethodSignature(), ((MethodCoverageRecord)entry.getValue()).getTotalOfTotalsPerMethodSignature(), true, true);
            }
        }
    }

    protected void addStatLine(AnalysisPrinter analysisPrinter, String finalClassName, boolean firstPrint, String methodName, long coverage, long count) {
        analysisPrinter.addStatLine(finalClassName, methodName, coverage, count, firstPrint, true);
    }

    private String getMethodName(String methodSignature) {
        if (methodSignature.isEmpty()) {
            return "<init>";
        }
        Pattern methodNamePattern = Pattern.compile("[a-zA-Z0-9_]+(?=\\()");
        Matcher methodNameMatcher = methodNamePattern.matcher(methodSignature);
        if (methodNameMatcher.find()) {
            return methodNameMatcher.group(0);
        }
        return "";
    }

    private Long findCount(Occurrence occurrence, String clazz, String methodSignature, Long count, List<Occurrence> allOccurrences) {
        methodSignature = ((String)methodSignature).isEmpty() ? "<init>" : ((String)methodSignature).trim();
        methodSignature = "\"" + (String)methodSignature + "\"";
        return GoodNewsService.INSTANCE.isCovered(GoodNewsService.getRuleHashVersion(occurrence, allOccurrences), clazz + (String)methodSignature) ? count : 0L;
    }

    private TreeMap<String, MethodCoverageRecord> sortCounted(final Map<String, MethodCoverageRecord> methodNameBasedCoverage) {
        TreeMap<String, MethodCoverageRecord> sorted = new TreeMap<String, MethodCoverageRecord>(new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                Long count2;
                Long count1 = ((MethodCoverageRecord)methodNameBasedCoverage.get(key1)).getTotalOfTotalsPerMethodSignature();
                return Objects.equals(count1, count2 = Long.valueOf(((MethodCoverageRecord)methodNameBasedCoverage.get(key2)).getTotalOfTotalsPerMethodSignature())) ? key1.compareTo(key2) : Long.compare(count1, count2);
            }
        }.reversed());
        sorted.putAll(methodNameBasedCoverage);
        return sorted;
    }

    private TreeMap<String, TypeCoverageRecord> sortCountedTypeCoverage(final Map<String, TypeCoverageRecord> typeCoverage) {
        TreeMap<String, TypeCoverageRecord> sorted = new TreeMap<String, TypeCoverageRecord>(new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                Long count2;
                Long count1 = ((TypeCoverageRecord)typeCoverage.get(key1)).getTotalOccurance();
                return Objects.equals(count1, count2 = Long.valueOf(((TypeCoverageRecord)typeCoverage.get(key2)).getTotalOccurance())) ? key1.compareTo(key2) : Long.compare(count1, count2);
            }
        }.reversed());
        sorted.putAll(typeCoverage);
        return sorted;
    }

    public List<Occurrence> findMethodInvocations(Reporting reporting) {
        return reporting.getOccurrences().stream().filter(o -> this.isSupportedMethod(o.getOccurrenceType())).collect(Collectors.toList());
    }

    public List<Occurrence> findTypeExpressions(Reporting reporting) {
        return reporting.getOccurrences().stream().filter(o -> this.isSupportedTypeExpression(o.getOccurrenceType())).collect(Collectors.toList());
    }

    public List<Occurrence> findStatics(Reporting reporting) {
        return reporting.getOccurrences().stream().filter(o -> SyntacticPrimitive.JDA_STATIC_FIELD.getText().equals(o.getOccurrenceType())).collect(Collectors.toList());
    }

    public List<Occurrence> findStaticInitializers(Reporting reporting) {
        return reporting.getOccurrences().stream().filter(o -> SyntacticPrimitive.JDA_STATIC_INITIALIZER.getText().equals(o.getOccurrenceType())).collect(Collectors.toList());
    }

    private boolean isSupportedTypeExpression(String occurenceType) {
        return AnalysisCalculator.getSupportedPrimitivesText().contains(occurenceType);
    }

    public static List<String> getLegacySupportedPrimitivesText() {
        List<SyntacticPrimitive> primitives = Arrays.asList(SyntacticPrimitive.JDA_TYPE_DECLARATION, SyntacticPrimitive.JDA_TYPE_ARGUMENT, SyntacticPrimitive.JDA_CAST_EXPRESSION, SyntacticPrimitive.JDA_CATCH_VARIABLE_DECLARATION, SyntacticPrimitive.JDA_LOCAL_VAR, SyntacticPrimitive.JDA_QUALIFIED_NAME, SyntacticPrimitive.JDA_INSTANCE_OF_EXPRESSION, SyntacticPrimitive.JDA_METHOD_RETURN_TYPE, SyntacticPrimitive.JDA_SINGLE_VARIABLE_DECLARATION, SyntacticPrimitive.JDA_THROW_TYPE, SyntacticPrimitive.JDA_FOR_LOOP_TYPE, SyntacticPrimitive.JDA_TYPE_PARAMETER, SyntacticPrimitive.JDA_MARKER_ANNOTATION, SyntacticPrimitive.JDA_TYPE_LITERAL);
        return primitives.stream().map(SyntacticPrimitive::getText).collect(Collectors.toList());
    }

    public static Set<String> getSupportedPrimitivesText() {
        return Collections.singleton(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
    }

    private boolean isSupportedMethod(String occurenceType) {
        return Objects.equals("Method Invocation", occurenceType) || Objects.equals("Constructor Invocation Signature", occurenceType);
    }

    public Map<String, List<Occurrence>> findUniqueInvocations(List<Occurrence> methodInvocations) {
        methodInvocations.forEach(o -> {
            if (o.getDependencyClass().isEmpty()) {
                o.setDependencyClass(o.getInheritedClass(), null);
            }
        });
        return methodInvocations.stream().collect(Collectors.groupingBy(Occurrence::getDependencyClassRawType));
    }
}

