/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.mavenplugin;

import com.vaadin.modernization.common.FileAnalysisRequestor;
import com.vaadin.modernization.common.LivitrinLogger;
import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.common.Reporting;
import com.vaadin.modernization.common.Utils;
import com.vaadin.modernization.minifinder.report.AnalysisCalculator;
import com.vaadin.modernization.minifinder.report.good.GoodNewsAnalysisCalculator;
import com.vaadin.modernization.minifinder.report.good.GoodNewsAnalysisPrinter;
import com.vaadin.modernization.minifinder.report.good.GoodNewsService;
import com.vaadin.modernization.minifinder.server.ServerService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.FileASTRequestor;

@Mojo(name="analyze", requiresDependencyResolution=ResolutionScope.COMPILE, instantiationStrategy=InstantiationStrategy.SINGLETON, threadSafe=false)
public class MinifinderMojo
extends AbstractMojo {
    @Parameter(property="useResolvers", defaultValue="true")
    private boolean useResolvers;
    @Parameter(property="enableLogging", defaultValue="false")
    private boolean enableLogging;
    @Parameter(property="patterns", defaultValue="com.vaadin;org.vaadin.tokenfield;org.vaadin.addons.lazyquerycontainer")
    private String patterns;
    @Parameter(property="email", defaultValue="")
    private String email;
    @Parameter(property="aggregateModules", defaultValue="false")
    private boolean aggregateModules;
    @Parameter(readonly=true, defaultValue="UTF-8", required=false)
    private String sourceEncoding;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(readonly=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true, required=true)
    private List<String> testCompilePath;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", readonly=true, required=true)
    private List<String> testCompileSourceRoots;
    private Reporting singletonReporting = null;

    private Reporting getSingletonReporting() {
        if (this.singletonReporting == null) {
            this.getLog().info((CharSequence)"Initializing aggregator reporting mode");
            this.singletonReporting = new Reporting();
        }
        return this.singletonReporting;
    }

    public void execute() throws MojoExecutionException {
        this.minifind(false);
    }

    protected final String minifind(boolean local) throws MojoExecutionException {
        boolean devTest = false;
        String devTestPattern = "";
        for (String pattern : this.patterns.split(";")) {
            if (!pattern.startsWith("dev-test=")) continue;
            devTest = true;
            devTestPattern = pattern;
            break;
        }
        if (devTest) {
            GoodNewsService.INSTANCE.setVersionFilePath(devTestPattern.split("=")[1]);
            GoodNewsService.INSTANCE.init();
        }
        if (!devTest) {
            if (!GoodNewsService.isOnline()) {
                this.getLog().error((CharSequence)"Internet connection not available.\nMTK Analyzer requires internet connection to work properly.");
                return null;
            }
            GoodNewsService.INSTANCE.init();
            try {
                if (!this.isSnapshot() && GoodNewsService.normalizeVersionString(this.getFullVersion()) < GoodNewsService.normalizeVersionString(GoodNewsService.INSTANCE.getFullVersion())) {
                    String currentVersion = this.getFullVersion();
                    String minimumVersion = GoodNewsService.INSTANCE.getFullVersion();
                    this.getLog().error((CharSequence)String.format("This MTK Analyzer is version %s and is too old to interact with the Vaadin server. Please upgrade to version %s", currentVersion, minimumVersion));
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        Utils.USE_RESOLVERS = this.useResolvers;
        LivitrinLogger.init(this.enableLogging);
        this.compileSourceRoots = this.buildPath(this.compileSourceRoots, this.testCompileSourceRoots);
        this.compilePath = this.buildPath(this.compilePath, this.testCompilePath);
        boolean hasError = false;
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (String sourceRoot : this.compileSourceRoots) {
            try {
                if (!Files.exists(Path.of(sourceRoot, new String[0]), new LinkOption[0])) continue;
                sourceFiles.addAll(Utils.loadSourceFiles(sourceRoot));
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Can not get source files from " + sourceRoot));
                hasError = true;
                break;
            }
        }
        if (hasError) {
            return null;
        }
        this.getLog().info((CharSequence)("Analyzing sources for project " + this.project.getGroupId() + ":" + this.project.getArtifactId()));
        Reporting reporting = this.aggregateModules ? this.getSingletonReporting() : new Reporting();
        boolean fullDetails = false;
        ArrayList<Object> patternsList = new ArrayList();
        try {
            patternsList = new ArrayList<String>(Arrays.asList(this.patterns.split(";")));
            fullDetails = this.email != null;
            patternsList.remove(devTestPattern);
            FileAnalysisRequestor analysisRequestor = new FileAnalysisRequestor(patternsList.toArray(new String[patternsList.size()]), null, reporting);
            String[] sourceFilePaths = sourceFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()).toArray(new String[0]);
            ASTParser parser = Utils.createParser(this.compileSourceRoots, this.compilePath, this.sourceEncoding);
            parser.createASTs(sourceFilePaths, Collections.nCopies(sourceFilePaths.length, this.sourceEncoding).toArray(new String[0]), new String[0], (FileASTRequestor)analysisRequestor, null);
        }
        catch (IllegalArgumentException e) {
            this.getLog().error((CharSequence)("Error occured while creating environment: " + e.getMessage()));
            this.getLog().error((CharSequence)"Before running Minifinder, make sure the project(s) compile successfully. ( E.g.: Try mvn clean install )");
            return null;
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)"Unexpected error: ", t);
            t.printStackTrace();
            return null;
        }
        GoodNewsAnalysisCalculator calc = new GoodNewsAnalysisCalculator();
        List<Occurrence> methodInvocations = calc.findMethodInvocations(reporting);
        Map<String, List<Occurrence>> uniqueMethodInvocations = calc.findUniqueInvocations(methodInvocations);
        List<Occurrence> typeExpressions = calc.findTypeExpressions(reporting);
        GoodNewsAnalysisPrinter analysisPrinter = new GoodNewsAnalysisPrinter(fullDetails, this.email, true);
        analysisPrinter.setAllPatterns(List.of(this.patterns.split(";")));
        analysisPrinter.setIsSnapshot(this.isSnapshot());
        analysisPrinter.setSkipAnalytics(this.email != null && !this.email.isBlank());
        analysisPrinter.setPatternsLine(String.join((CharSequence)";", this.patterns));
        if (fullDetails) {
            analysisPrinter.setPatterns(patternsList);
        }
        ((AnalysisCalculator)calc).processStats(analysisPrinter, methodInvocations, uniqueMethodInvocations, typeExpressions, reporting.getOccurrences());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            List<String> javaProjectNames = Arrays.asList(this.project.getBasedir().getAbsolutePath());
            ArrayList<Occurrence> occurrences = reporting.getOccurrences();
            String version = this.getFullVersion();
            analysisPrinter.printToConsole(javaProjectNames, occurrences, version, baos);
            String result = baos.toString();
            baos.close();
            this.getLog().info((CharSequence)result);
            if (local) {
                return analysisPrinter.getFullDetails(javaProjectNames, occurrences, version);
            }
            if (this.email != null) {
                ServerService.INSTANCE.sendDetails(this.email, analysisPrinter.getFullDetails(javaProjectNames, occurrences, version), analysisPrinter);
            } else {
                ServerService.INSTANCE.sendAnalytics(analysisPrinter);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Exception occured.", (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    private String getFullVersion() {
        return this.mojo.getPlugin().getVersion();
    }

    private int getVersion() {
        String version = this.getFullVersion().replace("-SNAPSHOT", "");
        return Integer.parseInt(version.substring(version.lastIndexOf(46) + 1));
    }

    private boolean isSnapshot() {
        return this.mojo.getPlugin().getVersion().toString().contains("SNAPSHOT");
    }

    private List<String> buildPath(List<String> path1, List<String> path2) {
        ArrayList<String> pathResult = new ArrayList<String>();
        for (String p : path1) {
            if (!Files.exists(Path.of(p, new String[0]), new LinkOption[0])) continue;
            pathResult.add(p);
        }
        for (String p : path2) {
            if (!Files.exists(Path.of(p, new String[0]), new LinkOption[0])) continue;
            pathResult.add(p);
        }
        return pathResult;
    }
}

