/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.common;

import com.vaadin.modernization.common.SyntacticPrimitive;
import com.vaadin.modernization.common.Utils;
import java.lang.reflect.Field;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;

public class Occurrence {
    private String source = "";
    private int line = -1;
    private int col = -1;
    private String occurrenceType = "";
    private String dependencyClass = "";
    private String dependencyClassRawType = "";
    private SyntacticPrimitive syntacticPrimitive;
    private String methodSignature = "";
    private String expressionType = "";
    private String inheritedClass = "";
    private String inheritedClassRawType = "";
    private String text = "";
    private String path = "";
    private boolean isError = false;
    private boolean isDead = false;
    private String errorMessage = "";
    private String jarSource;

    public static Occurrence createGenericOccurrence(String physicalPath, CompilationUnit unit, int position) {
        Occurrence o = new Occurrence();
        o.setPath(physicalPath);
        o.setCol(unit.getColumnNumber(position));
        o.setLine(unit.getLineNumber(position));
        return o;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source.replace(';', '/');
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public String getOccurrenceType() {
        return this.occurrenceType;
    }

    public void setOccurrenceType(String occurrenceType) {
        this.occurrenceType = occurrenceType.replace(';', '/');
    }

    public SyntacticPrimitive getSyntacticPrimitive(SyntacticPrimitive sp) {
        return this.syntacticPrimitive;
    }

    public void setSyntacticPrimitive(SyntacticPrimitive sp) {
        this.syntacticPrimitive = sp;
    }

    public String getDependencyClass() {
        return this.dependencyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDependencyClass(String dependencyClass, IBinding binding) {
        this.dependencyClass = dependencyClass.replace(';', '/');
        this.dependencyClassRawType = Utils.removeAllGtLt(this.dependencyClass);
        if (binding != null) {
            try {
                IJavaElement javaElement = binding.getJavaElement();
                if (javaElement == null && binding instanceof ITypeBinding) {
                    Field bindingField = null;
                    try {
                        BinaryTypeBinding btb;
                        Class<?> clazz = binding.getClass();
                        bindingField = clazz.getDeclaredField("binding");
                        bindingField.setAccessible(true);
                        Object btbObj = bindingField.get(binding);
                        if (btbObj instanceof RawTypeBinding) {
                            btbObj = ((RawTypeBinding)btbObj).actualType();
                        } else if (btbObj instanceof ParameterizedTypeBinding) {
                            btbObj = ((ParameterizedTypeBinding)btbObj).actualType();
                        }
                        if (btbObj instanceof BinaryTypeBinding && (btb = (BinaryTypeBinding)btbObj) != null) {
                            this.jarSource = btb.path.toString();
                            return;
                        }
                    }
                    finally {
                        if (bindingField != null) {
                            bindingField.setAccessible(false);
                        }
                    }
                }
                for (int i = 0; i < 25; ++i) {
                    if (javaElement instanceof JarPackageFragmentRoot) {
                        this.jarSource = javaElement.getElementName();
                        break;
                    }
                    javaElement = javaElement.getParent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getDependencyClassRawType() {
        return this.dependencyClassRawType;
    }

    public String getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType.replace(';', '/');
    }

    public String getInheritedClass() {
        return this.inheritedClass;
    }

    public void setInheritedClass(String inheritedClass) {
        this.inheritedClass = inheritedClass.replace(';', '/');
    }

    public String getInheritedClassRawType() {
        return this.inheritedClassRawType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text.replace(';', '/');
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path.replace(';', '/');
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }

    public boolean isDead() {
        return this.isError;
    }

    public String getDead() {
        String retval = "";
        if (this.isDead) {
            retval = "\u2620";
        }
        return retval;
    }

    public void setDead(boolean isDead) {
        this.isDead = isDead;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            errorMessage = "empty message";
        }
        this.errorMessage = errorMessage.replace(';', '/');
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String methodSignature) {
        if (methodSignature == null) {
            methodSignature = "empty message";
        }
        this.methodSignature = methodSignature.replace(';', '/');
    }

    public String getJarSource() {
        return this.jarSource;
    }
}

