/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class LivitrinLogger {
    private static boolean enabled = false;
    private static BufferedWriter llWriter = null;

    private LivitrinLogger() {
    }

    public static void init(boolean e) {
        enabled = e;
        if (enabled) {
            if (llWriter == null) {
                LivitrinLogger.initFile();
            }
        } else if (llWriter != null) {
            try {
                llWriter.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                llWriter = null;
            }
        }
    }

    private static void initFile() {
        try {
            String currentUsersHomeDir = System.getProperty("user.home");
            File fout = new File(currentUsersHomeDir);
            File llFile = new File(fout, "Livitrin" + System.currentTimeMillis() + ".log");
            llWriter = new BufferedWriter(new FileWriter(llFile));
            Date created = new Date();
            llWriter.write("Started " + created.toString() + "\n");
            llWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(String s) {
        if (!enabled) {
            return;
        }
        if (llWriter == null) {
            LivitrinLogger.initFile();
        }
        try {
            llWriter.write(new Date() + "    " + s + "\n");
            llWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

