/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.report.good;

import com.vaadin.modernization.minifinder.report.AnalysisCalculator;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class HashCalculator {
    public static void main(String[] args) throws IOException, NoSuchAlgorithmException {
        HashCalculator.hashRules();
        HashCalculator.hashEstimates();
    }

    private static void hashRules() throws NoSuchAlgorithmException, IOException {
        String source = "";
        String target = "";
        HashCalculator.hash(source, target, HashCalculator::getRuleHashKey);
    }

    private static void hashEstimates() throws NoSuchAlgorithmException, IOException {
        String source = "";
        String target = "";
        HashCalculator.hash(source, target, HashCalculator::getEstimateHashKey);
    }

    private static void hash(String sourcePath, String targetPath, Function<String, String> hashFunc) throws IOException, NoSuchAlgorithmException {
        List<String> lines = Files.readAllLines(Paths.get(sourcePath, new String[0]));
        ArrayList<String> hashes = new ArrayList<String>();
        for (String line : lines) {
            String hashKey;
            if (!line.contains("V8") || (hashKey = hashFunc.apply(line = line.replace("\"", ""))) == null || hashKey.isEmpty()) continue;
            hashes.add(HashCalculator.hashViaSha512(hashKey));
        }
        String joined = String.join((CharSequence)"\n", hashes);
        Path out = Paths.get(targetPath, new String[0]);
        Files.writeString(out, (CharSequence)joined, StandardOpenOption.CREATE);
    }

    private static String getRuleHashKey(String line) {
        String[] content = line.split(";");
        String type = content[3];
        if ("Method Invocation".equals(type) || "Class Instance Creation".equals(type)) {
            String clazz = content[0];
            String signature = content[content.length - 1];
            signature = signature.replace(",", "");
            return clazz + signature;
        }
        if (AnalysisCalculator.getLegacySupportedPrimitivesText().contains(type)) {
            String clazz = content[0];
            return clazz;
        }
        return "";
    }

    private static String getEstimateHashKey(String line) {
        String[] content = line.split(",");
        String clazz = content[0];
        String signature = content[1];
        return "T()".equalsIgnoreCase(signature.trim()) ? clazz : clazz + signature;
    }

    public static String hashViaSha512(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        byte[] messageDigest = md.digest(input.getBytes());
        BigInteger no = new BigInteger(1, messageDigest);
        Object hashtext = no.toString(16);
        while (((String)hashtext).length() < 32) {
            hashtext = "0" + (String)hashtext;
        }
        return hashtext;
    }
}

