/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.report.good;

import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.minifinder.report.good.HashCalculator;
import com.vaadin.modernization.minifinder.report.good.HashVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class GoodNewsService {
    private static final String VERSION_FILE_NAME = "version.txt";
    private static final String HASH_FILE_EXT = ".txt";
    private static final String VERSION_URL = "https://cdn.vaadin.com/dragonfly/version.txt";
    private static final String HASHES_URL = "https://cdn.vaadin.com/dragonfly/%s";
    private static Pattern v7Pattern = Pattern.compile(".*vaadin-.*-7.*");
    private static Pattern v8CompatibilityPattern = Pattern.compile(".*vaadin-compatibility-.*-8.*");
    private static Pattern v8Pattern = Pattern.compile(".*vaadin-.*-8.*");
    private volatile String versionFilePath = "https://cdn.vaadin.com/dragonfly/version.txt";
    private volatile String hashesFilePath = "https://cdn.vaadin.com/dragonfly/%s";
    private volatile String version;
    private volatile String v7RulesVersion;
    private volatile String v8RulesVersion;
    private volatile String swingRulesVersion;
    private volatile String v7EstimatesVersion;
    private volatile String v8EstimatesVersion;
    private volatile String swingEstimatesVersion;
    private volatile boolean initialized;
    private Map<HashVersion, Set<String>> hashes = new ConcurrentHashMap<HashVersion, Set<String>>();
    public static final GoodNewsService INSTANCE = new GoodNewsService();

    public void setVersionFilePath(String versionFilePath) {
        this.versionFilePath = versionFilePath + File.separatorChar + VERSION_FILE_NAME;
        this.hashesFilePath = versionFilePath;
    }

    public void init() {
        if (!this.initialized) {
            try {
                List<String> versionContent = this.readVersionFile();
                this.parseVersions(versionContent);
                this.fillHashes();
                this.initialized = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getVersionFileContent() {
        StringBuilder sb = new StringBuilder();
        sb.append("Version file content:");
        sb.append("\n");
        sb.append(this.version);
        sb.append("\n");
        sb.append(this.v7RulesVersion);
        sb.append("\n");
        sb.append(this.v8RulesVersion);
        sb.append("\n");
        sb.append(this.swingRulesVersion);
        sb.append("\n");
        sb.append(this.v7EstimatesVersion);
        sb.append("\n");
        sb.append(this.v8EstimatesVersion);
        sb.append("\n");
        sb.append(this.swingEstimatesVersion);
        return sb.toString();
    }

    public boolean isCovered(HashVersion version, String signature) {
        try {
            Set<String> coveredSignatures = this.hashes.get((Object)version);
            return coveredSignatures.contains(HashCalculator.hashViaSha512(signature));
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public String getFullVersion() {
        return this.version;
    }

    public int getVersion() {
        return Integer.parseInt(this.version.substring(this.version.lastIndexOf(46) + 1));
    }

    public static boolean isOnline() {
        try {
            URL url = new URL(VERSION_URL);
            url.openConnection();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void fillHashes() throws IOException {
        this.hashes.put(HashVersion.V7_RULES, this.readHashFile(this.getHashFileName(this.v7RulesVersion)));
        this.hashes.put(HashVersion.V8_RULES, this.readHashFile(this.getHashFileName(this.v8RulesVersion)));
        this.hashes.put(HashVersion.SWING_RULES, this.readHashFile(this.getHashFileName(this.swingRulesVersion)));
        this.hashes.put(HashVersion.V7_ESTIMATES, this.readHashFile(this.getHashFileName(this.v7EstimatesVersion)));
        this.hashes.put(HashVersion.V8_ESTIMATES, this.readHashFile(this.getHashFileName(this.v8EstimatesVersion)));
        this.hashes.put(HashVersion.SWING_ESTIMATES, this.readHashFile(this.getHashFileName(this.swingEstimatesVersion)));
    }

    private String getHashFileName(String fileName) {
        return fileName + HASH_FILE_EXT;
    }

    private List<String> readVersionFile() throws IOException {
        return this.readFile(this.versionFilePath);
    }

    private Set<String> readHashFile(String fileName) throws IOException {
        return new HashSet<String>(this.readFile(String.format(this.hashesFilePath, fileName)));
    }

    private List<String> readFile(String url) throws IOException {
        String inputLine;
        URL resource = !url.startsWith("http") ? Path.of(url, new String[0]).toUri().toURL() : new URL(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(resource.openStream()));
        ArrayList<String> lines = new ArrayList<String>();
        while ((inputLine = in.readLine()) != null) {
            lines.add(inputLine);
        }
        in.close();
        return lines;
    }

    private void parseVersions(List<String> versionContent) {
        this.version = versionContent.get(0);
        for (String v : versionContent.subList(1, versionContent.size())) {
            if (v.startsWith("v7-rules")) {
                this.v7RulesVersion = v;
            } else if (v.startsWith("v8-rules")) {
                this.v8RulesVersion = v;
            } else if (v.startsWith("swing-rules")) {
                this.swingRulesVersion = v;
            }
            if (v.startsWith("v7-estimates")) {
                this.v7EstimatesVersion = v;
                continue;
            }
            if (v.startsWith("v8-estimates")) {
                this.v8EstimatesVersion = v;
                continue;
            }
            if (!v.startsWith("swing-estimates")) continue;
            this.swingEstimatesVersion = v;
        }
    }

    public static HashVersion getRuleHashVersion(Occurrence occurrence, List<Occurrence> source) {
        Optional<Occurrence> dependencyCandidate;
        String jarSource = occurrence.getJarSource();
        if ((jarSource == null || jarSource.isBlank()) && (dependencyCandidate = source.stream().filter(o -> o.getJarSource() != null && !o.getJarSource().isBlank()).findFirst()).isPresent()) {
            occurrence = dependencyCandidate.get();
            jarSource = occurrence.getJarSource();
        }
        if (jarSource != null) {
            if (GoodNewsService.isV7(jarSource)) {
                return HashVersion.V7_RULES;
            }
            if (GoodNewsService.isV8(jarSource)) {
                return HashVersion.V8_RULES;
            }
        }
        if (GoodNewsService.isSwingPrefix(occurrence)) {
            return HashVersion.SWING_RULES;
        }
        return HashVersion.V8_RULES;
    }

    public static HashVersion getEstimateHashVersion(Occurrence occurrence, List<Occurrence> source) {
        Optional<Occurrence> dependencyCandidate;
        String jarSource = occurrence.getJarSource();
        if ((jarSource == null || jarSource.isBlank()) && (dependencyCandidate = source.stream().filter(o -> o.getJarSource() != null && !o.getJarSource().isBlank()).findFirst()).isPresent()) {
            occurrence = dependencyCandidate.get();
            jarSource = occurrence.getJarSource();
        }
        if (jarSource != null) {
            if (GoodNewsService.isV7(jarSource)) {
                return HashVersion.V7_ESTIMATES;
            }
            if (GoodNewsService.isV8(jarSource)) {
                return HashVersion.V8_ESTIMATES;
            }
        }
        if (GoodNewsService.isSwingPrefix(occurrence)) {
            return HashVersion.SWING_ESTIMATES;
        }
        return HashVersion.V8_ESTIMATES;
    }

    private static boolean isV8(String jarSource) {
        return v8Pattern.matcher(jarSource).matches() && !v8CompatibilityPattern.matcher(jarSource).matches();
    }

    private static boolean isV7(String jarSource) {
        return v7Pattern.matcher(jarSource).matches() || v8CompatibilityPattern.matcher(jarSource).matches();
    }

    private static boolean isSwingPrefix(Occurrence occurrence) {
        String dependencyClassRawType = occurrence.getDependencyClassRawType();
        return dependencyClassRawType.startsWith("javax.swing.") || dependencyClassRawType.startsWith("java.awt.") || dependencyClassRawType.startsWith("com.jgoodies.") || dependencyClassRawType.startsWith("org.jdesktop.layout.") || dependencyClassRawType.startsWith("org.openide.") || dependencyClassRawType.startsWith("org.netbeans.");
    }
}

