/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.report;

import com.vaadin.modernization.minifinder.report.MethodCoverageRecord;
import java.util.HashMap;
import java.util.stream.Collectors;

public class MethodCoverageAggregator {
    private String componentClass;
    private HashMap<String, MethodCoverageRecord> aggregates = new HashMap();

    public MethodCoverageAggregator(String componentClass) {
        this.componentClass = componentClass;
    }

    public void initForMethod(String methodName) {
        if (!this.aggregates.containsKey(methodName)) {
            this.aggregates.putIfAbsent(methodName, new MethodCoverageRecord(methodName, 0L, 0L));
        }
    }

    public void addCoverageInfo(String methodName, long coverage, long total) {
        MethodCoverageRecord mcr = this.aggregates.get(methodName);
        mcr.addNewSignatureCoverageInfo(coverage, total);
    }

    public HashMap<String, MethodCoverageRecord> getAggregates() {
        return this.aggregates;
    }

    public String getComponentClass() {
        return this.componentClass;
    }

    public long getTotalOccurenceCount() {
        return this.aggregates.values().stream().collect(Collectors.summingLong(MethodCoverageRecord::getTotalOfTotalsPerMethodSignature));
    }

    public long getTotalCoverageCount() {
        return this.aggregates.values().stream().collect(Collectors.summingLong(MethodCoverageRecord::getTotalOfCoveragesPerMethodSignature));
    }
}

