/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.report;

import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.common.SyntacticPrimitive;
import com.vaadin.modernization.minifinder.analytics.AnalyticsService;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnalysisPrinter {
    private Long typesTotal = 0L;
    private Long typesCoverage = 0L;
    protected Long methodInvocationsTotal = 0L;
    protected Long methodInvocationsCoverage = 0L;
    private Long constructorsTotal = 0L;
    private Long constructorsCoverage = 0L;
    private List<String> statLines = new ArrayList<String>();
    private int staticsNum = 0;
    private int staticInitializersNum = 0;
    private List<Occurrence> methodOccurrences = new ArrayList<Occurrence>();
    private List<Occurrence> typeOccurences = new ArrayList<Occurrence>();
    private List<String> patterns = new ArrayList<String>();
    private List<String> allPatterns = new ArrayList<String>();
    private DecimalFormat formatter;
    private static final char THOUSAND_GROUPING_SEPERATOR = ' ';
    private static final boolean IMPORT_FRIENDLY = true;
    private static final boolean SHOW_COVERAGE = false;
    private boolean isSnapshot;
    private boolean skipAnalytics;
    private String eclipseVersion;
    private String version;
    private String linesOfJava;
    private String vaadinLibs;
    protected String amplitudeException;
    private final boolean isMaven;
    private String patternsLine;
    public static final int DECLARING_CLASS_COLUMN_LEN = 40;
    public static final int METHOD_NAME_COLUMN_LEN = 35;
    public static final String STAT_LINE_FORMAT_SHORT = "%-40s %10s\n";
    public static final String STAT_LINE_FORMAT_EXTRA_LONG;
    public static final String STAT_LINE_FORMAT_LONG;

    public AnalysisPrinter(boolean isMaven) {
        this.isMaven = isMaven;
        this.formatter = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());
        DecimalFormatSymbols symbols = this.formatter.getDecimalFormatSymbols();
        this.formatter.setGroupingUsed(false);
        this.formatter.setDecimalFormatSymbols(symbols);
    }

    public boolean isMaven() {
        return this.isMaven;
    }

    public void setStaticsNum(int staticsNum) {
        this.staticsNum = staticsNum;
    }

    public void setStaticInitializersNum(int staticInitializersNum) {
        this.staticInitializersNum = staticInitializersNum;
    }

    public void setPatternsLine(String patternsLine) {
        this.patternsLine = patternsLine;
    }

    public void printToConsole(List<String> javaProjects, List<Occurrence> allOccurences, String version, OutputStream outputStream) throws IOException {
        Object summary;
        if (this.methodOccurrences.isEmpty() && this.typeOccurences.isEmpty()) {
            summary = "The Analyzer looked in your applications for any dependencies that could be resolved to packages that match these patterns:\n" + this.patternsLine + "\nNo matches were found. If this isn't the outcome you were expecting, you can try setting new pattern parameters ";
            summary = this.isMaven ? (String)summary + "explicitly on the command line as follows:\n(for Swing)\nmvn mtk:analyze -DaggregateModules=true -Dpatterns=javax.swing;java.awt;com.jgoodies;org.openide;org.netbeans -Demail=your.email@company.com\n(for Vaadin 7 and 8)\nmvn mtk:analyze -DaggregateModules=true -Dpatterns=com.vaadin;org.vaadin.tokenfield;org.vaadin.addons.lazyquerycontainer" : (String)summary + "in the text field.";
            this.setStatsForEmptyProject(version);
        } else {
            summary = this.print(javaProjects, allOccurences, version);
        }
        outputStream.write(((String)summary).getBytes());
    }

    private void setStatsForEmptyProject(String version) {
        this.setVersion(version);
        this.setLinesOfJava("0");
        this.setVaadinLibs("");
    }

    public String print(List<String> projects, List<Occurrence> allOccurences, String version) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHeader(projects, allOccurences, version));
        sb.append("\n");
        sb.append(this.getSummary());
        sb.append("\n");
        sb.append(this.getStats());
        sb.append(String.join((CharSequence)"", this.statLines));
        sb.append("\n");
        return sb.toString();
    }

    protected String getHeader(List<String> projects, List<Occurrence> allOccurences, String version) {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        StringBuilder sb = new StringBuilder();
        sb.append("Vaadin MTK Analyzer version " + version + "\n");
        sb.append(String.format("Run %s\n", date));
        for (String projectPath : projects) {
            sb.append(String.format("Location: %s\n", projectPath));
        }
        List<Occurrence> filteredOccurences = Stream.concat(this.methodOccurrences.stream(), this.typeOccurences.stream()).collect(Collectors.toList());
        Long v7RefCount = this.getV7References(filteredOccurences);
        Long v8RefCount = this.getV8References(filteredOccurences);
        Long swingRefCount = this.getSwingReferences(filteredOccurences);
        Long emptyCount = (long)filteredOccurences.size() - v7RefCount - v8RefCount - swingRefCount;
        if (v7RefCount > v8RefCount && v7RefCount > swingRefCount) {
            v7RefCount = v7RefCount + emptyCount;
        }
        if (v8RefCount > v7RefCount && v8RefCount > swingRefCount) {
            v8RefCount = v8RefCount + emptyCount;
        }
        if (swingRefCount > v7RefCount && swingRefCount > v8RefCount) {
            swingRefCount = swingRefCount + emptyCount;
        }
        StringBuilder title = new StringBuilder("Found: ");
        if (v8RefCount > 0L) {
            title.append(v8RefCount + " Vaadin 8 references");
        }
        if (v7RefCount > 0L) {
            if (v8RefCount > 0L) {
                title.append(" and ");
            }
            title.append(v7RefCount + " Vaadin 7 references");
        }
        if (swingRefCount > 0L) {
            if (v8RefCount > 0L || v7RefCount > 0L) {
                title.append(" and ");
            }
            title.append(swingRefCount + " Swing references");
        }
        title.append("\n");
        Long linesOfJava = this.getLinesOfJava(allOccurences);
        sb.append((CharSequence)title);
        sb.append(String.format(".. in: %s lines of Java\n", this.formatter.format(this.getLinesOfJava(allOccurences))));
        sb.append(String.format(".. in: %s Java files\n", this.formatter.format(this.getJavaFiles(allOccurences))));
        sb.append(String.format(".. in: %s Java projects\n", this.formatter.format(projects.size())));
        if (!this.patterns.isEmpty()) {
            sb.append(String.format("Searched patterns: %s", this.patterns.stream().collect(Collectors.joining(", "))));
        }
        Object vaadinLibs = "";
        if (v8RefCount > 0L) {
            vaadinLibs = "vaadin8";
        }
        if (v7RefCount > 0L) {
            vaadinLibs = ((String)vaadinLibs).length() > 0 ? (String)vaadinLibs + ";vaadin7" : (String)vaadinLibs + "vaadin7";
        }
        this.setVersion(version);
        this.setLinesOfJava(linesOfJava != null ? linesOfJava.toString() : "");
        this.setVaadinLibs((String)vaadinLibs);
        this.amplitudeException = null;
        this.amplitudeException = AnalyticsService.INSTANCE.send(this.skipAnalytics, this.isSnapshot, version, linesOfJava.toString(), this.allPatterns.stream().collect(Collectors.joining(";")), (String)vaadinLibs, "", "", this.eclipseVersion);
        return sb.toString();
    }

    public void setEclipseVersion(String eclipseVersion) {
        this.eclipseVersion = eclipseVersion;
    }

    public String getEclipseVersion() {
        return this.eclipseVersion;
    }

    private List<Occurrence> internalFilter(List<Occurrence> allOccurences) {
        return allOccurences.stream().filter(oc -> !oc.getOccurrenceType().equals(SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getText()) && !oc.getOccurrenceType().equals(SyntacticPrimitive.PFNDR_LOC.getText()) && !oc.getOccurrenceType().equals(SyntacticPrimitive.JDA_FIELD_ACCESS.getText()) && !oc.getOccurrenceType().equals(SyntacticPrimitive.JDA_EXPRESSION_EVALUATION.getText()) && !oc.getOccurrenceType().equals(SyntacticPrimitive.SPRING_CONSTRUCTOR_INJECTION.getText()) && !oc.getOccurrenceType().equals(SyntacticPrimitive.SPRING_FIELD_INJECTION.getText()) && !oc.getOccurrenceType().equals(SyntacticPrimitive.SPRING_VIEW.getText()) && !oc.getOccurrenceType().equals(SyntacticPrimitive.JDA_MARKER_ANNOTATION.getText())).collect(Collectors.toList());
    }

    public void setMethodOccurrences(List<Occurrence> methodOccurrences) {
        this.methodOccurrences = methodOccurrences;
    }

    public void setTypeOccurences(List<Occurrence> typeOccurences) {
        this.typeOccurences = typeOccurences;
    }

    private Long getV7References(List<Occurrence> allOccurences) {
        Pattern v7Pattern = Pattern.compile(".*vaadin-.*-7.*");
        Pattern v8CompatibilityPattern = Pattern.compile(".*vaadin-compatibility-.*-8.*");
        Long result = allOccurences.stream().filter(o -> o.getJarSource() != null ? v7Pattern.matcher(o.getJarSource()).matches() || v8CompatibilityPattern.matcher(o.getJarSource()).matches() : false).collect(Collectors.counting());
        return result;
    }

    private Long getV8References(List<Occurrence> allOccurences) {
        Pattern v8Pattern = Pattern.compile(".*vaadin-.*-8.*");
        Pattern v8CompatibilityPattern = Pattern.compile(".*vaadin-compatibility-.*-8.*");
        Long result = allOccurences.stream().filter(o -> o.getJarSource() != null ? v8Pattern.matcher(o.getJarSource()).matches() && !v8CompatibilityPattern.matcher(o.getJarSource()).matches() : false).collect(Collectors.counting());
        return result;
    }

    private Long getSwingReferences(List<Occurrence> allOccurences) {
        Long result = allOccurences.stream().filter(o -> o.getDependencyClassRawType().startsWith("javax.swing.") || o.getDependencyClassRawType().startsWith("java.awt.") || o.getDependencyClassRawType().startsWith("com.jgoodies.") || o.getDependencyClassRawType().startsWith("org.jdesktop.layout.") || o.getDependencyClassRawType().startsWith("org.openide.") || o.getDependencyClassRawType().startsWith("org.netbeans.")).collect(Collectors.counting());
        return result;
    }

    protected Long getLinesOfJava(List<Occurrence> allOccurences) {
        Long result = allOccurences.stream().filter(o -> o.getOccurrenceType().equals(SyntacticPrimitive.PFNDR_LOC.getText())).collect(Collectors.summingLong(Occurrence::getLine));
        return result;
    }

    private Long getJavaFiles(List<Occurrence> allOccurences) {
        Long result = allOccurences.stream().filter(o -> o.getOccurrenceType().equals(SyntacticPrimitive.PFNDR_LOC.getText())).collect(Collectors.counting());
        return result;
    }

    private static String prepareFormat(int classNameColumnSizeMultiplier, int methodNameColumnSizeMultiplier) {
        String formatBase = "%-" + 40 * classNameColumnSizeMultiplier + "s %-" + 35 * methodNameColumnSizeMultiplier + "s %10s\n";
        return formatBase.replaceAll("\\d|\\-", "").replace(' ', ';');
    }

    protected String format(String format, Object ... args) {
        Object[] argsTmp = Arrays.copyOfRange(args, 0, args.length - 2);
        argsTmp[argsTmp.length - 1] = args[args.length - 2];
        return String.format(format, argsTmp);
    }

    protected String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Breakdown of references by syntactic construct:\n");
        sb.append(this.format(STAT_LINE_FORMAT_SHORT, "Syntactic construct", "Coverage #", "Total #", "Coverage %"));
        String separator = this.format(STAT_LINE_FORMAT_SHORT, "", "", "", "").replace(' ', '-');
        sb.append(separator);
        Object coveragePercent = "0%";
        if (this.methodInvocationsTotal > 0L) {
            coveragePercent = this.methodInvocationsCoverage * 100L / this.methodInvocationsTotal + "%";
        }
        sb.append(this.format(STAT_LINE_FORMAT_SHORT, "Method invocation", this.formatter.format(this.methodInvocationsCoverage), this.formatter.format(this.methodInvocationsTotal), coveragePercent));
        coveragePercent = "0%";
        if (this.constructorsTotal > 0L) {
            coveragePercent = this.constructorsCoverage * 100L / this.constructorsTotal + "%";
        }
        sb.append(this.format(STAT_LINE_FORMAT_SHORT, "Constructor invocation", this.formatter.format(this.constructorsCoverage), this.formatter.format(this.constructorsTotal), coveragePercent));
        coveragePercent = "0%";
        if (this.typesTotal > 0L) {
            coveragePercent = this.typesCoverage * 100L / this.typesTotal + "%";
        }
        sb.append(this.format(STAT_LINE_FORMAT_SHORT, "Direct Type Dependencies", this.formatter.format(this.typesCoverage), this.formatter.format(this.typesTotal), coveragePercent));
        if (this.staticsNum > 0) {
            sb.append(this.format(STAT_LINE_FORMAT_SHORT, "Static Fields", 0, this.formatter.format(this.staticsNum), "0%"));
        }
        if (this.staticInitializersNum > 0) {
            sb.append(this.format(STAT_LINE_FORMAT_SHORT, "Static Initializers", 0, this.formatter.format(this.staticInitializersNum), "0%"));
        }
        separator = this.format(STAT_LINE_FORMAT_SHORT, "", "", "", "").replace(' ', '=');
        sb.append(separator);
        return sb.toString();
    }

    protected String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("Top methods:\n");
        sb.append(this.format(STAT_LINE_FORMAT_LONG, "Declaring class", "Method", "Coverage #", "Total #", "Coverage %"));
        return sb.toString();
    }

    public void saveMethodCoverage(String type, Long total, Long coverage) {
        if (Objects.equals("Method Invocation", type)) {
            this.methodInvocationsTotal = this.methodInvocationsTotal + total;
            this.methodInvocationsCoverage = this.methodInvocationsCoverage + coverage;
        } else if (Objects.equals("Constructor Invocation Signature", type)) {
            this.constructorsTotal = this.constructorsTotal + total;
            this.constructorsCoverage = this.constructorsCoverage + coverage;
        }
    }

    public void saveTypeCoverage(Long total, Long coverage) {
        this.typesTotal = this.typesTotal + total;
        this.typesCoverage = this.typesCoverage + coverage;
    }

    public void addStatLine(String className, String methodName, Long coverage, Long total, boolean printClassName, boolean extraLong) {
        printClassName = true;
        Object coveragePercent = "0%";
        if (total > 0L) {
            coveragePercent = Math.round((double)coverage.longValue() * 100.0 / (double)total.longValue()) + "%";
        }
        if (extraLong) {
            this.statLines.add(this.format(STAT_LINE_FORMAT_EXTRA_LONG, printClassName ? this.truncate(className, 80) : "", this.truncate(methodName, 105), this.formatter.format(coverage), this.formatter.format(total), coveragePercent));
        } else {
            this.statLines.add(this.format(STAT_LINE_FORMAT_LONG, printClassName ? this.truncate(className, 40) : "", this.truncate(methodName, 35), this.formatter.format(coverage), this.formatter.format(total), coveragePercent));
        }
    }

    public void addOthersStatLine(Long methodNumber, Long coverage, Long total) {
        Object coveragePercent = "0%";
        if (total > 0L) {
            coveragePercent = coverage * 100L / total + "%";
        }
        this.statLines.add(this.format(STAT_LINE_FORMAT_LONG, "", String.format("others (%s)", this.formatter.format(methodNumber)), this.formatter.format(coverage), this.formatter.format(total), coveragePercent));
    }

    public void addStatLineSummary(Long coverageSum, Long totalSum) {
    }

    public void addOthersSummary(Long classNumber, Long coverage, Long methodNumber) {
        Object coveragePercent = "0%";
        if (methodNumber > 0L) {
            coveragePercent = coverage * 100L / methodNumber + "%";
        }
        this.statLines.add(this.format(STAT_LINE_FORMAT_LONG.substring(0, STAT_LINE_FORMAT_LONG.length() - 1), String.format("others (%s)", this.formatter.format(classNumber)), "total", this.formatter.format(coverage), this.formatter.format(methodNumber), coveragePercent));
    }

    public void addFreeText(String txt) {
        this.statLines.add(txt + "\n");
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public void setAllPatterns(List<String> allPatterns) {
        this.allPatterns = allPatterns;
    }

    public void setIsSnapshot(boolean isSnapshot) {
        this.isSnapshot = isSnapshot;
    }

    public void setSkipAnalytics(boolean skip) {
        this.skipAnalytics = true;
    }

    private String truncate(String str, int size) {
        return str.trim();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLinesOfJava() {
        return this.linesOfJava;
    }

    public String getPatterns() {
        return this.allPatterns.stream().collect(Collectors.joining(";"));
    }

    public void setLinesOfJava(String linesOfJava) {
        this.linesOfJava = linesOfJava;
    }

    public String getVaadinLibs() {
        return this.vaadinLibs;
    }

    public void setVaadinLibs(String vaadinLibs) {
        this.vaadinLibs = vaadinLibs;
    }

    static {
        STAT_LINE_FORMAT_LONG = STAT_LINE_FORMAT_EXTRA_LONG = AnalysisPrinter.prepareFormat(3, 2);
    }
}

