/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.analytics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.prefs.Preferences;

public class AnalyticsService {
    private static final String PREFERENCES_PATH = "com/vaadin/addons/modernization";
    private static final String DEVICE_ID_PREFERENCE = "deviceId";
    private static final String AMPLITUDE_URL = "https://api.amplitude.com/2/httpapi";
    private static final String DEV_KEY = "6965ec1642d6fdb1acc0706e284cb258";
    private static final String PROD_KEY = "7ca4a6216751003925d92840c4e7af40";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    public static final AnalyticsService INSTANCE = new AnalyticsService();
    private String version;
    private String loc;
    private String patterns;
    private String vaadinLibs;
    private String eclipseVersion;

    private AnalyticsService() {
    }

    private String getDateTime() {
        LocalDateTime currentDate = LocalDateTime.now();
        return DATE_TIME_FORMATTER.format(currentDate);
    }

    private String getIP() {
        try {
            InetAddress iAddress = InetAddress.getLocalHost();
            String currentIp = iAddress.getHostAddress();
            return currentIp;
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public String getJavaVersion() {
        return ManagementFactory.getRuntimeMXBean().getVmVersion();
    }

    public String send(boolean skip, boolean isSnapshot, String version, String loc, String patterns, String vaadinLibs, String springLib, String osgiLib, String eclipseVersion) {
        this.version = version;
        this.loc = loc;
        this.patterns = patterns;
        this.vaadinLibs = vaadinLibs;
        this.eclipseVersion = eclipseVersion;
        if (skip) {
            return null;
        }
        try {
            URL url = new URL(AMPLITUDE_URL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Accept", "*/*");
            con.setRequestProperty("Content-type", "application/json");
            con.setDoOutput(true);
            JsonObject requestBody = this.prepareRequestBody(isSnapshot, version, loc, patterns, vaadinLibs, springLib, osgiLib, "MTK Analyzer Invocation", eclipseVersion);
            try (OutputStream os = con.getOutputStream();){
                byte[] input = requestBody.toString().getBytes("UTF-8");
                os.write(input, 0, input.length);
            }
            Object builtResponse = "";
            String line = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = reader.readLine()) != null) {
                builtResponse = (String)builtResponse + line;
            }
            reader.close();
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTraceLines = stringWriter.toString();
            printWriter.close();
            return stackTraceLines;
        }
        return null;
    }

    private JsonObject prepareRequestBody(boolean isSnapshot, String version, String loc, String patterns, String vaadinLibs, String springLib, String osgiLib, String eventType, String eclipseVersion) {
        JsonObject body = new JsonObject();
        JsonArray events = new JsonArray();
        body.addProperty("api_key", isSnapshot ? DEV_KEY : PROD_KEY);
        body.add("events", (JsonElement)events);
        JsonObject event = new JsonObject();
        events.add((JsonElement)event);
        event.addProperty("device_id", this.getDeviceId());
        event.addProperty("event_type", eventType);
        JsonObject eventProperties = new JsonObject();
        event.add("event_properties", (JsonElement)eventProperties);
        eventProperties.addProperty("date_time", this.getDateTime());
        eventProperties.addProperty("version", version);
        if (eclipseVersion != null && !eclipseVersion.isBlank()) {
            eventProperties.addProperty("eclipse_version", eclipseVersion);
        }
        eventProperties.addProperty("ip", this.getIP());
        this.getPublicIP().ifPresent(v -> eventProperties.addProperty("public_ip", v));
        this.getCountry().ifPresent(v -> eventProperties.addProperty("country", v));
        this.getCity().ifPresent(v -> eventProperties.addProperty("city", v));
        this.getProKey().ifPresent(v -> {
            Map.Entry entry = v.entrySet().iterator().next();
            String userName = (String)entry.getKey();
            String proKey = (String)entry.getValue();
            eventProperties.addProperty("user_name", userName);
            eventProperties.addProperty("pro_key", proKey);
        });
        eventProperties.addProperty("loc", loc);
        eventProperties.addProperty("patterns", patterns);
        eventProperties.addProperty("java_version", this.getJavaVersion());
        if (vaadinLibs != null && !vaadinLibs.isBlank()) {
            eventProperties.addProperty("vaadin_libs", vaadinLibs);
        }
        return body;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Map<String, String>> getProKey() {
        String userHome = System.getProperty("user.home");
        File proKeyFile = new File(new File(userHome, ".vaadin"), "proKey");
        if (!proKeyFile.exists()) {
            return Optional.empty();
        }
        try (FileReader reader = new FileReader(proKeyFile);){
            JsonObject jsonObj = JsonParser.parseReader((Reader)new FileReader(proKeyFile)).getAsJsonObject();
            String userName = jsonObj.get("username").toString();
            String proKey = jsonObj.get("proKey").toString();
            if (userName == null) return Optional.empty();
            if (proKey == null) return Optional.empty();
            if (userName.isBlank()) return Optional.empty();
            if (proKey.isBlank()) return Optional.empty();
            Optional<Map<String, String>> optional = Optional.of(Collections.singletonMap(userName, proKey));
            return optional;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public Optional<String> getPublicIP() {
        return this.fetchIpInfo("ip");
    }

    private Optional<String> getCountry() {
        return this.fetchIpInfo("country");
    }

    private Optional<String> getCity() {
        return this.fetchIpInfo("city");
    }

    private Optional<String> fetchIpInfo(String suffix) {
        try {
            URL url = new URL("https://ipinfo.io/" + suffix);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            Object builtResponse = "";
            String line = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = reader.readLine()) != null) {
                builtResponse = (String)builtResponse + line;
            }
            reader.close();
            return Optional.of(builtResponse);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public String getDeviceId() {
        String deviceId = this.getSavedDeviceId();
        if (deviceId == null || deviceId.isEmpty()) {
            deviceId = UUID.randomUUID().toString();
            this.saveDeviceId(deviceId);
        }
        return deviceId;
    }

    private String getSavedDeviceId() {
        return Preferences.userRoot().node(PREFERENCES_PATH).get(DEVICE_ID_PREFERENCE, "");
    }

    private void saveDeviceId(String value) {
        Preferences.userRoot().node(PREFERENCES_PATH).put(DEVICE_ID_PREFERENCE, value);
    }

    public String getVersion() {
        return this.version;
    }

    public String getLoc() {
        return this.loc;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public String getVaadinLibs() {
        return this.vaadinLibs;
    }

    public String getEclipseVersion() {
        return this.eclipseVersion;
    }
}

