/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.common;

import com.vaadin.modernization.common.LogicalPhysicalProject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;

public class Utils {
    public static volatile boolean USE_RESOLVERS = true;

    public static LogicalPhysicalProject getJarDependencyOfMethodDeclaration(IMethodBinding arg) {
        LogicalPhysicalProject retval = new LogicalPhysicalProject();
        retval.setPackagePath(arg.getDeclaringClass().getQualifiedName().toString());
        IJavaElement jEParent = arg.getDeclaringClass().getJavaElement();
        if (jEParent != null) {
            Utils.getJarDependencyFromJavaElement(jEParent, retval);
        }
        if (retval.getJarPath() == null || retval.getJarPath().length() < 1) {
            return null;
        }
        return retval;
    }

    public static LogicalPhysicalProject getJarDependencyOfReturnType(IMethodBinding arg) {
        LogicalPhysicalProject retval = new LogicalPhysicalProject();
        retval.setPackagePath(arg.getReturnType().getQualifiedName().toString());
        IJavaElement jEParent = arg.getReturnType().getJavaElement();
        if (jEParent != null) {
            Utils.getJarDependencyFromJavaElement(jEParent, retval);
        }
        if (retval.getJarPath() == null || retval.getJarPath().length() < 1) {
            return null;
        }
        return retval;
    }

    public static LogicalPhysicalProject getJarDependencyOfAnnotation(IAnnotationBinding arg) {
        LogicalPhysicalProject retval = new LogicalPhysicalProject();
        retval.setPackagePath(arg.getAnnotationType().getQualifiedName().toString());
        IJavaElement jEParent = arg.getAnnotationType().getJavaElement();
        if (jEParent != null) {
            Utils.getJarDependencyFromJavaElement(jEParent, retval);
        }
        if (retval.getJarPath() == null || retval.getJarPath().length() < 1) {
            retval.setJarPath("Error, JAR not found");
            return retval;
        }
        return retval;
    }

    public static void getJarDependencyFromJavaElement(IJavaElement arg, LogicalPhysicalProject lpp) {
        IJavaElement jEParent = arg.getParent();
        if (jEParent != null) {
            if (jEParent.getClass() == JarPackageFragmentRoot.class) {
                JarPackageFragmentRoot par = (JarPackageFragmentRoot)jEParent;
                String physical = par.getPath().toString();
                lpp.setJarPath(physical);
            } else {
                Utils.getJarDependencyFromJavaElement(jEParent, lpp);
            }
        }
    }

    public static String removeAllGtLt(String arg) {
        String retval = arg;
        String shorterRetval = Utils.removeOneGtLt(arg);
        while (shorterRetval != retval) {
            retval = shorterRetval;
            shorterRetval = Utils.removeOneGtLt(retval);
        }
        return retval;
    }

    public static String removeOneGtLt(String arg) {
        Object retval = "";
        int right = arg.indexOf(">");
        if (right < 0) {
            return arg;
        }
        int left = right - 1;
        while (arg.charAt(left) != '<') {
            --left;
        }
        retval = arg.substring(0, left) + arg.substring(right + 1);
        return retval;
    }

    public static boolean startsWithAny(String s, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String findNeedleInHierarchy(ITypeBinding arg, String[] needlePrefixes) {
        String retval = "";
        ITypeBinding ittp = arg.getSuperclass();
        if (ittp != null) {
            String test = Utils.getRawQualifiedName(ittp);
            if (Utils.startsWithAny(test, needlePrefixes) && !Utils.isTypeDeclaredInSources((IBinding)ittp)) {
                return test;
            }
            return Utils.findNeedleInHierarchy(ittp, needlePrefixes);
        }
        return retval;
    }

    public static String getRawQualifiedName(ITypeBinding ittp) {
        String test = "";
        test = ittp.isParameterizedType() && ittp.getErasure() != null ? ittp.getErasure().getQualifiedName() : ittp.getQualifiedName();
        return test;
    }

    public static String findNeedleInInterfaces(ITypeBinding arg, String[] needlePrefixes) {
        ITypeBinding tipsuper;
        String retval = "";
        ITypeBinding[] ittps = arg.getInterfaces();
        if (ittps != null && ittps.length > 0) {
            for (ITypeBinding ittp : ittps) {
                String test = Utils.getRawQualifiedName(ittp);
                if (!Utils.startsWithAny(test, needlePrefixes) || Utils.isTypeDeclaredInSources((IBinding)ittp)) continue;
                return test;
            }
        }
        if (retval.length() == 0 && (tipsuper = arg.getSuperclass()) != null) {
            return Utils.findNeedleInInterfaces(tipsuper, needlePrefixes);
        }
        return retval;
    }

    public static String findNeedleInDirectHierarchy(ITypeBinding arg, String[] needlePrefixes) {
        String test;
        String retval = "";
        ITypeBinding ittp = arg.getSuperclass();
        if (ittp != null && Utils.startsWithAny(test = Utils.getRawQualifiedName(ittp), needlePrefixes) && !Utils.isTypeDeclaredInSources((IBinding)ittp)) {
            return test;
        }
        return retval;
    }

    public static List<String> findVaadinInterfaces(ITypeBinding arg, String[] needlePrefixes) {
        ArrayList<String> interfaces = new ArrayList<String>();
        ITypeBinding[] ittps = arg.getInterfaces();
        if (ittps != null && ittps.length > 0) {
            for (ITypeBinding ittp : ittps) {
                String test = Utils.getRawQualifiedName(ittp);
                if (!Utils.startsWithAny(test, needlePrefixes) || Utils.isTypeDeclaredInSources((IBinding)ittp)) continue;
                interfaces.add(test);
            }
        }
        return interfaces;
    }

    public static boolean codeDedTho(ASTNode arg) {
        boolean retval = false;
        if (arg != null) {
            retval = Utils.codeDedTho(arg.getParent(), arg);
        }
        return retval;
    }

    public static boolean codeDedTho(ASTNode argParent, ASTNode arg) {
        boolean retval = false;
        if (argParent != null) {
            if (argParent instanceof IfStatement) {
                IfStatement ifarg = (IfStatement)argParent;
                Object oCondi = ifarg.getExpression().resolveConstantExpressionValue();
                if (oCondi != null && oCondi.equals(Boolean.FALSE)) {
                    if (ifarg.getThenStatement().equals((Object)arg)) {
                        return true;
                    }
                    if (ifarg.getElseStatement().equals((Object)arg)) {
                        return false;
                    }
                } else if (oCondi != null && oCondi.equals(Boolean.TRUE)) {
                    if (ifarg.getThenStatement().equals((Object)arg)) {
                        return false;
                    }
                    if (ifarg.getElseStatement().equals((Object)arg)) {
                        return true;
                    }
                }
            }
            return Utils.codeDedTho(argParent.getParent(), argParent);
        }
        return retval;
    }

    public static boolean isTypeDeclaredInSources(IBinding ittp) {
        if (!USE_RESOLVERS) {
            return false;
        }
        boolean isFromSource = false;
        if (ittp.getKind() == 5) {
            isFromSource = ((IAnnotationBinding)ittp).getAnnotationType().getDeclaringClass().isFromSource();
        } else if (ittp.getKind() != 6) {
            if (ittp.getKind() == 4) {
                isFromSource = ((IMethodBinding)ittp).getDeclaringClass().isFromSource();
            } else if (ittp.getKind() != 7 && ittp.getKind() != 1) {
                if (ittp.getKind() == 2) {
                    isFromSource = ((ITypeBinding)ittp).isFromSource();
                } else if (ittp.getKind() == 3) {
                    isFromSource = ((IVariableBinding)ittp).getDeclaringClass().isFromSource();
                }
            }
        }
        return isFromSource;
    }

    public static List<File> loadSourceFiles(String packageRootPath) throws IOException {
        try (Stream<Path> stream = Files.walk(Paths.get(packageRootPath, new String[0]), new FileVisitOption[0]);){
            List<File> list = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).filter(path -> !path.getFileName().toString().equals("package-info.java")).filter(path -> !path.getFileName().toString().equals("module-info.java")).map(path -> path.toFile()).collect(Collectors.toList());
            return list;
        }
    }

    public static ASTParser createParser(List<String> compileSourceRoots, List<String> compilePath, String sourceEncoding) {
        String[] sources = compileSourceRoots.toArray(new String[0]);
        String[] classpath = compilePath.toArray(new String[0]);
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setKind(8);
        parser.setBindingsRecovery(false);
        parser.setCompilerOptions(Utils.getCompilerOptions());
        parser.setEnvironment(classpath, sources, Collections.nCopies(sources.length, sourceEncoding).toArray(new String[0]), true);
        return parser;
    }

    public static Hashtable<String, String> getCompilerOptions() {
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        return options;
    }
}

