/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tatu;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;

@Tag(value="div")
class SelectItem
extends AbstractSinglePropertyField<SelectItem, Boolean>
implements HasStyle,
Focusable<SelectItem>,
ClickNotifier<SelectItem>,
HasSize {
    SelectItem() {
        super("value", (Object)false, String.class, (SerializableFunction & Serializable)value -> Boolean.valueOf(value), (SerializableFunction & Serializable)value -> "" + value);
        this.getElement().addEventListener("click", (DomEventListener & Serializable)event -> this.toggleValueFromClient());
        DomListenerRegistration reg = this.getElement().addEventListener("keydown", (DomEventListener & Serializable)event -> this.toggleValueFromClient());
        reg.addEventData("event.keyCode");
        reg.addEventData("event.keyCode == 32 ? event.preventDefault() : undefined");
        reg.setFilter("event.keyCode == 32");
        this.getElement().setAttribute("role", "option");
        this.getElement().setAttribute("aria-selected", "false");
    }

    private void toggleValueFromClient() {
        this.setModelValue((Boolean)this.getValue() == false, true);
        if (((Boolean)this.getValue()).booleanValue()) {
            this.getElement().setAttribute("checked", true);
            this.getElement().setAttribute("aria-selected", "true");
        } else {
            this.getElement().removeAttribute("checked");
            this.getElement().setAttribute("aria-selected", "false");
        }
    }

    public void setValue(Boolean value) {
        super.setValue((Object)value);
        if (value.booleanValue()) {
            this.getElement().setAttribute("checked", true);
            this.getElement().setAttribute("aria-selected", "true");
        } else {
            this.getElement().removeAttribute("checked");
            this.getElement().setAttribute("aria-selected", "false");
        }
    }

    void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    boolean isDisabled() {
        return this.getElement().getProperty("disabled", false);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return super.isReadOnly();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    void setTooltipText(String tooltip) {
        if (tooltip != null) {
            String key = "checkbox-" + this.getElement().getProperty("keyId");
            this.setId(key);
            Html html = new Html("<vaadin-tooltip for='" + key + "' text='" + tooltip + "'></vaadin-tooltip>");
            this.getElement().appendChild(new Element[]{html.getElement()});
        }
    }

    void setLabel(String labelText) {
        this.getElement().setText(labelText);
    }

    String getLabel() {
        return this.getElement().getText();
    }

    void click() {
        this.toggleValueFromClient();
        this.fireEvent((ComponentEvent)new ClickEvent((Component)this, false, 0, 0, 0, 0, 0, 0, false, false, false, false));
    }
}

