/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tatu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.component.grid.contextmenu.GridContextMenu;
import com.vaadin.flow.component.grid.dnd.GridDragEndEvent;
import com.vaadin.flow.component.grid.dnd.GridDragStartEvent;
import com.vaadin.flow.component.grid.dnd.GridDropEvent;
import com.vaadin.flow.component.grid.dnd.GridDropMode;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.treegrid.CollapseEvent;
import com.vaadin.flow.component.treegrid.ExpandEvent;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.hierarchy.HasHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.ThemeList;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;
import org.vaadin.tatu.SelectionChangedEvent;

@CssImport(value="./custom-grid-tree-toggle.css", themeFor="custom-grid-tree-toggle")
@JsModule(value="./custom-grid-tree-toggle.ts")
public class Tree<T>
extends Composite<Div>
implements HasHierarchicalDataProvider<T>,
Focusable,
HasComponents,
HasSize,
HasElement,
HasTheme {
    private CustomizedTreeGrid<T> treeGrid = this.createTreeGrid();
    private ValueProvider<T, VaadinIcon> iconProvider;
    private ValueProvider<T, StreamResource> iconSrcProvider;
    private ValueProvider<T, ?> valueProvider;
    private ValueProvider<T, String> tooltipProvider;
    private boolean sanitize = true;
    private Random rand = new Random();
    private boolean selectOnlyLeafs;
    private Grid.SelectionMode selectionMode;
    private T oldValue;

    protected CustomizedTreeGrid<T> createTreeGrid() {
        return new CustomizedTreeGrid();
    }

    public Tree(ValueProvider<T, ?> valueProvider) {
        this.valueProvider = valueProvider;
        this.treeGrid.setHierarchyColumn(valueProvider, this.iconProvider, this.iconSrcProvider, this.tooltipProvider);
        this.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.treeGrid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_NO_ROW_BORDERS});
        this.treeGrid.setSizeFull();
        this.treeGrid.addClassName("tree");
        this.treeGrid.addSelectionListener((SelectionListener & Serializable)e -> {
            Set<Object> value = Collections.emptySet();
            Object item = this.oldValue;
            if (this.selectOnlyLeafs) {
                if (this.selectionMode == Grid.SelectionMode.MULTI) {
                    value = e.getAllSelectedItems().stream().filter(i -> !this.treeGrid.getDataCommunicator().hasChildren(i)).collect(Collectors.toSet());
                    boolean fireEvent = value.size() == e.getAllSelectedItems().size();
                    this.treeGrid.deselectAll();
                    value.forEach(i -> this.treeGrid.select(i));
                    if (fireEvent) {
                        this.fireEvent(new SelectionChangedEvent(this, value, e.isFromClient()));
                    }
                } else if (e.getFirstSelectedItem().isPresent()) {
                    item = !this.treeGrid.getDataCommunicator().hasChildren(e.getFirstSelectedItem().get()) ? e.getFirstSelectedItem().get() : null;
                    Object v0 = item;
                    if (item == null) {
                        this.treeGrid.select(this.oldValue);
                    } else {
                        value = Set.of(item);
                        this.oldValue = item;
                        if (e.isFromClient()) {
                            this.fireEvent(new SelectionChangedEvent(this, value, e.isFromClient()));
                        }
                    }
                } else {
                    this.fireEvent(new SelectionChangedEvent(this, value, e.isFromClient()));
                }
            } else {
                if (this.selectionMode == Grid.SelectionMode.MULTI) {
                    value = e.getAllSelectedItems().stream().collect(Collectors.toSet());
                } else if (e.getFirstSelectedItem().isPresent()) {
                    this.oldValue = item = e.getFirstSelectedItem().get();
                    value = Set.of(item);
                }
                this.fireEvent(new SelectionChangedEvent(this, value, e.isFromClient()));
            }
        });
        this.add(new Component[]{this.treeGrid});
    }

    public Tree(TreeData<T> treeData, ValueProvider<T, ?> valueProvider) {
        this((HierarchicalDataProvider<T, ?>)new TreeDataProvider(treeData), valueProvider);
    }

    public Tree(HierarchicalDataProvider<T, ?> dataProvider, ValueProvider<T, ?> valueProvider) {
        this(valueProvider);
        this.treeGrid.setDataProvider(dataProvider);
    }

    public HierarchicalDataProvider<T, SerializablePredicate<T>> getDataProvider() {
        return this.treeGrid.getDataProvider();
    }

    public Registration addExpandListener(ComponentEventListener<ExpandEvent<T, TreeGrid<T>>> listener) {
        return this.treeGrid.addExpandListener(listener);
    }

    public Registration addCollapseListener(ComponentEventListener<CollapseEvent<T, TreeGrid<T>>> listener) {
        return this.treeGrid.addCollapseListener(listener);
    }

    protected void fireExpandEvent(Collection<T> collection, boolean userOriginated) {
        this.fireEvent((ComponentEvent)new ExpandEvent((Component)this, userOriginated, collection));
    }

    protected void fireCollapseEvent(Collection<T> collection, boolean userOriginated) {
        this.fireEvent((ComponentEvent)new CollapseEvent((Component)this, userOriginated, collection));
    }

    public void expand(T ... items) {
        this.treeGrid.expand(items);
    }

    public void expand(Collection<T> items) {
        this.treeGrid.expand(items);
    }

    public void expandRecursively(Collection<T> items, int depth) {
        this.treeGrid.expandRecursively(items, depth);
    }

    public void collapse(T ... items) {
        this.treeGrid.collapse(items);
    }

    public void collapse(Collection<T> items) {
        this.treeGrid.collapse(items);
    }

    public void collapseRecursively(Collection<T> items, int depth) {
        this.treeGrid.collapseRecursively(items, depth);
    }

    public boolean isExpanded(T item) {
        return this.treeGrid.isExpanded(item);
    }

    public Set<T> getSelectedItems() {
        return this.treeGrid.getSelectedItems();
    }

    public void select(T item) {
        boolean changed = !this.treeGrid.getSelectedItems().contains(item);
        this.treeGrid.select(item);
        if (changed) {
            this.fireEvent(new SelectionChangedEvent(this, this.treeGrid.getSelectedItems(), false));
        }
    }

    public void deselect(T item) {
        boolean changed = this.treeGrid.getSelectedItems().contains(item);
        this.treeGrid.deselect(item);
        if (changed) {
            this.fireEvent(new SelectionChangedEvent(this, this.treeGrid.getSelectedItems(), false));
        }
    }

    public Registration addSelectionListener(ComponentEventListener<SelectionChangedEvent<T, Tree<T>>> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener((Component)this, SelectionChangedEvent.class, listener);
    }

    public MultiSelect<Grid<T>, T> asMultiSelect() {
        return this.treeGrid.asMultiSelect();
    }

    public SingleSelect<Grid<T>, T> asSingleSelect() {
        return this.treeGrid.asSingleSelect();
    }

    public GridSelectionModel<T> getSelectionModel() {
        return this.treeGrid.getSelectionModel();
    }

    public void setHtmlProvider(ValueProvider<T, ?> htmlProvider) {
        this.treeGrid.removeAllColumns();
        Objects.requireNonNull(this.valueProvider, "Caption generator must not be null");
        this.treeGrid.setHierarchyColumnWithHtml(htmlProvider);
        this.treeGrid.getDataCommunicator().reset();
    }

    public void setItemCaptionProvider(ValueProvider<T, ?> valueProvider) {
        Objects.requireNonNull(valueProvider, "Caption generator must not be null");
        this.valueProvider = valueProvider;
        this.treeGrid.setHierarchyColumn(valueProvider, this.iconProvider, this.iconSrcProvider, this.tooltipProvider);
        this.treeGrid.getDataCommunicator().reset();
    }

    public void setItemIconProvider(ValueProvider<T, VaadinIcon> iconProvider) {
        Objects.requireNonNull(iconProvider, "Item icon generator must not be null");
        this.iconProvider = iconProvider;
        this.treeGrid.setHierarchyColumn(this.valueProvider, iconProvider, this.iconSrcProvider, this.tooltipProvider);
        this.treeGrid.getDataCommunicator().reset();
    }

    public void setItemIconSrcProvider(ValueProvider<T, StreamResource> iconSrcProvider) {
        Objects.requireNonNull(iconSrcProvider, "Item icon src generator must not be null");
        this.iconSrcProvider = iconSrcProvider;
        this.treeGrid.setHierarchyColumn(this.valueProvider, this.iconProvider, iconSrcProvider, this.tooltipProvider);
        this.treeGrid.getDataCommunicator().reset();
    }

    public void setItemTooltipProvider(ValueProvider<T, String> tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
        this.treeGrid.setHierarchyColumn(this.valueProvider, this.iconProvider, this.iconSrcProvider, tooltipProvider);
        this.treeGrid.getDataCommunicator().reset();
    }

    public ValueProvider<T, ?> getItemCaptionProvider() {
        return this.valueProvider;
    }

    public ValueProvider<T, VaadinIcon> getIconProvider() {
        return this.iconProvider;
    }

    public ValueProvider<T, StreamResource> getIconSrcProvider() {
        return this.iconSrcProvider;
    }

    public ValueProvider<T, String> getTooltipProvider() {
        return this.tooltipProvider;
    }

    public Registration addItemClickListener(ComponentEventListener<ItemClickEvent<T>> listener) {
        return this.treeGrid.addItemClickListener(listener);
    }

    public GridSelectionModel<T> setSelectionMode(Grid.SelectionMode selectionMode) {
        Objects.requireNonNull(selectionMode, "Can not set selection mode to null");
        this.selectionMode = selectionMode;
        return this.treeGrid.setSelectionMode(selectionMode);
    }

    public String getClassName() {
        return this.treeGrid.getClassName();
    }

    public void setClassName(String className) {
        this.treeGrid.setClassName(className);
    }

    public boolean removeClassName(String className) {
        return this.treeGrid.removeClassName(className);
    }

    public void setId(String id) {
        this.treeGrid.setId(id);
    }

    public Optional<String> getId() {
        return this.treeGrid.getId();
    }

    public GridContextMenu<T> addContextMenu() {
        return this.treeGrid.addContextMenu();
    }

    public void scrollToIndex(int row) throws IllegalArgumentException {
        this.treeGrid.scrollToIndex(row);
    }

    public void scrollToStart() {
        this.treeGrid.scrollToStart();
    }

    public void scrollToEnd() {
        this.treeGrid.scrollToEnd();
    }

    public int getTabIndex() {
        return this.treeGrid.getTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        this.treeGrid.setTabIndex(tabIndex);
    }

    public void focus() {
        this.treeGrid.getElement().executeJs("setTimeout(function(){let firstTd = $0.shadowRoot.querySelector('tr:first-child > td:first-child'); firstTd.focus(); },0)", new Object[]{this.treeGrid.getElement()});
    }

    public void setAllRowsVisible(boolean heightByRows) {
        this.treeGrid.setAllRowsVisible(heightByRows);
    }

    public void setDataProvider(HierarchicalDataProvider<T, ?> dataProvider) {
        this.treeGrid.setDataProvider(dataProvider);
    }

    public void addThemeVariants(GridVariant ... gridVariants) {
        this.treeGrid.addThemeVariants(gridVariants);
    }

    public void removeThemeVariants(GridVariant ... gridVariants) {
        this.treeGrid.removeThemeVariants(gridVariants);
    }

    public void setThemeName(String theme) {
        this.treeGrid.setThemeName(theme);
    }

    public String getThemeName() {
        return this.treeGrid.getElement().getAttribute("theme");
    }

    public ThemeList getThemeNames() {
        return this.treeGrid.getThemeNames();
    }

    public void setSanitize(boolean sanitize) {
        this.sanitize = sanitize;
    }

    private String sanitize(String html) {
        if (this.sanitize) {
            Safelist safelist = Safelist.relaxed().addAttributes(":all", new String[]{"style"}).addEnforcedAttribute("a", "rel", "nofollow");
            String sanitized = Jsoup.clean((String)html, (String)"", (Safelist)safelist, (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
            return sanitized;
        }
        return html;
    }

    public void setDropMode(GridDropMode dropMode) {
        this.treeGrid.setDropMode(dropMode);
    }

    public GridDropMode getDropMode() {
        return this.treeGrid.getDropMode();
    }

    public void setRowsDraggable(boolean rowsDraggable) {
        this.treeGrid.setRowsDraggable(rowsDraggable);
    }

    public boolean isRowsDraggable() {
        return this.treeGrid.isRowsDraggable();
    }

    public Registration addDragStartListener(ComponentEventListener<GridDragStartEvent<T>> listener) {
        return this.treeGrid.addDragStartListener(listener);
    }

    public Registration addDropListener(ComponentEventListener<GridDropEvent<T>> listener) {
        return this.treeGrid.addDropListener(listener);
    }

    public Registration addDragEndListener(ComponentEventListener<GridDragEndEvent<T>> listener) {
        return this.treeGrid.addDragEndListener(listener);
    }

    public HierarchicalDataCommunicator<T> getDataCommunicator() {
        return this.treeGrid.getDataCommunicator();
    }

    public void setSelectOnlyLeafs(boolean selectOnlyLeafs) {
        this.selectOnlyLeafs = selectOnlyLeafs;
    }

    public void scrollToIndex(int ... indexes) {
        this.treeGrid.scrollToIndex(indexes);
    }

    public void setPartNameGenerator(SerializableFunction<T, String> partNameGenerator) {
        this.treeGrid.setPartNameGenerator(partNameGenerator);
    }

    private class CustomizedTreeGrid<T>
    extends TreeGrid<T> {
        private final List<StreamRegistration> registrations = new ArrayList<StreamRegistration>();

        private CustomizedTreeGrid() {
        }

        private Grid.Column<T> setHierarchyColumn(ValueProvider<T, ?> valueProvider) {
            Grid.Column column = this.addColumn((Renderer)LitRenderer.of((String)"<custom-grid-tree-toggle @click=${onClick} @doselect=${onSelect} theme=${item.theme} .leaf=${item.leaf} .expanded=${model.expanded} .level=${model.level}>${item.name}</custom-grid-tree-toggle>").withProperty("theme", (ValueProvider & Serializable)item -> this.getThemeName()).withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)).withProperty("name", (ValueProvider & Serializable)value -> String.valueOf(valueProvider.apply(value))).withFunction("onSelect", (SerializableConsumer & Serializable)item -> {
                if (this.getSelectedItems().contains(item)) {
                    this.deselect(item);
                } else {
                    this.select(item);
                }
            }).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
                if (this.getDataCommunicator().hasChildren(item)) {
                    if (this.isExpanded(item)) {
                        this.collapse(List.of(item), true);
                    } else {
                        this.expand(List.of(item), true);
                    }
                }
            }));
            SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> CustomizedTreeGrid.compareMaybeComparables((Object)valueProvider.apply(a), (Object)valueProvider.apply(b));
            column.setComparator((Comparator)comparator);
            return column;
        }

        private Grid.Column<T> setHierarchyColumnWithHtml(ValueProvider<T, ?> valueProvider) {
            Grid.Column column = this.addColumn((Renderer)LitRenderer.of((String)"<custom-grid-tree-toggle @click=${onClick} @doselect=${onSelect} theme=${item.theme} .leaf=${item.leaf} .expanded=${model.expanded} .level=${model.level} .innerHTML=${item.html}></custom-grid-tree-toggle>").withProperty("theme", (ValueProvider & Serializable)item -> Tree.this.getThemeName()).withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)).withProperty("html", (ValueProvider & Serializable)value -> Tree.this.sanitize(String.valueOf(valueProvider.apply(value)))).withFunction("onSelect", (SerializableConsumer & Serializable)item -> {
                if (this.getSelectedItems().contains(item)) {
                    this.deselect(item);
                } else {
                    this.select(item);
                }
            }).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
                if (this.getDataCommunicator().hasChildren(item)) {
                    if (this.isExpanded(item)) {
                        this.collapse(List.of(item), true);
                    } else {
                        this.expand(List.of(item), true);
                    }
                }
            }));
            SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> CustomizedTreeGrid.compareMaybeComparables((Object)valueProvider.apply(a), (Object)valueProvider.apply(b));
            column.setComparator((Comparator)comparator);
            return column;
        }

        private Grid.Column<T> setHierarchyColumnWithIcon(ValueProvider<T, ?> valueProvider, ValueProvider<T, VaadinIcon> iconProvider, ValueProvider<T, StreamResource> iconSrcProvider) {
            Grid.Column column = this.addColumn((Renderer)LitRenderer.of((String)"<custom-grid-tree-toggle @click=${onClick} @doselect=${onSelect} theme=${item.theme} .leaf=${item.leaf} .expanded=${model.expanded} .level=${model.level}><vaadin-icon style=${item.hasNoImage} padding-right: 10px' src=${item.iconSrc}></vaadin-icon><vaadin-icon style='${item.hasNoIcon} padding-right: 10px' icon=${item.icon}></vaadin-icon>${item.name}</custom-grid-tree-toggle>").withProperty("theme", (ValueProvider & Serializable)item -> Tree.this.getThemeName()).withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)).withProperty("icon", (ValueProvider & Serializable)icon -> iconProvider == null ? null : this.getIcon(iconProvider, icon)).withProperty("hasNoIcon", (ValueProvider & Serializable)icon -> iconProvider == null || this.getIcon(iconProvider, icon) == null ? "display : none;" : null).withProperty("iconSrc", (ValueProvider & Serializable)icon -> iconSrcProvider == null ? null : this.getIconSrc(iconSrcProvider, icon)).withProperty("hasNoImage", (ValueProvider & Serializable)icon -> iconSrcProvider == null || this.getIconSrc(iconSrcProvider, icon) == null ? "display : none;" : null).withProperty("name", (ValueProvider & Serializable)value -> String.valueOf(valueProvider.apply(value))).withFunction("onSelect", (SerializableConsumer & Serializable)item -> {
                if (this.getSelectedItems().contains(item)) {
                    this.deselect(item);
                } else {
                    this.select(item);
                }
            }).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
                if (this.getDataCommunicator().hasChildren(item)) {
                    if (this.isExpanded(item)) {
                        this.collapse(List.of(item), true);
                    } else {
                        this.expand(List.of(item), true);
                    }
                }
            }));
            SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> CustomizedTreeGrid.compareMaybeComparables((Object)valueProvider.apply(a), (Object)valueProvider.apply(b));
            column.setComparator((Comparator)comparator);
            return column;
        }

        private Grid.Column<T> setHierarchyColumnWithTooltip(ValueProvider<T, ?> valueProvider, ValueProvider<T, String> tooltipProvider) {
            Grid.Column column = this.addColumn((Renderer)LitRenderer.of((String)"<custom-grid-tree-toggle id=${item.key} @click=${onClick} @doselect=${onSelect} theme=${item.theme} .leaf=${item.leaf} .expanded=${model.expanded} .level=${model.level}>${item.name}<vaadin-tooltip for=${item.key} text=${item.tooltip}></vaadin-tooltip></custom-grid-tree-toggle>").withProperty("key", (ValueProvider & Serializable)item -> this.randomId("tooltip", 10)).withProperty("theme", (ValueProvider & Serializable)item -> Tree.this.getThemeName()).withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)).withProperty("tooltip", (ValueProvider & Serializable)tooltip -> String.valueOf(tooltipProvider.apply(tooltip))).withProperty("name", (ValueProvider & Serializable)value -> String.valueOf(valueProvider.apply(value))).withFunction("onSelect", (SerializableConsumer & Serializable)item -> {
                if (this.getSelectedItems().contains(item)) {
                    this.deselect(item);
                } else {
                    this.select(item);
                }
            }).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
                if (this.getDataCommunicator().hasChildren(item)) {
                    if (this.isExpanded(item)) {
                        this.collapse(List.of(item), true);
                    } else {
                        this.expand(List.of(item), true);
                    }
                }
            }));
            SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> CustomizedTreeGrid.compareMaybeComparables((Object)valueProvider.apply(a), (Object)valueProvider.apply(b));
            column.setComparator((Comparator)comparator);
            return column;
        }

        private String randomId(String prefix, int chars) {
            int limit = (int)(Math.pow(10.0, chars) - 1.0);
            Object key = "" + Tree.this.rand.nextInt(limit);
            key = String.format("%" + chars + "s", key).replace(' ', '0');
            return prefix + "-" + (String)key;
        }

        public Grid.Column<T> setHierarchyColumn(ValueProvider<T, ?> valueProvider, ValueProvider<T, VaadinIcon> iconProvider, ValueProvider<T, String> tooltipProvider) {
            return this.setHierarchyColumn(valueProvider, iconProvider, null, tooltipProvider);
        }

        public Grid.Column<T> setHierarchyColumn(ValueProvider<T, ?> valueProvider, ValueProvider<T, VaadinIcon> iconProvider, ValueProvider<T, StreamResource> iconSrcProvider, ValueProvider<T, String> tooltipProvider) {
            Grid.Column column;
            this.removeAllColumns();
            if (iconProvider == null && iconSrcProvider == null && tooltipProvider == null) {
                column = this.setHierarchyColumn(valueProvider);
            } else if ((iconProvider != null || iconSrcProvider != null) && tooltipProvider == null) {
                column = this.setHierarchyColumnWithIcon(valueProvider, iconProvider, iconSrcProvider);
            } else if (iconProvider == null && iconSrcProvider == null && tooltipProvider != null) {
                column = this.setHierarchyColumnWithTooltip(valueProvider, tooltipProvider);
            } else {
                column = this.addColumn((Renderer)LitRenderer.of((String)"<custom-grid-tree-toggle id=${item.key} @click=${onClick} .leaf=${item.leaf} .expanded=${model.expanded} .level=${model.level}><vaadin-icon style='${item.hasNoImage} padding-right: 10px' src=${item.iconSrc}></vaadin-icon><vaadin-icon style='${item.hasNoIcon} padding-right: 10px' icon=${item.icon}></vaadin-icon>${item.name}<vaadin-tooltip for=${item.key} text=${item.tooltip}></vaadin-tooltip></custom-grid-tree-toggle>").withProperty("key", (ValueProvider & Serializable)item -> this.randomId("tooltip", 10)).withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)).withProperty("tooltip", (ValueProvider & Serializable)tooltip -> String.valueOf(tooltipProvider.apply(tooltip))).withProperty("icon", (ValueProvider & Serializable)icon -> iconProvider == null ? null : this.getIcon(iconProvider, icon)).withProperty("hasNoIcon", (ValueProvider & Serializable)icon -> iconProvider == null || this.getIcon(iconProvider, icon) == null ? "display : none;" : null).withProperty("iconSrc", (ValueProvider & Serializable)icon -> iconSrcProvider == null ? null : this.getIconSrc(iconSrcProvider, icon)).withProperty("hasNoImage", (ValueProvider & Serializable)icon -> iconSrcProvider == null || this.getIconSrc(iconSrcProvider, icon) == null ? "display : none;" : null).withProperty("name", (ValueProvider & Serializable)value -> String.valueOf(valueProvider.apply(value))).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
                    if (this.getDataCommunicator().hasChildren(item)) {
                        if (this.isExpanded(item)) {
                            this.collapse(List.of(item), true);
                        } else {
                            this.expand(List.of(item), true);
                        }
                    }
                }));
                SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> CustomizedTreeGrid.compareMaybeComparables((Object)valueProvider.apply(a), (Object)valueProvider.apply(b));
                column.setComparator((Comparator)comparator);
            }
            return column;
        }

        private String getIconSrc(ValueProvider<T, StreamResource> iconSrcProvider, T icon) {
            StreamResource streamResource = (StreamResource)iconSrcProvider.apply(icon);
            if (streamResource == null) {
                return null;
            }
            StreamResourceRegistry resourceRegistry = VaadinSession.getCurrent().getResourceRegistry();
            this.registrations.add(resourceRegistry.registerResource((AbstractStreamResource)streamResource));
            return resourceRegistry.getTargetURI((AbstractStreamResource)streamResource).toString();
        }

        private String getIcon(ValueProvider<T, VaadinIcon> iconProvider, T icon) {
            VaadinIcon vaadinIcon = (VaadinIcon)iconProvider.apply(icon);
            if (vaadinIcon == null) {
                return null;
            }
            return "vaadin:" + this.fixIconName(String.valueOf(vaadinIcon));
        }

        private String fixIconName(String name) {
            String trimmed = name.toLowerCase();
            trimmed = trimmed.replace("_", "-");
            return trimmed;
        }

        protected void onDetach(DetachEvent detachEvent) {
            this.registrations.forEach(StreamRegistration::unregister);
            super.onDetach(detachEvent);
        }
    }
}

