/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tatu;

import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ItemIndexProvider;
import com.vaadin.flow.data.provider.LazyDataView;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableSupplier;
import java.util.Optional;
import org.vaadin.tatu.BeanTable;

public class BeanTableLazyDataView<T>
extends AbstractDataView<T>
implements LazyDataView<T> {
    private BeanTable<T> table;
    private int itemCountEstimateIncrease;
    private int itemCountEstimate = -1;

    public BeanTableLazyDataView(SerializableSupplier<? extends DataProvider<T, ?>> dataProviderSupplier, BeanTable<T> component) {
        super(dataProviderSupplier, component);
        this.table = component;
    }

    public void setItemCountFromDataProvider() {
        this.itemCountEstimate = -1;
        this.table.reset(false);
    }

    public void setItemCountEstimate(int itemCountEstimate) {
        this.itemCountEstimate = itemCountEstimate;
        this.table.reset(false);
    }

    public void setItemCountUnknown() {
        this.itemCountEstimate = -1;
    }

    public T getItem(int index) {
        this.getItemIndex(null);
        return this.table.fetchItem(index);
    }

    protected Class<?> getSupportedDataProviderType() {
        return BackEndDataProvider.class;
    }

    public int getItemCountEstimate() {
        return this.itemCountEstimate;
    }

    public void setItemCountEstimateIncrease(int itemCountEstimateIncrease) {
        this.itemCountEstimateIncrease = itemCountEstimateIncrease;
    }

    public int getItemCountEstimateIncrease() {
        return this.itemCountEstimateIncrease;
    }

    public void setItemIndexProvider(ItemIndexProvider<T, ?> itemIndexProvider) {
        ComponentUtil.setData(this.table, ItemIndexProvider.class, itemIndexProvider);
    }

    protected ItemIndexProvider<T, ?> getItemIndexProvider() {
        return (ItemIndexProvider)ComponentUtil.getData(this.table, ItemIndexProvider.class);
    }

    public Optional<Integer> getItemIndex(T item) {
        if (this.getItemIndexProvider() == null) {
            throw new UnsupportedOperationException("getItemIndex method in the LazyDataView requires a callback to fetch the index. Set it with setItemIndexProvider.");
        }
        return Optional.ofNullable(this.getItemIndexProvider().apply(item, this.getFilteredQueryForAllItems()));
    }

    public Optional<Integer> getPageIndex(T item) {
        if (this.getItemIndexProvider() == null) {
            throw new UnsupportedOperationException("getItemIndex method in the LazyDataView requires a callback to fetch the index. Set it with setItemIndexProvider.");
        }
        return Optional.ofNullable(this.getItemIndexProvider().apply(item, this.getFilteredQueryForAllItems()) / this.table.pageLength);
    }

    private Query getFilteredQueryForAllItems() {
        return new Query(0, Integer.MAX_VALUE, this.table.backEndSorting, this.table.inMemorySorting, this.table.filter);
    }
}

