/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tatu;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.FocusOption;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.ContextMenuPosition;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasLazyDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import org.vaadin.tatu.BeanTableDataView;
import org.vaadin.tatu.BeanTableLazyDataView;
import org.vaadin.tatu.BeanTableListDataView;
import org.vaadin.tatu.BeanTableSelectionChangedEvent;
import org.vaadin.tatu.BeanTableVariant;
import org.vaadin.tatu.ItemClickedEvent;
import tools.jackson.databind.JsonNode;

@StyleSheet(value="bean-table.css")
@Tag(value="table")
public class BeanTable<T>
extends HtmlComponent
implements HasListDataView<T, BeanTableListDataView<T>>,
HasDataView<T, Void, BeanTableDataView<T>>,
HasLazyDataView<T, Void, BeanTableLazyDataView<T>>,
HasTheme {
    private final KeyMapper<T> keyMapper = new KeyMapper(this::getItemId);
    private final AtomicReference<DataProvider<T, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;
    private Registration dataProviderListenerRegistration;
    private List<Column<T>> columns = new ArrayList<Column<T>>();
    private boolean htmlAllowed;
    private Class<T> beanType;
    private PropertySet<T> propertySet;
    int pageLength = -1;
    private int currentPage = 0;
    Object filter;
    SerializableComparator<T> inMemorySorting;
    final ArrayList<QuerySortOrder> backEndSorting = new ArrayList();
    private int dataProviderSize = -1;
    private StringProvider<T> classNameProvider;
    private BeanTableLazyDataView<T> lazyDataView;
    private Random rand = new Random();
    private BeanTableI18n i18n;
    private FocusBehavior focusBehavior = FocusBehavior.NONE;
    private Set<T> selected = new HashSet<T>();
    private boolean selectionEnabled = false;
    Element captionElement;
    Element headerElement;
    Element bodyElement;
    Element footerElement;
    ContextMenu menu;
    Button menuButton = new Button((Component)VaadinIcon.MENU.create());
    List<RowItem<T>> rows = new ArrayList<RowItem<T>>();
    private Button previous;
    private Button next;

    public BeanTable() {
        this.setClassName("bean-table");
        this.getElement().setAttribute("role", "grid");
        this.getElement().setAttribute("aria-multiselectable", "false");
        this.headerElement = new Element("thead");
        this.headerElement.setAttribute("role", "rowgroup");
        this.footerElement = new Element("tfoot");
        this.bodyElement = new Element("tbody");
        this.bodyElement.setAttribute("role", "rowgroup");
        this.getElement().appendChild(new Element[]{this.headerElement});
        this.getElement().appendChild(new Element[]{this.bodyElement});
        this.getElement().appendChild(new Element[]{this.footerElement});
        this.captionElement = new Element("caption");
        String id = this.randomId("label", 8);
        this.captionElement.setAttribute("id", id);
        this.getElement().setAttribute("aria-labelledby", id);
        this.getElement().appendChild(new Element[]{this.captionElement});
        this.menu = new ContextMenu();
        this.menu.setPosition(ContextMenuPosition.BOTTOM_END);
        this.menuButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        this.menuButton.addClassName("menu-button");
        this.menuButton.setVisible(false);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.setNoData());
    }

    private void enableKeyboardNavigation() {
        this.bodyElement.executeJs("this.addEventListener('click', (e) => {\n  Array.from(this.rows).forEach(row => Array.from(row.cells).forEach(cell => cell.setAttribute('tabindex','-1')));\n  const cell = e.target;\n  cell.setAttribute('tabindex','0');\n});\nthis.addEventListener('keydown', (e) => {\n  if (e.keyCode == 39) {\n    e.preventDefault();\n    let cell = document.activeElement;\n    const previous = cell;\n    do {\n      cell = cell.nextSibling;\n    } while (cell && (cell.style.display === 'none'));\n    if (cell) {\n      previous.setAttribute('tabindex','-1');\n      cell.setAttribute('tabindex','0');\n      cell.focus();\n    }\n  } else if (e.keyCode == 37) {\n    e.preventDefault();\n    let cell = document.activeElement;\n    const previous = cell;\n    do {\n      cell = cell.previousSibling;\n    } while (cell && (cell.style.display === 'none'));\n    if (cell) {\n      previous.setAttribute('tabindex','-1');\n      cell.setAttribute('tabindex','0');\n      cell.focus();\n    }\n  } else if (e.keyCode == 36) {\n    e.preventDefault();\n    let row = document.activeElement.closest('tr');\n    let col=1;\n    const previous = row.cells[col];\n    while (col < row.cells.length-1 && row.cells[col].style.display && row.cells[col].style.display === 'none') {\n      col++;\n    }\n    if (row) {\n      previous.setAttribute('tabindex','-1');\n      row.cells[col].setAttribute('tabindex','0');\n      row.cells[col].focus();\n    }\n  } else if (e.keyCode == 35) {\n    e.preventDefault();\n    let row = document.activeElement.closest('tr');\n    let col=row.cells.length-1;\n    const previous = row.cells[col];\n    while (col > 1 && row.cells[col].style.display && row.cells[col].style.display === 'none') {\n      col--;\n    }\n    if (row) {\n      previous.setAttribute('tabindex','-1');\n      row.cells[col].setAttribute('tabindex','0');\n      row.cells[col].focus();\n    }\n  } else if (e.keyCode == 40) {\n    e.preventDefault();\n    let col = document.activeElement.cellIndex;\n    let rowIndex = document.activeElement.closest('tr').rowIndex;\n    let row = this.rows[rowIndex];\n    const previous = this.rows[rowIndex-1].cells[col];\n    if (row) {\n      previous.setAttribute('tabindex','-1');\n      row.cells[col].setAttribute('tabindex','0');\n      row.cells[col].focus();\n    }\n  } else if (e.keyCode == 38) {\n    e.preventDefault();\n    let col = document.activeElement.cellIndex;\n    let rowIndex = document.activeElement.closest('tr').rowIndex;\n    let row = this.rows[rowIndex - 2];\n    const previous = this.rows[rowIndex-1].cells[col];\n    if (row) {\n      previous.setAttribute('tabindex','-1');\n      row.cells[col].setAttribute('tabindex','0');\n      row.cells[col].focus();\n    }\n  }\n})", new Object[0]);
    }

    public BeanTable(int pageLength) {
        this();
        this.pageLength = pageLength;
    }

    public BeanTable(Class<T> beanType) {
        this(beanType, true);
    }

    public BeanTable(Class<T> beanType, boolean autoCreateColumns) {
        this();
        Objects.requireNonNull(beanType, "Bean type can't be null");
        this.beanType = beanType;
        this.propertySet = BeanPropertySet.get(beanType);
        if (autoCreateColumns) {
            this.propertySet.getProperties().filter(property -> !property.isSubProperty()).sorted((prop1, prop2) -> prop1.getName().compareTo(prop2.getName())).forEach(this::addColumn);
        }
    }

    public BeanTable(Class<T> beanType, boolean autoCreateColumns, int pageLength) {
        this(beanType, autoCreateColumns);
        this.pageLength = pageLength;
    }

    private Column<T> addColumn(PropertyDefinition<T, ?> property) {
        String propertyName = property.getName();
        String name = this.formatName(propertyName);
        Column<T> column = this.addColumn(name, property.getGetter());
        column.setKey(propertyName);
        return column;
    }

    private String formatName(String propertyName) {
        if (propertyName == null || propertyName.isEmpty()) {
            return "";
        }
        Object name = propertyName.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        return name;
    }

    public void addColumn(String propertyName) {
        Objects.requireNonNull(this.propertySet, "No property set defined, use BeanTable((Class<T> beanType) constructor");
        Objects.requireNonNull(propertyName, "propetyName cannot be null");
        this.propertySet.getProperties().filter(property -> property.getName().equals(propertyName)).findFirst().ifPresent(match -> {
            Column<T> column = this.addColumn(this.formatName(match.getName()), match.getGetter());
            column.setKey(propertyName);
        });
    }

    public void setColumns(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.addColumn(propertyName);
        }
    }

    public Column<T> addColumn(String header, ValueProvider<T, ?> valueProvider) {
        Objects.requireNonNull(valueProvider, "A valueProvider must not be null");
        Column column = new Column(header, valueProvider);
        this.columns.add(column);
        this.updateHeader();
        return column;
    }

    public Column<T> addComponentColumn(String header, ComponentProvider<T> componentProvider) {
        Objects.requireNonNull(componentProvider, "A componentProvider must not be null");
        Column column = new Column();
        column.setHeader(header);
        column.setComponentProvider(componentProvider);
        this.columns.add(column);
        this.updateHeader();
        return column;
    }

    private void updateHeader() {
        this.headerElement.removeAllChildren();
        Element rowElement = new Element("tr");
        rowElement.setAttribute("role", "row");
        Element indexCell = new Element("th");
        indexCell.getClassList().add((Object)"index");
        indexCell.setText("#");
        rowElement.appendChild(new Element[]{indexCell});
        this.menu.removeAll();
        AtomicInteger index = new AtomicInteger(0);
        this.columns.forEach(column -> {
            int i = index.get();
            Element cell = new Element("th");
            cell.setAttribute("role", "columnheader");
            if (column.getHeader() != null) {
                cell.appendChild(new Element[]{column.getHeader().getElement()});
                MenuItem item = (MenuItem)this.menu.addItem(column.getHeader().getElement().getText());
                column.setMenuItem(item);
                item.setCheckable(true);
                item.setChecked(true);
                item.addClickListener((ComponentEventListener & Serializable)e -> {
                    boolean hide = !item.isChecked();
                    this.updateColumnVisibility((Column<?>)column, hide);
                    this.menuButton.focus(new FocusOption[0]);
                });
                item.getElement().getStyle().set("font-size", "var(--lumo-font-size-m)");
                item.getElement().getStyle().set("padding", "0px");
            }
            cell.getStyle().set("width", column.getWidth());
            if (this.focusBehavior == FocusBehavior.BODY_AND_HEADER) {
                cell.setAttribute("tabindex", "0");
            }
            if (!column.isVisible()) {
                cell.getStyle().set("display", "none");
            }
            rowElement.appendChild(new Element[]{cell});
            index.incrementAndGet();
        });
        this.headerElement.appendChild(new Element[]{rowElement});
        this.headerElement.appendChild(new Element[]{this.menuButton.getElement()});
    }

    private void updateColumnVisibility(Column<?> column, boolean hide) {
        int i = this.columns.indexOf(column);
        Element c = this.headerElement.getChild(0).getChild(i + 1);
        if (hide) {
            c.getStyle().set("display", "none");
            this.rows.forEach(row -> row.getRowElement().getChild(i + 1).getStyle().set("display", "none"));
            column.updateVisible(false);
        } else {
            c.getStyle().remove("display");
            this.rows.forEach(row -> row.getRowElement().getChild(i + 1).getStyle().remove("display"));
            column.updateVisible(true);
        }
    }

    private void updateFooter() {
        this.footerElement.removeAllChildren();
        if (this.dataProviderSize > 0) {
            Element rowElement = new Element("tr");
            Element cell = new Element("td");
            cell.setAttribute("colspan", "" + (this.columns.size() + 1));
            rowElement.appendChild(new Element[]{cell});
            Button first = new Button();
            first.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
            first.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            this.previous = new Button();
            this.previous.setIcon((Component)VaadinIcon.ANGLE_LEFT.create());
            this.previous.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            this.next = new Button();
            this.next.setIcon((Component)VaadinIcon.ANGLE_RIGHT.create());
            this.next.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            Button last = new Button();
            last.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
            last.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            int lastPage = this.dataProviderSize % this.pageLength == 0 ? this.dataProviderSize / this.pageLength - 1 : this.dataProviderSize / this.pageLength;
            first.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.currentPage != 0) {
                    this.currentPage = 0;
                    this.getDataProvider().refreshAll();
                    this.focus();
                }
            });
            this.next.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.currentPage < lastPage) {
                    ++this.currentPage;
                    this.getDataProvider().refreshAll();
                    this.focus();
                }
            });
            this.previous.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.currentPage > 0) {
                    --this.currentPage;
                    this.getDataProvider().refreshAll();
                    this.focus();
                }
            });
            last.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.currentPage != lastPage) {
                    this.currentPage = lastPage;
                    this.getDataProvider().refreshAll();
                    this.focus();
                }
            });
            this.updateTooltips(first, this.previous, this.next, last);
            Div div = new Div();
            div.addClassName("bean-table-paging");
            Div spacer = new Div();
            spacer.addClassName("bean-table-page");
            if (this.focusBehavior != FocusBehavior.NONE) {
                spacer.getElement().setAttribute("tabindex", "-1");
            }
            if (this.i18n != null && this.i18n.getPageProvider() != null) {
                spacer.setText((String)this.i18n.getPageProvider().apply((Object)(this.currentPage + 1), (Object)(lastPage + 1)));
            } else {
                spacer.setText(this.currentPage + 1 + "/" + (lastPage + 1));
            }
            div.add(new Component[]{first, this.previous, spacer, this.next, last});
            cell.appendChild(new Element[]{div.getElement()});
            this.footerElement.appendChild(new Element[]{rowElement});
        }
    }

    private void updateTooltips(Button first, Button previous, Button next, Button last) {
        if (this.i18n != null) {
            first.setTooltipText(this.i18n.getFirstPage());
            last.setTooltipText(this.i18n.getLastPage());
            previous.setTooltipText(this.i18n.getPreviousPage());
            next.setTooltipText(this.i18n.getNextPage());
            this.menuButton.setTooltipText(this.i18n.getMenuButton());
        }
    }

    @Deprecated
    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider.set(dataProvider);
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        if (this.getDataProvider() instanceof BackEndDataProvider) {
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
                int estimate = -1;
                estimate = this.getLazyDataView().getItemCountEstimate();
                if (estimate < 0) {
                    this.reset(false);
                }
            });
        } else {
            this.reset(false);
        }
        this.setupDataProviderListener(dataProvider);
    }

    private void setupDataProviderListener(DataProvider<T, ?> dataProvider) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.doRefreshItem(event);
            } else {
                this.reset(false);
            }
        });
    }

    private void doRefreshItem(DataChangeEvent<T> event) {
        Object otherItem = ((DataChangeEvent.DataRefreshEvent)event).getItem();
        this.getRowItems().filter(rowItem -> Objects.equals(this.getItemId(rowItem.getItem()), this.getItemId(otherItem))).findFirst().ifPresent(rowItem -> this.updateRow((RowItem<T>)rowItem, (T)otherItem));
    }

    private RowItem<T> createRow(T item) {
        return new RowItem<T>(this.keyMapper.key(item), item);
    }

    private void addRow(RowItem<T> rowItem, int index) {
        this.rows.add(rowItem);
        rowItem.getRowElement().getChild(0).setText("" + (index + 1));
        rowItem.getRowElement().setAttribute("aria-rowindex", String.valueOf(index + 1));
        if (index % 2 == 0) {
            rowItem.getRowElement().getClassList().add((Object)"even");
        }
        this.bodyElement.appendChild(new Element[]{rowItem.getRowElement()});
    }

    private void setNoData() {
        if (this.rows.isEmpty()) {
            this.bodyElement.setText("");
            Element row = new Element("tr");
            Element cell = this.createAlertCell();
            cell.getClassList().add((Object)"no-data");
            cell.setText(this.i18n != null && this.i18n.getNoDataText() != null ? this.i18n.getNoDataText() : "No data");
            row.appendChild(new Element[]{cell});
            this.bodyElement.appendChild(new Element[]{row});
        }
    }

    private void setError() {
        this.bodyElement.setText("");
        Element row = new Element("tr");
        Element cell = this.createAlertCell();
        cell.getClassList().add((Object)"error-occurred");
        cell.setText(this.i18n != null && this.i18n.getErrorText() != null ? this.i18n.getErrorText() : "Failed fetching data");
        row.appendChild(new Element[]{cell});
        this.bodyElement.appendChild(new Element[]{row});
    }

    private Element createAlertCell() {
        Element cell = new Element("td");
        cell.setAttribute("colspan", "" + (this.columns.size() + 1));
        cell.setAttribute("aria-live", "assertive");
        cell.setAttribute("role", "alert");
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(boolean refresh) {
        if (!refresh) {
            this.bodyElement.setText("");
            this.rows = new ArrayList<RowItem<T>>();
        }
        this.keyMapper.removeAll();
        Query query = null;
        if (this.pageLength < 0) {
            query = new Query();
        } else {
            int estimate = -1;
            if (this.getDataProvider() instanceof BackEndDataProvider) {
                estimate = this.getLazyDataView().getItemCountEstimate();
            }
            AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
            synchronized (atomicReference) {
                this.dataProviderSize = estimate < 0 ? this.getDataProvider().size(new Query(this.filter)) : estimate;
            }
            int offset = this.pageLength * this.currentPage;
            if (this.dataProviderSize < offset) {
                this.currentPage = Math.floorDiv(this.dataProviderSize, this.pageLength);
                offset = this.currentPage * this.pageLength;
            }
            this.updateFooter();
            query = new Query(offset, this.pageLength, this.backEndSorting, this.inMemorySorting, this.filter);
        }
        AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            AtomicInteger itemCounter = new AtomicInteger(0);
            boolean error = false;
            try {
                this.getDataProvider().fetch(query).map(row -> this.createRow(row)).forEach(rowItem -> {
                    int rowIndex = itemCounter.get();
                    RowItem row = (RowItem)rowItem;
                    this.setTabIndex1FirstDataCellOnFirstRow(rowIndex, row);
                    this.addRow(row, this.currentPage * this.pageLength + rowIndex);
                    itemCounter.incrementAndGet();
                });
            }
            catch (Exception e) {
                this.setError();
                error = true;
                LoggerFactory.getLogger(BeanTable.class).error("Could not fetch data");
                e.printStackTrace();
            }
            if (!error) {
                this.setNoData();
            }
            this.lastFetchedDataSize = itemCounter.get();
            if (this.pageLength < 0) {
                this.getElement().setAttribute("aria-rowcount", String.valueOf(this.lastFetchedDataSize));
            } else {
                this.getElement().setAttribute("aria-rowcount", String.valueOf(this.dataProviderSize));
            }
            if (this.sizeRequest == null) {
                this.sizeRequest = (SerializableConsumer & Serializable)ui -> {
                    this.fireSizeEvent();
                    this.sizeRequest = null;
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
        }
    }

    private void setTabIndex1FirstDataCellOnFirstRow(int rowIndex, RowItem<T> row) {
        if (rowIndex == 0) {
            row.getRowElement().getChildren().skip(1L).findFirst().ifPresent(cell -> cell.setAttribute("tabindex", "0"));
        }
    }

    protected T fetchItem(int index) {
        Query query = new Query(index, 1, this.backEndSorting, this.inMemorySorting, this.filter);
        Optional result = this.getDataProvider().fetch(query).findFirst();
        return result.isPresent() ? (T)result.get() : null;
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider.get();
    }

    private Object getItemId(T item) {
        if (this.getDataProvider() == null) {
            return item;
        }
        return this.getDataProvider().getId(item);
    }

    private Stream<RowItem<T>> getRowItems() {
        return this.rows.stream();
    }

    private void updateRow(RowItem<T> rowItem, T item) {
        rowItem.setItem(item);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getDataProvider() != null && this.dataProviderListenerRegistration == null) {
            this.setupDataProviderListener(this.getDataProvider());
        }
        this.detectTheme();
        this.enableKeyboardNavigation();
    }

    private void detectTheme() {
        this.getElement().executeJs("const rootElement = document.documentElement;\nconst style = getComputedStyle(rootElement);\nlet theme = \"\";\ntheme =\n    style.getPropertyValue(\"--vaadin-aura-theme\").trim() === \"1\" ? \"aura\" : \"\";\nif (theme === \"\") {\n    theme =\n        style.getPropertyValue(\"--vaadin-lumo-theme\").trim() === \"1\"\n            ? \"lumo\"\n            : \"\";\n}\nthis.classList.add(theme);\n", new Object[0]);
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
            this.dataProviderListenerRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    public void setHtmlAllowed(boolean htmlAllowed) {
        this.htmlAllowed = htmlAllowed;
    }

    public void setClassNameProvider(StringProvider<T> classNameProvider) {
        this.classNameProvider = classNameProvider;
    }

    public StringProvider<T> getClassNameProvider() {
        return this.classNameProvider;
    }

    public BeanTableDataView<T> getGenericDataView() {
        return new BeanTableDataView(this::getDataProvider, this, this::identifierProviderChanged);
    }

    public BeanTableDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public BeanTableDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public BeanTableListDataView<T> getListDataView() {
        return new BeanTableListDataView(this::getDataProvider, this, this::identifierProviderChanged, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.reset(true));
    }

    public BeanTableListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    public void setItems(Stream<T> streamOfItems) {
        this.setItems((ListDataProvider<T>)DataProvider.fromStream(streamOfItems));
    }

    private void identifierProviderChanged(IdentifierProvider<T> identifierProvider) {
        this.keyMapper.setIdentifierGetter(identifierProvider);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    public BeanTableLazyDataView<T> setItems(BackEndDataProvider<T, Void> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getLazyDataView();
    }

    public BeanTableLazyDataView<T> getLazyDataView() {
        if (this.lazyDataView == null) {
            this.lazyDataView = new BeanTableLazyDataView(this::getDataProvider, this);
        }
        return this.lazyDataView;
    }

    public List<Column<T>> getColumns() {
        return this.columns;
    }

    public Optional<Column<T>> getColumn(String key) {
        Objects.requireNonNull(key, "The key cannot be null");
        return this.columns.stream().filter(col -> col.getKey().equals(key)).findFirst();
    }

    private String randomId(String prefix, int chars) {
        int limit = (int)(Math.pow(10.0, chars) - 1.0);
        Object key = "" + this.rand.nextInt(limit);
        key = String.format("%" + chars + "s", key).replace(' ', '0');
        return prefix + "-" + (String)key;
    }

    public void setCaption(String caption) {
        this.captionElement.setText(caption);
    }

    public void setPage(int page) {
        if (this.pageLength < 0 || page < 0 || page * this.pageLength > this.dataProviderSize) {
            throw new IllegalArgumentException("Page does not exists");
        }
        this.currentPage = page;
        this.reset(false);
    }

    public int getPage() {
        return this.currentPage;
    }

    public int getRowCount() {
        return Integer.valueOf(this.getElement().getAttribute("aria-rowcount"));
    }

    public void setI18n(BeanTableI18n i18n) {
        this.i18n = i18n;
    }

    public BeanTableI18n getI18n() {
        return this.i18n;
    }

    public void focus() {
        this.focus(0, 0);
    }

    public void focus(T item) {
        int rowIndex = this.rows.indexOf(item);
        this.focus(rowIndex, 0);
    }

    public void focus(int row, int col) {
        if (this.focusBehavior != FocusBehavior.NONE) {
            this.bodyElement.executeJs("setTimeout(function(){\n  Array.from($0.rows).forEach(row => Array.from(row.cells).forEach(cell => cell.setAttribute('tabindex','-1')));\n  let row = $0.rows[$1];\n  if (row) {\n    let cell = row.cells[$2];\n    if (cell) {\n      cell.setAttribute('tabindex','0');\n      cell.click();\n      cell.focus()\n    }\n  }\n}, 0);\n", new Object[]{this.bodyElement, row, ++col});
        }
    }

    public void setFocusBehavior(FocusBehavior focusBehavior) {
        this.focusBehavior = focusBehavior == null ? FocusBehavior.NONE : focusBehavior;
    }

    public void addThemeVariants(BeanTableVariant ... variants) {
        this.getThemeNames().addAll(Stream.of(variants).map(BeanTableVariant::getVariantName).toList());
    }

    public void removeThemeVariants(BeanTableVariant ... variants) {
        this.getThemeNames().removeAll(Stream.of(variants).map(BeanTableVariant::getVariantName).toList());
    }

    public void setColumnSelectionMenu(ColumnSelectMenu columnSelect) {
        switch (columnSelect.ordinal()) {
            case 2: {
                this.menu.setTarget((Component)this.menuButton);
                this.menu.setOpenOnClick(true);
                this.menuButton.setVisible(true);
                break;
            }
            case 1: {
                this.menu.setTarget((Component)this);
                this.menu.setOpenOnClick(false);
                this.menuButton.setVisible(false);
                break;
            }
            case 0: {
                this.menu.setTarget(null);
                this.menuButton.setVisible(false);
            }
        }
    }

    public Set<T> getSelected() {
        return this.selected;
    }

    public void select(T ... items) {
        boolean added = false;
        for (T item : items) {
            if (this.selected.contains(item)) continue;
            this.selected.add(item);
            added = true;
        }
        if (added) {
            this.getDataProvider().refreshAll();
            this.fireEvent(new BeanTableSelectionChangedEvent<T, BeanTable>(this, this.selected, false));
        }
    }

    public void deselect(T ... items) {
        boolean removed = false;
        for (T item : items) {
            if (!this.selected.contains(item)) continue;
            this.selected.remove(item);
            removed = true;
        }
        if (removed) {
            this.getDataProvider().refreshAll();
            this.fireEvent(new BeanTableSelectionChangedEvent<T, BeanTable>(this, this.selected, false));
        }
    }

    public void deselectAll() {
        if (!this.selected.isEmpty()) {
            this.selected.clear();
            this.fireEvent(new BeanTableSelectionChangedEvent<T, BeanTable>(this, this.selected, false));
            this.getDataProvider().refreshAll();
        }
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.selectionEnabled = selectionEnabled;
        if (selectionEnabled) {
            this.getElement().setAttribute("aria-multiselectable", "true");
            this.rows.forEach(row -> {
                boolean rowSelected = this.selected.contains(row.getItem());
                row.getRowElement().getChildren().forEach(cell -> cell.setAttribute("aria-selected", rowSelected ? "true" : "false"));
            });
            this.setFocusBehavior(FocusBehavior.BODY_AND_HEADER);
        } else {
            this.getElement().setAttribute("aria-multiselectable", "false");
            this.rows.forEach(row -> {
                boolean rowSelected = this.selected.contains(row.getItem());
                if (!rowSelected) {
                    row.getRowElement().getChildren().forEach(cell -> cell.removeAttribute("aria-selected"));
                }
            });
        }
    }

    public Registration addSelectionChangedListener(ComponentEventListener<BeanTableSelectionChangedEvent<T, BeanTable<T>>> listener) {
        return ComponentUtil.addListener((Component)this, BeanTableSelectionChangedEvent.class, listener);
    }

    public Registration addItemClickedListener(ComponentEventListener<ItemClickedEvent<T, BeanTable<T>>> listener) {
        return ComponentUtil.addListener((Component)this, ItemClickedEvent.class, listener);
    }

    public static enum FocusBehavior {
        NONE,
        BODY,
        BODY_AND_HEADER;

    }

    public class Column<R>
    implements Serializable {
        String header;
        ValueProvider<T, ?> valueProvider;
        ComponentProvider<T> componentProvider;
        private StringProvider<T> classNameProvider;
        private StringProvider<T> tooltipProvider;
        private Component headerComponent;
        private String key;
        private ColumnAlignment columnAlignment;
        private String width;
        private boolean rowHeader;
        private boolean visible = true;
        private MenuItem menuItem;

        public Column(String header, ValueProvider<T, ?> valueProvider) {
            this.header = header;
            this.valueProvider = valueProvider;
        }

        public Column() {
        }

        public Column<R> setHeader(String header) {
            this.header = header;
            BeanTable.this.updateHeader();
            return this;
        }

        public Column<R> setHeader(Component header) {
            this.headerComponent = header;
            BeanTable.this.updateHeader();
            return this;
        }

        public Component getHeader() {
            if (this.headerComponent != null) {
                return this.headerComponent;
            }
            if (this.header != null) {
                return new Text(this.header);
            }
            return null;
        }

        public Column<R> setTooltipProvider(StringProvider<T> tooltipProvider) {
            this.tooltipProvider = tooltipProvider;
            return this;
        }

        public StringProvider<T> getTooltipProvider() {
            return this.tooltipProvider;
        }

        public Column<R> setComponentProvider(ComponentProvider<T> componentProvider) {
            this.componentProvider = componentProvider;
            return this;
        }

        public ComponentProvider<T> getComponentProvider() {
            return this.componentProvider;
        }

        public ValueProvider<T, ?> getValueProvider() {
            return this.valueProvider;
        }

        public Column<R> setClassNameProvider(StringProvider<T> classNameProvider) {
            this.classNameProvider = classNameProvider;
            return this;
        }

        public StringProvider<T> getClassNameProvider() {
            return this.classNameProvider;
        }

        public Column<R> setAlignment(ColumnAlignment alignment) {
            this.columnAlignment = alignment;
            return this;
        }

        public ColumnAlignment getAlignment() {
            return this.columnAlignment;
        }

        public Column<R> setWidth(String width) {
            this.width = width;
            BeanTable.this.updateHeader();
            return this;
        }

        public String getWidth() {
            return this.width;
        }

        public Column<R> setKey(String key) {
            assert (BeanTable.this.columns.stream().noneMatch(col -> Objects.equals(col.getKey(), key))) : "The key must be unique";
            Objects.requireNonNull(key, "The key can't be null");
            this.key = key;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Column<R> setRowHeader(boolean rowHeader) {
            this.rowHeader = rowHeader;
            return this;
        }

        public boolean isRowHeader() {
            return this.rowHeader;
        }

        public Column<R> setVisible(boolean visible) {
            this.visible = visible;
            if (BeanTable.this.isAttached()) {
                BeanTable.this.updateColumnVisibility(this, !visible);
            }
            this.menuItem.setChecked(visible);
            return this;
        }

        void updateVisible(boolean visible) {
            this.visible = visible;
        }

        void setMenuItem(MenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }

    @FunctionalInterface
    public static interface ComponentProvider<T>
    extends ValueProvider<T, Component> {
        public Component apply(T var1);
    }

    public static class BeanTableI18n
    implements Serializable {
        private String lastPage;
        private String previousPage;
        private String nextPage;
        private String firstPage;
        private String menuButton;
        private String errorText;
        private String noDataText;
        private SerializableBiFunction<Integer, Integer, String> pageProvider;

        public String getLastPage() {
            return this.lastPage;
        }

        public void setLastPage(String lastPage) {
            this.lastPage = lastPage;
        }

        public String getPreviousPage() {
            return this.previousPage;
        }

        public void setPreviousPage(String previousPage) {
            this.previousPage = previousPage;
        }

        public String getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(String nextPage) {
            this.nextPage = nextPage;
        }

        public String getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(String firstPage) {
            this.firstPage = firstPage;
        }

        public SerializableBiFunction<Integer, Integer, String> getPageProvider() {
            return this.pageProvider;
        }

        public String getMenuButton() {
            return this.menuButton;
        }

        public void setMenuButton(String menuButton) {
            this.menuButton = menuButton;
        }

        public String getErrorText() {
            return this.errorText;
        }

        public void setErrorText(String errorText) {
            this.errorText = errorText;
        }

        public String getNoDataText() {
            return this.noDataText;
        }

        public void setNoDataText(String noDataText) {
            this.noDataText = noDataText;
        }

        public void setPageProvider(SerializableBiFunction<Integer, Integer, String> provider) {
            this.pageProvider = provider;
        }

        public static BeanTableI18n getDefault() {
            BeanTableI18n english = new BeanTableI18n();
            english.setFirstPage("First page");
            english.setNextPage("Next page");
            english.setLastPage("Last page");
            english.setPreviousPage("Previous page");
            english.setMenuButton("Column selector");
            english.setErrorText("Failed fetching data");
            english.setNoDataText("No data");
            english.setPageProvider((SerializableBiFunction<Integer, Integer, String>)(SerializableBiFunction & Serializable)(currentPage, lastPage) -> "Page " + currentPage + " of " + lastPage);
            return english;
        }
    }

    class RowItem<R>
    implements Serializable {
        private R item;
        private Element rowElement;

        public RowItem(String id, R item) {
            Object className;
            this.item = item;
            this.rowElement = new Element("tr");
            this.rowElement.setAttribute("role", "row");
            if (BeanTable.this.getClassNameProvider() != null && (className = BeanTable.this.getClassNameProvider().apply(item)) != null && !((String)className).isEmpty()) {
                this.rowElement.getClassList().add(className);
            }
            DomListenerRegistration clickReg = this.rowElement.addEventListener("click", (DomEventListener & Serializable)event -> {
                this.toggleSelection();
                BeanTable.this.fireEvent(new ItemClickedEvent<Object, BeanTable>(BeanTable.this, item, true));
            });
            clickReg.addEventData("event.detail");
            clickReg.setFilter("event.detail == 1");
            DomListenerRegistration keyReg = this.rowElement.addEventListener("keydown", (DomEventListener & Serializable)event -> {
                JsonNode eventData = event.getEventData();
                if (RowItem.parseKeyCode(eventData) == 32) {
                    this.toggleSelection();
                    BeanTable.this.fireEvent(new ItemClickedEvent<Object, BeanTable>(BeanTable.this, item, true));
                } else if (RowItem.parseKeyCode(eventData) == 33) {
                    if (BeanTable.this.previous != null) {
                        BeanTable.this.previous.click();
                    }
                } else if (RowItem.parseKeyCode(eventData) == 34 && BeanTable.this.next != null) {
                    BeanTable.this.next.click();
                }
            });
            keyReg.addEventData("event.keyCode");
            keyReg.addEventData("([32, 33, 34].includes(event.keyCode)) ? event.preventDefault() : undefined");
            keyReg.setFilter("[32, 33, 34].includes(event.keyCode)");
            if (BeanTable.this.selected.contains(item)) {
                this.rowElement.getThemeList().add((Object)"selected");
            }
            this.createCells();
            this.rowElement.addDetachListener((ElementDetachListener & Serializable)e -> {
                keyReg.remove();
                clickReg.remove();
            });
        }

        private static int parseKeyCode(JsonNode eventData) {
            return eventData.get("event.keyCode").asInt();
        }

        void toggleSelection() {
            if (BeanTable.this.selectionEnabled) {
                if (BeanTable.this.selected.contains(this.item)) {
                    BeanTable.this.selected.remove(this.item);
                    this.rowElement.getThemeList().remove((Object)"selected");
                    this.rowElement.setAttribute("aria-selected", "false");
                    this.rowElement.getChildren().forEach(cell -> cell.setAttribute("aria-selected", "false"));
                } else {
                    BeanTable.this.selected.add(this.item);
                    this.rowElement.getThemeList().add((Object)"selected");
                    this.rowElement.setAttribute("aria-selected", "true");
                    this.rowElement.getChildren().forEach(cell -> cell.setAttribute("aria-selected", "true"));
                }
                BeanTable.this.fireEvent(new BeanTableSelectionChangedEvent(BeanTable.this, BeanTable.this.selected, true));
            }
        }

        private void createCells() {
            Element indexCell = new Element("td");
            indexCell.getClassList().add((Object)"index");
            this.rowElement.appendChild(new Element[]{indexCell});
            BeanTable.this.columns.forEach(column -> {
                Object className;
                Element cell;
                if (column.getComponentProvider() == null && column.getValueProvider() == null) {
                    throw new IllegalStateException("Column is lacking eihercomponent or value provider.");
                }
                if (column.isRowHeader()) {
                    cell = new Element("th");
                    cell.setAttribute("role", "rowheader");
                    if (BeanTable.this.focusBehavior == FocusBehavior.BODY_AND_HEADER) {
                        cell.setAttribute("tabindex", "-1");
                    }
                } else {
                    cell = new Element("td");
                    cell.setAttribute("role", "cell");
                    if (BeanTable.this.focusBehavior != FocusBehavior.NONE) {
                        cell.setAttribute("tabindex", "-1");
                    }
                }
                if (BeanTable.this.selectionEnabled) {
                    cell.setAttribute("aria-selected", BeanTable.this.selected.contains(this.item) ? "true" : "false");
                }
                if (!column.isVisible()) {
                    cell.getStyle().set("display", "none");
                }
                if (column.getAlignment() != null) {
                    cell.getStyle().set("text-align", column.getAlignment().toString().toLowerCase());
                } else {
                    cell.getStyle().remove("text-align");
                }
                Component component = null;
                Object value = null;
                if (column.getComponentProvider() != null) {
                    component = column.getComponentProvider().apply(this.item);
                } else {
                    value = column.getValueProvider().apply(this.item);
                }
                if (column.getClassNameProvider() != null && (className = column.getClassNameProvider().apply(this.item)) != null && !((String)className).isEmpty()) {
                    cell.getClassList().add(className);
                }
                if (value == null) {
                    value = "";
                }
                if (component != null) {
                    cell.appendChild(new Element[]{component.getElement()});
                } else if (column.tooltipProvider != null) {
                    Object tooltipText = column.getTooltipProvider().apply(this.item);
                    Html span = this.wrapWithTooltip(value, (String)tooltipText);
                    cell.appendChild(new Element[]{span.getElement()});
                } else if (BeanTable.this.htmlAllowed) {
                    Html span = new Html("<span>" + value.toString() + "</span>");
                    cell.appendChild(new Element[]{span.getElement()});
                } else {
                    cell.setText(value.toString());
                }
                this.rowElement.appendChild(new Element[]{cell});
            });
        }

        private Html wrapWithTooltip(Object value, String tooltipText) {
            String key = BeanTable.this.randomId("tooltip", 8);
            String content = String.format("<span id='%s'>%s<vaadin-tooltip text='%s' for='%s'></vaadin-tooltip></span>", key, value.toString(), tooltipText, key);
            return new Html(content);
        }

        public R getItem() {
            return this.item;
        }

        public Element getRowElement() {
            return this.rowElement;
        }

        public void setItem(R item) {
            this.item = item;
            this.rowElement.removeAllChildren();
            this.createCells();
        }
    }

    @FunctionalInterface
    public static interface StringProvider<T>
    extends ValueProvider<T, String> {
        public String apply(T var1);
    }

    public static enum ColumnSelectMenu {
        NONE,
        CONTEXT,
        BUTTON;

    }

    public static enum ColumnAlignment {
        CENTER,
        LEFT,
        RIGHT;

    }
}

