/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.table;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Element;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.vaadin.stefan.table.TableBody;
import org.vaadin.stefan.table.TableCaption;
import org.vaadin.stefan.table.TableColumnGroup;
import org.vaadin.stefan.table.TableFoot;
import org.vaadin.stefan.table.TableHead;
import org.vaadin.stefan.table.TableRow;
import org.vaadin.stefan.table.TableRowContainer;

@Tag(value="table")
public class Table
extends HtmlComponent
implements TableRowContainer {
    private TableCaption caption;
    private TableColumnGroup columnGroup;
    private TableHead head;
    private final List<TableBody> bodies = new LinkedList<TableBody>();
    private TableFoot foot;

    public TableCaption getCaption() {
        if (this.caption == null) {
            this.caption = this.insertIndexedChild(new TableCaption(), new Component[0]);
        }
        return this.caption;
    }

    public TableColumnGroup getColumnGroup() {
        if (this.columnGroup == null) {
            this.columnGroup = this.insertIndexedChild(new TableColumnGroup(), new Component[]{this.caption});
        }
        return this.columnGroup;
    }

    public TableHead getHead() {
        if (this.head == null) {
            this.head = this.insertIndexedChild(new TableHead(), new Component[]{this.caption, this.columnGroup});
        }
        return this.head;
    }

    public void removeHead() {
        if (this.head != null) {
            this.getElement().removeChild(new Element[]{this.head.getElement()});
        }
    }

    public void removeBody() {
        if (!this.bodies.isEmpty()) {
            this.removeBody(0);
        }
    }

    public void removeBody(int index) {
        TableBody removed = this.bodies.remove(index);
        this.getElement().removeChild(new Element[]{removed.getElement()});
    }

    public void removeBodies() {
        this.bodies.forEach(body -> {
            Element cfr_ignored_0 = (Element)this.getElement().removeChild(new Element[]{body.getElement()});
        });
        this.bodies.clear();
    }

    public void removeFoot() {
        if (this.foot != null) {
            this.getElement().removeChild(new Element[]{this.foot.getElement()});
        }
    }

    public void removeCaption() {
        if (this.caption != null) {
            this.getElement().removeChild(new Element[]{this.caption.getElement()});
        }
    }

    public void removeColumnGroup() {
        if (this.columnGroup != null) {
            this.getElement().removeChild(new Element[]{this.columnGroup.getElement()});
        }
    }

    public TableBody getBody() {
        if (this.bodies.isEmpty()) {
            return this.addBody();
        }
        return this.bodies.get(0);
    }

    public TableBody addBody() {
        TableBody body = new TableBody();
        this.addBodies(body);
        return body;
    }

    public void addBodies(TableBody ... tableBodies) {
        boolean noBodiesBefore = this.bodies.isEmpty();
        for (TableBody body : tableBodies) {
            this.insertIndexedChild(body, this.calculateInsertIndexedChildPredecessors());
            this.bodies.add(body);
        }
        if (noBodiesBefore && !this.bodies.isEmpty()) {
            this.transferTableRowsToBody(this.bodies.get(0));
        }
    }

    private void transferTableRowsToBody(TableBody body) {
        body.addRows((TableRow[])this.streamRows().toArray(TableRow[]::new));
    }

    public TableBody getBody(int index) {
        if (this.bodies.isEmpty() && index == 0) {
            return this.getBody();
        }
        return this.bodies.get(index);
    }

    public List<TableBody> getBodies() {
        return new ArrayList<TableBody>(this.bodies);
    }

    public TableFoot getFoot() {
        if (this.foot == null) {
            Component[] predecessors = this.calculateInsertIndexedChildPredecessors();
            this.foot = this.insertIndexedChild(new TableFoot(), predecessors);
        }
        return this.foot;
    }

    private Component[] calculateInsertIndexedChildPredecessors() {
        return (Component[])Stream.concat(Stream.of(new Component[]{this.caption, this.columnGroup, this.head}), this.bodies.stream()).toArray(Component[]::new);
    }

    private int calculateIndex(Component ... predecessors) {
        int index = 0;
        for (Component predecessor : predecessors) {
            if (predecessor == null) continue;
            ++index;
        }
        return index;
    }

    private <T extends Component> T insertIndexedChild(T childToAdd, Component ... predecessors) {
        int index = this.calculateIndex(predecessors);
        this.getElement().insertChild(index, new Element[]{childToAdd.getElement()});
        return childToAdd;
    }

    @Override
    public void addRows(TableRow ... rows) {
        if (this.bodies.isEmpty()) {
            TableRowContainer.super.addRows(rows);
        } else {
            this.getBody().addRows(rows);
        }
    }

    @Override
    public void insertRows(int index, TableRow ... rows) {
        if (this.bodies.isEmpty()) {
            TableRowContainer.super.insertRows(index, rows);
        } else {
            this.getBody().insertRows(index, rows);
        }
    }

    @Override
    public void replaceRow(int index, TableRow row) {
        if (this.bodies.isEmpty()) {
            TableRowContainer.super.replaceRow(index, row);
        } else {
            this.getBody().replaceRow(index, row);
        }
    }

    @Override
    public void removeRows(TableRow ... rows) {
        if (this.bodies.isEmpty()) {
            TableRowContainer.super.removeRows(rows);
        } else {
            this.getBody().removeRows(rows);
        }
    }

    @Override
    public Stream<TableRow> streamRows() {
        if (this.bodies.isEmpty()) {
            return TableRowContainer.super.streamRows();
        }
        return this.getBody().streamRows();
    }

    @Override
    public TableRow addRow() {
        TableRow tableRow = new TableRow();
        this.addRows(tableRow);
        return tableRow;
    }

    @Override
    public TableRow[] addRows(int rows) {
        TableRow[] array = new TableRow[rows];
        for (int i = 0; i < rows; ++i) {
            array[i] = new TableRow();
        }
        this.addRows(array);
        return array;
    }

    @Override
    public TableRow insertRow(int index) {
        TableRow row = new TableRow();
        this.insertRows(index, row);
        return row;
    }

    @Override
    public void setRow(int index, TableRow row) {
        this.replaceRow(index, row);
    }

    @Override
    public void removeAllRows() {
        if (this.bodies.isEmpty()) {
            TableRowContainer.super.removeAllRows();
        } else {
            this.getBody().removeAllRows();
        }
    }

    @Override
    public void removeRow(int index) {
        this.getRow(index).ifPresent(xva$0 -> this.removeRows((TableRow)((Object)xva$0)));
    }
}

