/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.table;

import com.vaadin.flow.component.HasElement;

public interface HasColSpan
extends HasElement {
    public static final String ATTRIBUTE_COLSPAN = "colspan";

    default public void setColSpan(int colSpan) {
        if (colSpan < 0) {
            throw new IllegalArgumentException("Colspan must be a positive number");
        }
        this.getElement().setAttribute(ATTRIBUTE_COLSPAN, String.valueOf(colSpan));
    }

    default public int getColSpan() {
        String colspan = this.getElement().getAttribute(ATTRIBUTE_COLSPAN);
        if (colspan == null) {
            colspan = "1";
        }
        return Integer.parseInt(colspan);
    }

    default public void resetColSpan() {
        this.getElement().removeAttribute(ATTRIBUTE_COLSPAN);
    }
}

