/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import org.vaadin.stefan.fullcalendar.model.HeaderFooterItem;
import org.vaadin.stefan.fullcalendar.model.HeaderFooterPart;
import org.vaadin.stefan.fullcalendar.model.HeaderFooterPartPosition;
import tools.jackson.databind.node.ObjectNode;

public class AbstractHeaderFooter {
    private final Map<HeaderFooterPartPosition, HeaderFooterPart> parts;

    protected AbstractHeaderFooter() {
        this.parts = new HashMap<HeaderFooterPartPosition, HeaderFooterPart>();
    }

    protected AbstractHeaderFooter(Collection<HeaderFooterPart> parts) {
        this.parts = Objects.requireNonNull(parts).stream().collect(Collectors.toMap(HeaderFooterPart::getPosition, Function.identity()));
    }

    public Set<HeaderFooterPart> getParts() {
        return new HashSet<HeaderFooterPart>(this.parts.values());
    }

    public HeaderFooterPart getStart() {
        return this.parts.computeIfAbsent(HeaderFooterPartPosition.START, HeaderFooterPart::new);
    }

    public HeaderFooterPart getCenter() {
        return this.parts.computeIfAbsent(HeaderFooterPartPosition.CENTER, HeaderFooterPart::new);
    }

    public HeaderFooterPart getEnd() {
        return this.parts.computeIfAbsent(HeaderFooterPartPosition.END, HeaderFooterPart::new);
    }

    public ObjectNode toJson() {
        ObjectNode jsonObject = JsonFactory.createObject();
        for (HeaderFooterPart position : this.parts.values()) {
            jsonObject.put(position.getPosition().getCode(), position.getItems().stream().map(HeaderFooterItem::getCode).collect(Collectors.joining(",")));
        }
        return jsonObject;
    }

    public void addPart(HeaderFooterPart part) {
        this.parts.put(part.getPosition(), part);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHeaderFooter)) {
            return false;
        }
        AbstractHeaderFooter other = (AbstractHeaderFooter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<HeaderFooterPart> this$parts = this.getParts();
        Set<HeaderFooterPart> other$parts = other.getParts();
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractHeaderFooter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<HeaderFooterPart> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractHeaderFooter(parts=" + String.valueOf(this.getParts()) + ")";
    }
}

