/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.dataprovider;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.Timezone;

public class EntryQuery {
    private LocalDateTime start;
    private LocalDateTime end;
    @NonNull
    private AllDay allDay = AllDay.BOTH;

    public EntryQuery(LocalDateTime start, LocalDateTime end) {
        this.start = start;
        this.end = end;
    }

    public EntryQuery(Instant start, Instant end) {
        this(start, end, AllDay.BOTH);
    }

    public EntryQuery(Instant start, Instant end, AllDay allDay) {
        this(start != null ? LocalDateTime.ofInstant(start, Timezone.ZONE_ID_UTC) : null, end != null ? LocalDateTime.ofInstant(end, Timezone.ZONE_ID_UTC) : null, allDay);
    }

    public <T extends Entry> Stream<T> applyFilter(Stream<T> stream) {
        if (this.start == null && this.end == null && this.allDay == AllDay.BOTH) {
            return stream;
        }
        if (this.start != null) {
            stream = stream.filter(e -> {
                if (e.isRecurring()) {
                    LocalDateTime recurringEnd = e.getRecurringEnd();
                    return recurringEnd == null || recurringEnd.isAfter(this.start);
                }
                return e.getEnd() != null && e.getEnd().isAfter(this.start);
            });
        }
        if (this.end != null) {
            stream = stream.filter(e -> {
                if (e.isRecurring()) {
                    LocalDateTime recurringStart = e.getRecurringStart();
                    return recurringStart == null || recurringStart.isBefore(this.end);
                }
                return e.getStart() != null && e.getStart().isBefore(this.end);
            });
        }
        if (this.allDay != AllDay.BOTH) {
            Predicate<Entry> allDayFilter = Entry::isAllDay;
            if (this.allDay == AllDay.TIMED_ONLY) {
                allDayFilter = allDayFilter.negate();
            }
            stream = stream.filter(allDayFilter);
        }
        return stream;
    }

    @Generated
    public static EntryQueryBuilder builder() {
        return new EntryQueryBuilder();
    }

    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }

    @Generated
    public LocalDateTime getEnd() {
        return this.end;
    }

    @NonNull
    @Generated
    public AllDay getAllDay() {
        return this.allDay;
    }

    @Generated
    public EntryQuery(LocalDateTime start, LocalDateTime end, @NonNull AllDay allDay) {
        if (allDay == null) {
            throw new NullPointerException("allDay is marked non-null but is null");
        }
        this.start = start;
        this.end = end;
        this.allDay = allDay;
    }

    @Generated
    public EntryQuery() {
    }

    public static enum AllDay {
        BOTH,
        ALL_DAY_ONLY,
        TIMED_ONLY;

    }

    @Generated
    public static class EntryQueryBuilder {
        @Generated
        private LocalDateTime start;
        @Generated
        private LocalDateTime end;
        @Generated
        private AllDay allDay;

        @Generated
        EntryQueryBuilder() {
        }

        @Generated
        public EntryQueryBuilder start(LocalDateTime start) {
            this.start = start;
            return this;
        }

        @Generated
        public EntryQueryBuilder end(LocalDateTime end) {
            this.end = end;
            return this;
        }

        @Generated
        public EntryQueryBuilder allDay(@NonNull AllDay allDay) {
            if (allDay == null) {
                throw new NullPointerException("allDay is marked non-null but is null");
            }
            this.allDay = allDay;
            return this;
        }

        @Generated
        public EntryQuery build() {
            return new EntryQuery(this.start, this.end, this.allDay);
        }

        @Generated
        public String toString() {
            return "EntryQuery.EntryQueryBuilder(start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ", allDay=" + String.valueOf((Object)this.allDay) + ")";
        }
    }
}

