/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.dataprovider;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.dataprovider.CallbackEntryProvider;
import org.vaadin.stefan.fullcalendar.dataprovider.EntriesChangeEvent;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryQuery;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryRefreshEvent;
import org.vaadin.stefan.fullcalendar.dataprovider.InMemoryEntryProvider;

public interface EntryProvider<T extends Entry> {
    public static <T extends Entry> CallbackEntryProvider<T> fromCallbacks(SerializableFunction<EntryQuery, Stream<T>> fetchItems, SerializableFunction<String, T> fetchSingleItem) {
        return new CallbackEntryProvider<T>(fetchItems, fetchSingleItem);
    }

    public static <T extends Entry> InMemoryEntryProvider<T> emptyInMemory() {
        return InMemoryEntryProvider.from((Entry[])new Entry[0]);
    }

    @SafeVarargs
    public static <T extends Entry> InMemoryEntryProvider<T> inMemoryFrom(T ... entries) {
        return InMemoryEntryProvider.from(entries);
    }

    public static <T extends Entry> InMemoryEntryProvider<T> inMemoryFrom(Iterable<T> entries) {
        return InMemoryEntryProvider.from(entries);
    }

    default public Stream<T> fetchAll() {
        return this.fetch(new EntryQuery());
    }

    default public Stream<T> fetch(LocalDateTime start, LocalDateTime end) {
        return this.fetch(new EntryQuery(start, end));
    }

    default public Stream<T> fetch(Instant start, Instant end) {
        return this.fetch(new EntryQuery(start, end));
    }

    public Stream<T> fetch(@NonNull EntryQuery var1);

    public Optional<T> fetchById(@NonNull String var1);

    public void refreshItem(T var1);

    public void refreshAll();

    public void setCalendar(FullCalendar var1);

    default public boolean isInMemory() {
        return this instanceof InMemoryEntryProvider;
    }

    public Registration addEntriesChangeListener(EntriesChangeEvent.EntriesChangeListener<T> var1);

    public Registration addEntryRefreshListener(EntryRefreshEvent.EntryRefreshListener<T> var1);

    default public InMemoryEntryProvider<T> asInMemory() {
        return (InMemoryEntryProvider)this;
    }
}

