/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.dataprovider;

import com.vaadin.flow.function.SerializableFunction;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.dataprovider.AbstractEntryProvider;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryQuery;

public class CallbackEntryProvider<T extends Entry>
extends AbstractEntryProvider<T> {
    private final SerializableFunction<EntryQuery, Stream<T>> fetchItems;
    private final SerializableFunction<String, T> fetchSingleItem;

    public CallbackEntryProvider(SerializableFunction<EntryQuery, Stream<T>> fetchItems, SerializableFunction<String, T> fetchSingleItem) {
        this.fetchItems = Objects.requireNonNull(fetchItems);
        this.fetchSingleItem = Objects.requireNonNull(fetchSingleItem);
    }

    @Override
    public Stream<T> fetch(@NonNull EntryQuery query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return (Stream)this.fetchItems.apply((Object)query);
    }

    @Override
    public Optional<T> fetchById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Optional.ofNullable((Entry)this.fetchSingleItem.apply((Object)id));
    }
}

