/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar.dataprovider;

import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.dataprovider.EntriesChangeEvent;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryProvider;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryRefreshEvent;

public abstract class AbstractEntryProvider<T extends Entry>
implements EntryProvider<T> {
    private final Map<Class<?>, List<SerializableConsumer<?>>> listeners = new HashMap();
    private FullCalendar calendar;

    @Override
    public void refreshAll() {
        this.fireEvent(new EntriesChangeEvent(this));
    }

    @Override
    public void refreshItem(T item) {
        this.fireEvent(new EntryRefreshEvent<T>(this, item));
    }

    protected <E> Registration addListener(Class<E> eventType, SerializableConsumer<E> method) {
        List list = this.listeners.computeIfAbsent(eventType, key -> new ArrayList());
        return Registration.addAndRemove((Collection)list, method);
    }

    @Override
    public Registration addEntriesChangeListener(EntriesChangeEvent.EntriesChangeListener<T> listener) {
        return this.addListener(EntriesChangeEvent.class, listener::onDataChange);
    }

    @Override
    public Registration addEntryRefreshListener(EntryRefreshEvent.EntryRefreshListener<T> listener) {
        return this.addListener(EntryRefreshEvent.class, listener::onDataRefresh);
    }

    protected void fireEvent(EventObject event) {
        this.listeners.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(event.getClass())).forEach(entry -> {
            for (Consumer consumer : (List)entry.getValue()) {
                consumer.accept(event);
            }
        });
    }

    @Override
    public void setCalendar(FullCalendar calendar) {
        if (this.calendar != null && calendar != null && this.calendar != calendar) {
            throw new UnsupportedOperationException("Calendar must be set only once. Please create a new instance instead.");
        }
        this.calendar = calendar;
    }

    @Generated
    public FullCalendar getCalendar() {
        return this.calendar;
    }
}

