/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.CalendarView;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import tools.jackson.databind.node.ObjectNode;

public abstract class ViewRenderEvent
extends ComponentEvent<FullCalendar> {
    private final String viewName;
    private final LocalDate intervalStart;
    private final LocalDate intervalEnd;
    private final LocalDate start;
    private final LocalDate end;
    private final CalendarView calendarView;

    public ViewRenderEvent(FullCalendar source, boolean fromClient, ObjectNode eventData) {
        super((Component)source, fromClient);
        this.viewName = eventData.get("name").asString();
        this.calendarView = source.lookupViewByClientSideValue(this.viewName).orElse(null);
        this.intervalStart = JsonUtils.parseClientSideDate(eventData.get("intervalStart").asString());
        this.intervalEnd = JsonUtils.parseClientSideDate(eventData.get("intervalEnd").asString());
        this.start = JsonUtils.parseClientSideDate(eventData.get("start").asString());
        this.end = JsonUtils.parseClientSideDate(eventData.get("end").asString());
    }

    @Deprecated(forRemoval=true)
    public String getName() {
        return this.viewName;
    }

    public Optional<CalendarView> getCalendarView() {
        return Optional.ofNullable(this.calendarView);
    }

    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Generated
    public LocalDate getIntervalStart() {
        return this.intervalStart;
    }

    @Generated
    public LocalDate getIntervalEnd() {
        return this.intervalEnd;
    }

    @Generated
    public LocalDate getStart() {
        return this.start;
    }

    @Generated
    public LocalDate getEnd() {
        return this.end;
    }

    @Generated
    public String toString() {
        return "ViewRenderEvent(viewName=" + this.getViewName() + ", intervalStart=" + String.valueOf(this.getIntervalStart()) + ", intervalEnd=" + String.valueOf(this.getIntervalEnd()) + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", calendarView=" + String.valueOf(this.getCalendarView()) + ")";
    }
}

