/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.JsonUtils;
import org.vaadin.stefan.fullcalendar.Timezone;

@DomEvent(value="select")
public class TimeslotsSelectedEvent
extends ComponentEvent<FullCalendar> {
    private final boolean allDay;
    private final LocalDateTime start;
    private final LocalDateTime end;

    public TimeslotsSelectedEvent(FullCalendar source, boolean fromClient, @EventData(value="event.detail.start") String start, @EventData(value="event.detail.end") String end, @EventData(value="event.detail.allDay") boolean allDay) {
        super((Component)source, fromClient);
        Timezone timezone = source.getTimezone();
        this.allDay = allDay;
        this.start = JsonUtils.parseClientSideDateTime(start);
        this.end = JsonUtils.parseClientSideDateTime(end);
    }

    public Instant getStartAsInstant() {
        return Timezone.UTC.convertToInstant(this.start);
    }

    public Instant getEndAsInstant() {
        return Timezone.UTC.convertToInstant(this.end);
    }

    public LocalDateTime getStartWithOffset() {
        return ((FullCalendar)this.getSource()).getTimezone().applyTimezoneOffset(this.start);
    }

    public LocalDateTime getEndWithOffset() {
        return ((FullCalendar)this.getSource()).getTimezone().applyTimezoneOffset(this.end);
    }

    public LocalDate getStartDate() {
        return this.start.toLocalDate();
    }

    public LocalDate getEndDate() {
        return this.end.toLocalDate();
    }

    @Generated
    public boolean isAllDay() {
        return this.allDay;
    }

    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }

    @Generated
    public LocalDateTime getEnd() {
        return this.end;
    }

    @Generated
    public String toString() {
        return "TimeslotsSelectedEvent(allDay=" + this.isAllDay() + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }
}

