/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.time.Duration;
import java.time.LocalTime;
import java.util.Objects;
import lombok.Generated;

public final class RecurringTime {
    private final int hour;
    private final int minute;

    private RecurringTime(int hour, int minute) {
        if (hour < 0) {
            throw new IllegalArgumentException("Hours must not be negative");
        }
        if (minute < 0) {
            throw new IllegalArgumentException("Minutes must not be negative");
        }
        this.hour = hour + minute / 60;
        this.minute = minute % 60;
    }

    public static RecurringTime of(int hours, int minutes) {
        return new RecurringTime(hours, minutes);
    }

    public static RecurringTime of(int hours) {
        return new RecurringTime(hours, 0);
    }

    public static RecurringTime of(LocalTime time) {
        return RecurringTime.of(time.getHour(), time.getMinute());
    }

    public static RecurringTime of(String string) {
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException("String must not be blank");
        }
        String[] split = string.split(":");
        int hours = Integer.parseInt(split[0].trim());
        if (split.length == 1) {
            return RecurringTime.of(hours);
        }
        return RecurringTime.of(hours, Integer.parseInt(split[1].trim()));
    }

    public LocalTime toLocalTime() {
        return LocalTime.of(this.hour, this.minute);
    }

    public Duration toDuration() {
        return Duration.ofHours(this.hour).plusMinutes(this.minute);
    }

    public String toFormattedString() {
        return (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute;
    }

    public RecurringTime plusHours(int hours) {
        int totalMinutes = this.toTotalMinutes();
        int[] times = this.fromTotalMinutes(totalMinutes += hours * 60);
        return new RecurringTime(times[0], times[1]);
    }

    public RecurringTime plusMinutes(int minutes) {
        int totalMinutes = this.toTotalMinutes();
        int[] times = this.fromTotalMinutes(totalMinutes += minutes);
        return new RecurringTime(times[0], times[1]);
    }

    public boolean isValidLocalTime() {
        return this.hour < 24;
    }

    public boolean equals(LocalTime localTime) {
        return this.equals(RecurringTime.of(localTime));
    }

    public boolean isAfter(RecurringTime recurringTime) {
        return this.toTotalMinutes() > recurringTime.toTotalMinutes();
    }

    public boolean isBefore(RecurringTime recurringTime) {
        return this.toTotalMinutes() < recurringTime.toTotalMinutes();
    }

    public boolean isAfter(LocalTime recurringTime) {
        return this.isAfter(RecurringTime.of(recurringTime));
    }

    public boolean isBefore(LocalTime recurringTime) {
        return this.isBefore(RecurringTime.of(recurringTime));
    }

    private int toTotalMinutes() {
        return this.hour * 60 + this.minute;
    }

    private int[] fromTotalMinutes(int totalMinutes) {
        return new int[]{totalMinutes / 60, totalMinutes % 60};
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringTime that = (RecurringTime)o;
        return this.hour == that.hour && this.minute == that.minute;
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.minute);
    }

    @Generated
    public int getHour() {
        return this.hour;
    }

    @Generated
    public int getMinute() {
        return this.minute;
    }
}

