/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;

public abstract class MultipleEntriesEvent
extends ComponentEvent<FullCalendar> {
    private final Set<Entry> entries;

    public MultipleEntriesEvent(FullCalendar source, boolean fromClient, Collection<String> entryIds) {
        super((Component)source, fromClient);
        if (entryIds == null || entryIds.isEmpty()) {
            throw new IllegalArgumentException("IDs parameter must not be null nor empty");
        }
        this.entries = entryIds.stream().map(id -> {
            Optional<Entry> entry = source.getCachedEntryFromFetch((String)id);
            if (!entry.isPresent()) {
                throw new IllegalArgumentException("No item found with id " + id);
            }
            return entry;
        }).map(Optional::get).collect(Collectors.toSet());
    }

    public Collection<Entry> getEntries() {
        return this.entries;
    }

    @Generated
    public String toString() {
        return "MultipleEntriesEvent(entries=" + String.valueOf(this.getEntries()) + ")";
    }
}

