/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.MultipleEntriesEvent;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public abstract class MultipleEntriesDataEvent
extends MultipleEntriesEvent {
    private final Map<Entry, ObjectNode> jsonObjects;

    public MultipleEntriesDataEvent(FullCalendar source, boolean fromClient, ArrayNode jsonObjects) {
        super(source, fromClient, MultipleEntriesDataEvent.toCollection(Objects.requireNonNull(jsonObjects)));
        this.jsonObjects = this.toMap(jsonObjects);
    }

    private Map<Entry, ObjectNode> toMap(ArrayNode jsonObjects) {
        Map entries = this.getEntries().stream().collect(Collectors.toMap(Entry::getId, Function.identity()));
        HashMap<Entry, ObjectNode> map = new HashMap<Entry, ObjectNode>(jsonObjects.size());
        for (JsonNode node : jsonObjects) {
            if (!(node instanceof ObjectNode)) continue;
            ObjectNode jsonObject = (ObjectNode)node;
            Entry entry = (Entry)entries.get(jsonObject.get("id").asString());
            map.put(entry, jsonObject);
        }
        return map;
    }

    private static Collection<String> toCollection(ArrayNode jsonObjects) {
        HashSet<String> ids = new HashSet<String>(jsonObjects.size());
        for (JsonNode node : jsonObjects) {
            if (!(node instanceof ObjectNode)) {
                throw new IllegalArgumentException("Only json objects are allowed as direct children");
            }
            ObjectNode objectNode = (ObjectNode)node;
            String id = objectNode.get("id").asString();
            if (id == null) {
                throw new IllegalArgumentException("Only valid entry objects are allowed (must have an id)");
            }
            ids.add(id);
        }
        return ids;
    }

    @Generated
    public Map<Entry, ObjectNode> getJsonObjects() {
        return this.jsonObjects;
    }

    @Override
    @Generated
    public String toString() {
        return "MultipleEntriesDataEvent(super=" + super.toString() + ", jsonObjects=" + String.valueOf(this.getJsonObjects()) + ")";
    }
}

