/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.vaadin.stefan.fullcalendar.ClientSideValue;
import org.vaadin.stefan.fullcalendar.JsonFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static JsonNode toJsonNode(Object value) {
        return JsonUtils.toJsonNode(value, null);
    }

    public static JsonNode toJsonNode(Object value, SerializableFunction<Object, JsonNode> customConverter) {
        if (value instanceof JsonNode) {
            JsonNode node = (JsonNode)value;
            return node;
        }
        if (value instanceof ClientSideValue) {
            ClientSideValue clientSideValue = (ClientSideValue)value;
            value = clientSideValue.getClientSideValue();
        }
        if (value == null) {
            return JsonFactory.createNull();
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return JsonFactory.create(b);
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return JsonFactory.create(i);
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return JsonFactory.create(l);
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return JsonFactory.create(n.doubleValue());
        }
        if (value instanceof Iterator) {
            Iterator iterator = (Iterator)value;
            ArrayNode array = JsonFactory.createArray();
            while (iterator.hasNext()) {
                array.add(JsonUtils.toJsonNode(iterator.next(), customConverter));
            }
            return array;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ObjectNode jsonObject = JsonFactory.createObject();
            for (Map.Entry prop : map.entrySet()) {
                jsonObject.set((String)prop.getKey(), JsonUtils.toJsonNode(prop.getValue(), customConverter));
            }
            return jsonObject;
        }
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            return JsonUtils.toJsonNode(Arrays.asList(objects).iterator(), customConverter);
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            return JsonUtils.toJsonNode(iterable.iterator(), customConverter);
        }
        if (value instanceof Stream) {
            Stream stream = (Stream)value;
            return JsonUtils.toJsonNode(stream.iterator(), customConverter);
        }
        return customConverter != null ? (JsonNode)customConverter.apply(value) : JsonFactory.create(String.valueOf(value));
    }

    public static boolean isCollectable(Object value) {
        return value instanceof Iterator || value instanceof Map || value instanceof Object[] || value instanceof Iterable || value instanceof Stream;
    }

    public static String formatClientSideTimeString(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalTime.class, LocalDateTime.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                LocalTime ignored = (LocalTime)object;
                yield String.valueOf(value) + "Z";
            }
            case 1 -> {
                LocalDateTime localDateTime = (LocalDateTime)object;
                yield JsonUtils.formatClientSideTimeString(localDateTime.toLocalTime());
            }
            default -> throw new IllegalArgumentException("Unsupported class: " + String.valueOf(value.getClass()));
        };
    }

    public static String formatClientSideDateString(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalDate.class, LocalDateTime.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                LocalDate ignored = (LocalDate)object;
                yield value.toString();
            }
            case 1 -> {
                LocalDateTime localDateTime = (LocalDateTime)object;
                yield JsonUtils.formatClientSideDateString(localDateTime.toLocalDate());
            }
            default -> throw new IllegalArgumentException("Unsupported class: " + String.valueOf(value.getClass()));
        };
    }

    public static String formatClientSideDateTimeString(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalDate.class, LocalDateTime.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                LocalDate localDate = (LocalDate)object;
                yield JsonUtils.formatClientSideDateTimeString(localDate.atStartOfDay());
            }
            case 1 -> {
                LocalDateTime ignored = (LocalDateTime)object;
                yield String.valueOf(value) + "Z";
            }
            default -> throw new IllegalArgumentException("Unsupported class: " + String.valueOf(value.getClass()));
        };
    }

    public static LocalDate parseClientSideDate(String dateString) {
        Objects.requireNonNull(dateString, "dateString");
        if (dateString.length() > 10) {
            dateString = dateString.substring(0, 10);
        }
        return LocalDate.parse(dateString);
    }

    public static LocalDateTime parseClientSideDateTime(String dateTimeString) {
        if (dateTimeString.length() <= 10) {
            return JsonUtils.parseClientSideDate(dateTimeString).atStartOfDay();
        }
        if (dateTimeString.endsWith("Z")) {
            return LocalDateTime.parse(dateTimeString.substring(0, dateTimeString.length() - 1));
        }
        throw new IllegalArgumentException("Parsing non utc date time string: " + dateTimeString);
    }

    public static LocalTime parseClientSideTime(String timeString) {
        Objects.requireNonNull(timeString, "timeString");
        if (!timeString.endsWith("Z")) {
            throw new IllegalArgumentException("Parsing non utc time string: " + timeString);
        }
        return LocalTime.parse(timeString.substring(0, timeString.length() - 1));
    }

    public static <T> T ofJsonNode(JsonNode jsonValue) {
        return JsonUtils.ofJsonNode(jsonValue, (SerializableFunction<JsonNode, Object>)(SerializableFunction & Serializable)o -> JsonUtils.convertObjectToMap(JsonUtils.checkForObjectOrThrow(o), ArrayList.class), null, ArrayList.class);
    }

    public static <T> T ofJsonNode(JsonNode jsonValue, Class<? extends Collection> convertArrayToType) {
        return JsonUtils.ofJsonNode(jsonValue, (SerializableFunction<JsonNode, Object>)(SerializableFunction & Serializable)o -> JsonUtils.convertObjectToMap(JsonUtils.checkForObjectOrThrow(o), convertArrayToType), null, convertArrayToType);
    }

    public static <T> T ofJsonNode(JsonNode jsonValue, SerializableFunction<JsonNode, Object> toObjectCallback, Collection<JsonNodeType> toObjectJsonTypes, Class<? extends Collection> convertArrayToType) {
        if (jsonValue == null) {
            return null;
        }
        JsonNodeType type = jsonValue.getNodeType();
        if (jsonValue.isObject()) {
            return (T)toObjectCallback.apply((Object)jsonValue);
        }
        if (jsonValue.isArray() && jsonValue instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)jsonValue;
            try {
                Collection collection = convertArrayToType.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (JsonNode item : array) {
                    collection.add(JsonUtils.ofJsonNode(item, toObjectCallback, toObjectJsonTypes, convertArrayToType));
                }
                return (T)collection;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (toObjectJsonTypes != null && toObjectJsonTypes.contains(type)) {
            return (T)toObjectCallback.apply((Object)jsonValue);
        }
        return (T)(switch (type) {
            case JsonNodeType.STRING -> jsonValue.asString();
            case JsonNodeType.NUMBER -> jsonValue.asDouble();
            case JsonNodeType.BOOLEAN -> jsonValue.asBoolean();
            case JsonNodeType.NULL -> null;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(type));
        });
    }

    public static Map<String, Object> convertObjectToMap(ObjectNode object, Class<? extends Collection> convertArrayToType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String property : object.propertyNames()) {
            map.put(property, JsonUtils.ofJsonNode(object.get(property), convertArrayToType));
        }
        return map;
    }

    private static ObjectNode checkForObjectOrThrow(JsonNode value) {
        if (!(value instanceof ObjectNode)) {
            throw new IllegalArgumentException("Only ObjectNode) is supported. Given type is " + String.valueOf(value != null ? value.getNodeType() : " null"));
        }
        ObjectNode objectNode = (ObjectNode)value;
        return objectNode;
    }
}

