/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.stefan.fullcalendar.BrowserTimezoneObtainedEvent;
import org.vaadin.stefan.fullcalendar.CustomCalendarView;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.dataprovider.EntryProvider;
import org.vaadin.stefan.fullcalendar.dataprovider.InMemoryEntryProvider;
import tools.jackson.databind.node.ObjectNode;

public class FullCalendarBuilder {
    private final boolean autoBrowserTimezone;
    private final boolean autoBrowserLocale;
    private final boolean scheduler;
    private final int entryLimit;
    private final String schedulerLicenseKey;
    private final ObjectNode initialOptions;
    private final EntryProvider<Entry> entryProvider;
    private final Class<? extends FullCalendar> customType;
    private final Collection<Entry> initialEntries;
    private final String entryContent;
    private final CustomCalendarView[] customCalendarViews;

    private FullCalendarBuilder(boolean scheduler, int entryLimit, boolean autoBrowserTimezone, boolean autoBrowserLocale, String schedulerLicenseKey, ObjectNode initialOptions, EntryProvider<? extends Entry> entryProvider, Class<? extends FullCalendar> customType, Collection<Entry> initialEntries, String entryContent, CustomCalendarView[] customCalendarViews) {
        this.scheduler = scheduler;
        this.entryLimit = entryLimit;
        this.autoBrowserTimezone = autoBrowserTimezone;
        this.autoBrowserLocale = autoBrowserLocale;
        this.schedulerLicenseKey = schedulerLicenseKey;
        this.initialOptions = initialOptions;
        this.entryProvider = entryProvider;
        this.customType = customType;
        this.initialEntries = initialEntries;
        this.entryContent = entryContent;
        this.customCalendarViews = customCalendarViews;
    }

    public static FullCalendarBuilder create() {
        return new FullCalendarBuilder(false, -1, false, false, null, null, null, null, null, null, null);
    }

    public FullCalendarBuilder withInitialEntries(Collection<Entry> initialEntries) {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, this.customType, Objects.requireNonNull(initialEntries), this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withCustomType(Class<? extends FullCalendar> customType) {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, Objects.requireNonNull(customType), this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withEntryProvider(EntryProvider<? extends Entry> entryProvider) {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, Objects.requireNonNull(entryProvider), this.customType, this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withScheduler() {
        return new FullCalendarBuilder(true, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, this.customType, this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withScheduler(String licenseKey) {
        return new FullCalendarBuilder(true, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, licenseKey, this.initialOptions, this.entryProvider, this.customType, this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withEntryLimit(int entryLimit) {
        return new FullCalendarBuilder(this.scheduler, entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, this.customType, this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withAutoBrowserTimezone() {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, true, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, this.customType, this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withAutoBrowserLocale() {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, this.autoBrowserTimezone, true, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, this.customType, this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withInitialOptions(ObjectNode initialOptions) {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, initialOptions, this.entryProvider, this.customType, this.initialEntries, this.entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withEntryContent(String entryContent) {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, this.customType, this.initialEntries, entryContent, this.customCalendarViews);
    }

    public FullCalendarBuilder withCustomCalendarViews(CustomCalendarView ... customCalendarViews) {
        return new FullCalendarBuilder(this.scheduler, this.entryLimit, this.autoBrowserTimezone, this.autoBrowserLocale, this.schedulerLicenseKey, this.initialOptions, this.entryProvider, this.customType, this.initialEntries, this.entryContent, customCalendarViews);
    }

    public <T extends FullCalendar> T build() {
        FullCalendar calendar = this.scheduler ? this.createFullCalendarSchedulerInstance(this.schedulerLicenseKey) : this.createFullCalendarBasicInstance();
        if (this.customCalendarViews != null && this.customCalendarViews.length > 0) {
            calendar.setCustomCalendarViews(this.customCalendarViews);
        }
        if (this.entryLimit > 0) {
            calendar.setMaxEntriesPerDay(this.entryLimit);
        }
        if (this.autoBrowserTimezone) {
            calendar.addBrowserTimezoneObtainedListener((ComponentEventListener<BrowserTimezoneObtainedEvent>)(ComponentEventListener & Serializable)event -> calendar.setTimezone(event.getTimezone()));
        }
        if (this.autoBrowserLocale) {
            calendar.setLocale(UI.getCurrent().getLocale());
        }
        if (StringUtils.isNotBlank((CharSequence)this.entryContent)) {
            calendar.setEntryContentCallback(this.entryContent);
        }
        if (this.entryProvider != null) {
            calendar.setEntryProvider(this.entryProvider);
        } else if (this.initialEntries != null) {
            ((InMemoryEntryProvider)calendar.getEntryProvider()).addEntries(this.initialEntries);
        }
        return (T)((Object)calendar);
    }

    protected FullCalendar createFullCalendarBasicInstance() {
        if (this.initialOptions != null) {
            FullCalendar calendar;
            try {
                calendar = this.customType != null ? this.customType.getDeclaredConstructor(ObjectNode.class).newInstance(this.initialOptions) : new FullCalendar(this.initialOptions);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return calendar;
        }
        try {
            return this.customType != null ? this.customType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : new FullCalendar();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected FullCalendar createFullCalendarSchedulerInstance(String schedulerLicenseKey) {
        try {
            Class<? extends FullCalendar> loadClass = this.customType != null ? this.customType : this.getClass().getClassLoader().loadClass("org.vaadin.stefan.fullcalendar.FullCalendarScheduler");
            FullCalendar scheduler = this.initialOptions != null ? loadClass.getDeclaredConstructor(ObjectNode.class).newInstance(this.initialOptions) : loadClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (schedulerLicenseKey != null) {
                ((Object)((Object)scheduler)).getClass().getMethod("setSchedulerLicenseKey", String.class).invoke((Object)scheduler, schedulerLicenseKey);
            }
            return scheduler;
        }
        catch (ClassNotFoundException ce) {
            throw new ExtensionNotFoundException("Could not find scheduler extension for FullCalendar on class path. Please check you libraries / dependencies.", ce);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ExtensionNotFoundException
    extends RuntimeException {
        public ExtensionNotFoundException() {
        }

        public ExtensionNotFoundException(String message) {
            super(message);
        }

        public ExtensionNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public ExtensionNotFoundException(Throwable cause) {
            super(cause);
        }

        public ExtensionNotFoundException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

