/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.stefan.fullcalendar;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import tools.jackson.databind.node.ObjectNode;

public class Delta {
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;

    public Delta(int years, int months, int days, int hours, int minutes, int seconds) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    @Deprecated(forRemoval=true)
    static void assertLessThan(String name, int current, int lessThanThis) {
        if (current >= lessThanThis) {
            throw new IllegalArgumentException("Value'" + name + "' must be less than or equal to '" + lessThanThis + "' (as absolute) but was '" + current + "'!");
        }
    }

    public static Delta fromJson(ObjectNode jsonObject) {
        int years = jsonObject.get("years").asInt();
        int months = jsonObject.get("months").asInt();
        int days = jsonObject.get("days").asInt();
        if (jsonObject.hasNonNull("milliseconds")) {
            long remainingMS = jsonObject.get("milliseconds").asLong();
            int hours = (int)TimeUnit.MILLISECONDS.toHours(remainingMS);
            int minutes = (int)TimeUnit.MILLISECONDS.toMinutes(remainingMS -= TimeUnit.HOURS.toMillis(hours));
            int seconds = (int)TimeUnit.MILLISECONDS.toSeconds(remainingMS -= TimeUnit.MINUTES.toMillis(minutes));
            return new Delta(years, months, days, hours, minutes, seconds);
        }
        int hours = jsonObject.get("hours").asInt();
        int minutes = jsonObject.get("minutes").asInt();
        int seconds = jsonObject.get("seconds").asInt();
        return new Delta(years, months, days, hours, minutes, seconds);
    }

    public static Delta fromLocalDates(LocalDateTime deltaFrom, LocalDateTime deltaTo) {
        return new Delta(deltaTo.getYear() - deltaFrom.getYear(), deltaTo.getMonthValue() - deltaFrom.getMonthValue(), deltaTo.getDayOfMonth() - deltaFrom.getDayOfMonth(), deltaTo.getHour() - deltaFrom.getHour(), deltaTo.getMinute() - deltaFrom.getMinute(), deltaTo.getSecond() - deltaFrom.getSecond());
    }

    public LocalDateTime applyOn(LocalDateTime dateTime) {
        return dateTime.plusYears(this.years).plusMonths(this.months).plusDays(this.days).plusHours(this.hours).plusMinutes(this.minutes).plusSeconds(this.seconds);
    }

    public LocalDate applyOn(LocalDate date) {
        return date.plusYears(this.years).plusMonths(this.months).plusDays(this.days);
    }

    public Instant applyOn(Instant instant) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return this.applyOn(localDateTime).toInstant(ZoneOffset.UTC);
    }

    @Generated
    public static DeltaBuilder builder() {
        return new DeltaBuilder();
    }

    @Generated
    public int getYears() {
        return this.years;
    }

    @Generated
    public int getMonths() {
        return this.months;
    }

    @Generated
    public int getDays() {
        return this.days;
    }

    @Generated
    public int getHours() {
        return this.hours;
    }

    @Generated
    public int getMinutes() {
        return this.minutes;
    }

    @Generated
    public int getSeconds() {
        return this.seconds;
    }

    @Generated
    public String toString() {
        return "Delta(years=" + this.getYears() + ", months=" + this.getMonths() + ", days=" + this.getDays() + ", hours=" + this.getHours() + ", minutes=" + this.getMinutes() + ", seconds=" + this.getSeconds() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delta)) {
            return false;
        }
        Delta other = (Delta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getYears() != other.getYears()) {
            return false;
        }
        if (this.getMonths() != other.getMonths()) {
            return false;
        }
        if (this.getDays() != other.getDays()) {
            return false;
        }
        if (this.getHours() != other.getHours()) {
            return false;
        }
        if (this.getMinutes() != other.getMinutes()) {
            return false;
        }
        return this.getSeconds() == other.getSeconds();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYears();
        result = result * 59 + this.getMonths();
        result = result * 59 + this.getDays();
        result = result * 59 + this.getHours();
        result = result * 59 + this.getMinutes();
        result = result * 59 + this.getSeconds();
        return result;
    }

    @Generated
    public static class DeltaBuilder {
        @Generated
        private int years;
        @Generated
        private int months;
        @Generated
        private int days;
        @Generated
        private int hours;
        @Generated
        private int minutes;
        @Generated
        private int seconds;

        @Generated
        DeltaBuilder() {
        }

        @Generated
        public DeltaBuilder years(int years) {
            this.years = years;
            return this;
        }

        @Generated
        public DeltaBuilder months(int months) {
            this.months = months;
            return this;
        }

        @Generated
        public DeltaBuilder days(int days) {
            this.days = days;
            return this;
        }

        @Generated
        public DeltaBuilder hours(int hours) {
            this.hours = hours;
            return this;
        }

        @Generated
        public DeltaBuilder minutes(int minutes) {
            this.minutes = minutes;
            return this;
        }

        @Generated
        public DeltaBuilder seconds(int seconds) {
            this.seconds = seconds;
            return this;
        }

        @Generated
        public Delta build() {
            return new Delta(this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
        }

        @Generated
        public String toString() {
            return "Delta.DeltaBuilder(years=" + this.years + ", months=" + this.months + ", days=" + this.days + ", hours=" + this.hours + ", minutes=" + this.minutes + ", seconds=" + this.seconds + ")";
        }
    }
}

